<?php
/**
 * Template Name: Useful Links Page
 */
get_header();
?>

<main>

  <!-- breadcam-area-start -->
  <div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
    <div class="container">
      <div class="row">
        <div class="col-lg-12 px-0">
          <div class="tp-breadcrumb-content">
            <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
              Useful Links</h2>
            <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
              <span><a href="<?php echo home_url(); ?>">Home</a></span>
              <span class="tp-breadcrumb-dvdr">-</span>
              <span class="tp-breadcrumb-title-pre">Useful Links</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- breadcam-area-end -->

  <!--content section-->
  <div class="content-main bg-pages">
    <div class="container">

      <!--links-->
      <div class="row">
        <div class="col-md-12 mb-4">

    <div class="tp-postbox-list-inner">
  <?php
  $args = array(
    'post_type' => 'useful_link',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC'
  );
  $links = new WP_Query($args);

  if ($links->have_posts()):
    while ($links->have_posts()): $links->the_post();
      $url = get_field('link_url'); // ACF field for URL
        $urltext = get_field('link_text');
  ?>
    <span>
      <i class="fa-solid fa-check"></i>
      <a href="<?php echo esc_url($url); ?>" target="_blank"><?php echo $urltext; ?></a>
    </span>
    <hr>
  <?php
    endwhile;
    wp_reset_postdata();
  else:
    echo '<p>No useful links found.</p>';
  endif;
  ?>
</div>


        </div>
      </div>
      <!--links-->

    </div>
  </div>
  <!--content section-->

</main>

<?php get_footer(); ?>
