<?php
/*
Template Name: RTI Page
*/

get_header();
?>
<!-- Breadcrumb Area Start -->
  <div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
         <div class="container">
            <div class="row">
               <div class="col-lg-12 px-0">
                  <div class="tp-breadcrumb-content">
                     <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
                     <?php the_title(); ?></h2>
                     <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                        <span><a href="<?php echo home_url(); ?>">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
<!-- Breadcrumb Area End -->

<!-- Content Section Start -->
<div class="content-main">
   <div class="container">
      
            <!--1-->
            <div class="tp-service-details-quick tp-service-details-list-2 mb-60">
                <h4 class="mb-30 fs-4">Right to Information Act 2005 – Publication of Information</h4>
                <p class="mb-3">The Government of India, in order to ensure greater and more effective access of information to the citizens has enacted ‘Right to Information Act, 2005’ [hereinafter called RTI Act]. The Act came into force from 12-10-2005.</p>
                <p class="mb-3">The main object of the Act is to provide right to information and to secure access of information under the control of the Public Authorities to the citizens in order to promote transparency and accountability in the working of Public Authority.</p>
                <p class="mb-3">The right to information includes an access of information which is held by or under the control of any public authority and includes the right to inspect the work, document, records, taking notes, extracts or certified copies of documents / records and certified samples of the materials and obtaining information which is also stored in electronic form.</p>
                <p class="mb-3">The Act provides under Sections 8 and 9, certain categories of information that are exempt from disclosure to the citizens. The public may also refer to the relative sections of the Act before submitting a request for information.</p>
                <p class="mb-3">Any citizen can request for information by making an application in writing in English / official language of the area, in which the application is being made together with the prescribed fees, to the concerned Public Information Officer.’</p>
                <p>Keeping in view provisions of the RTI Act, we hereby provide the information as per terms of Sec. 4[1] of the RTI Act.</p>
            </div>
            <!--1-->
      <div class="row">
         <?php
         // Custom Query to get RTI posts
         $args = array(
            'post_type' => 'rti',
            'posts_per_page' => -1,
         );

         $rti_query = new WP_Query($args);

         if ($rti_query->have_posts()) :
            while ($rti_query->have_posts()) : $rti_query->the_post();
         ?>
           <div class="col-md-6 mb-4">
                    <div class="d-flex tp-feature-wrapper align-items-center justify-content-between">
                        <div>
                            <h5 class="mb-1"><?php the_title(); ?></h5>
                
                 <p class="text-muted mb-1"><?php echo wpautop(wp_kses_post(get_the_content())); ?></p>
  </div>
               <div class="text-end">
                
               </div>

               
            </div>
         </div>
         <?php
            endwhile;
            wp_reset_postdata();
         else :
         ?>
         <div class="col-12">
            <p>No RTI records found.</p>
         </div>
         <?php endif; ?>
      </div>
       <!--3-->
            <div class="tp-service-details-quick tp-service-details-list-2 mb-60 rti">
                <h4 class="mb-30 fs-4">The right to information (regulation of fee and cost) rules, 2005</h4>

                <h5>How to get Information</h5>

                <p class="mb-3">TCitizens can seek information about the activities of The Kerala Toddy Industry Development Board (KTIDB) by submitting a written request with details like Name, address, contact telephone number and particulars of the information sought. The reason for seeking request need not be disclosed to the Public Information Officer. If the reply is not received in time or if the information is not given, you can appeal to the Appellate Authority.</p>

                <h5>Procedure for Seeking Information</h5>
                <p class="mb-3">A request for obtaining information under sub-section (1) of section 6 of the Act shall be made to the concerned State Public Information Officer or through the State Assistant Public Information Officer, as the case may be, accompanied by an application fee of rupees ten.</p>
                <p class="mb-3">The application fee shall be paid in any of the following manners, namely:-</p>
                <div class="tp-service-details-list-2">
                    <ul>
                       <li class="mb-20">
                          <span><i class="flaticon-checkmark"></i></span>
                          <p class="m-0">By cash remittance against proper receipt in the office of the State Public Information Officer/State Assistant Public Information Officer, as the case may be; or
                            </p>
                       </li>
                       <li class="mb-20">
                          <span><i class="flaticon-checkmark"></i></span>
                          <p class="m-0">By demand draft payable to Managing Director, Roads and Bridges Development Corporation of Kerala Limited; payable at Ernakulam.
                            </p>
                       </li>
                    </ul>
                </div>
            </div>
            <!--3-->

            <!--4-->
            <div class="tp-service-details-quick tp-service-details-list-2 mb-60 rti">
                <h4 class="mb-30 fs-4">Gist of Fee Structure</h4>

                <h5>What is the effective date for the Right To Information (Regulation of Fee and Cost) Rules, 2005?
                </h5>
                <p class="mb-3">The Rules shall come into force on the date of its publication in the Official Gazette.</p>

                <h5>Whether any amount is to be given along with the application for information U/S 6 (1) of the RTI Act?</h5>
                <p class="mb-3">Yes, the request for information under Section 6 (1) of the RTI Act, shall be accompanied by an application fee of Rs. 10/- (Rupees Ten Only).</p>

                <h5>What is the rate of application fee to be accompanied along with the request for information U/S 7 (1) of the RTI Act?</h5>
                <p class="mb-3">The information under Section 7 (1) of the RTI Act, shall be charged in the following rates:</p>
                <div class="tp-service-details-list-2">
                    <ul>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Rs. 3/- (Rupees Three only) for each page in A-4 size paper, created or copied;</p>
                        </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Actual charge or cost price of a copy in larger size paper</p>
                        </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Actual cost or price for samples or models; and</p>
                            </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">For inspection of records, no fee for the first hour; and a fee of Rs. 10/- (Rupees Ten only) for each Thirty minutes (or fraction thereof) thereafter.</p>
                        </li>
                    </ul>
                    <h5>Whether any fee can be collected from the persons categorized as below poverty line?</h5>
                    <p class="mb-3">No. In case the request for information is given by a person belongs the category below poverty line, then in such case the information shall be given free of cost.</p>
                    <h5>How the application fee can be paid by the person seeking information?</h5>
                    <p class="mb-0">The application fee may be remitted by way of cash against proper receipt or by way of DD.</p>
                </div>
            </div>
            <!--4-->

            <!--5-->
            <div class="tp-service-details-quick tp-service-details-list-2 mb-60 rti">
                <h4 class="mb-30 fs-4">Instruction to Applicants</h4>

                <p class="mb-3">An application under RTI Act, 2005 should contain the following:</p>
                <div class="tp-service-details-list-2">
                    <ul>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Name and address of the applicant for communication</p>
                        </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Nature of request should be specific.</p>
                        </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Application fee can be remitted by way of DD or cash, made payable to the Managing Director, Roads and Bridges Development Corporation of Kerala Limited at Ernakulam. Persons living below poverty line are exempted from payment of application fee of Rs. 10/-, if they produce BPL Certificate issued by the Competent Authority.</p>
                            </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Applicants should submit their RTI application to the concerned Public Information Officer. The name and address of the PIO and others are mentioned above.</p>
                        </li>
                        <li class="mb-20">
                            <span><i class="flaticon-checkmark"></i></span>
                            <p class="m-0">Applicants and the public are requested to refer to the Right to Information Act, 2005 for further information or clarification.</p>
                        </li>
                    </ul>
                </div>
            </div>
            <!--5-->

            <!--6-->
            <div class="tp-service-details-quick tp-service-details-list-2 mb-60">
                <h4 class="mb-30 fs-4">Right to Appeal</h4>
                <p class="mb-3">If the applicant is not satisfied with the reply/information provided by the Public Information Officer of the company, Applicant can file the First Appeal before the concerned First Appellate Authority, against the decision of the Public Information Officer.</p>
                <p class="mb-0">The Applicant still has right to Second Appeal before the State Information Commissioner, Thiruvananthapuram against the decision of the First Appellate Authority. For further information/details visit website of Central Information Commission : <a href="http://www.cic.gov.in" target="_blank">www.cic.gov.in</a></p>
            </div>
            <!--6-->
   </div>
</div>
<!-- Content Section End -->
<?php
get_footer();
