<?php
/**
 * Template Name: Gallery Page
 */
get_header();
?>

<!-- Breadcrumb Area Start -->
  <div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
         <div class="container">
            <div class="row">
               <div class="col-lg-12 px-0">
                  <div class="tp-breadcrumb-content">
                     <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
                     <?php the_title(); ?></h2>
                     <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                        <span><a href="<?php echo home_url(); ?>">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
<!-- Breadcrumb Area End -->
 <!--content section-->
 <div class="content-main">
         <div class="container">
            
            
        
<!-- Gallery Filters -->
<?php
$terms = get_terms('gallery_category');
?>

<div class="gallery-categories row">
<?php
$terms = get_terms([
    'taxonomy' => 'gallery_category',
    'hide_empty' => false
]);
foreach ($terms as $term) {
    $image = get_field('cover_image', 'gallery_category_' . $term->term_id); // ACF image field
    if (!$image) continue;

    $link = esc_url(site_url('/gallery-category-page/?term_id=' . $term->term_id));

    echo '<div class="col-md-4 text-center mb-4"><div class="gallery-category-item">';
    echo '<a href="' . $link . '">';
    echo '<img src="' . esc_url($image['url']) . '" class="img-fluid mb-2" alt="' . esc_attr($term->name) . '" />';
    echo '<h5>' . esc_html($term->name) . '</h5>';
    echo '</a>';
    echo '</div></div>';
}

?>
</div></div></div>
<div id="gallery-items-container" class="row mt-4"></div>

<?php get_footer(); ?>
