<?php
/* Template Name: Directors Page */
get_header(); ?>

<!-- Breadcrumb Area -->
<div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 px-0">
                <div class="tp-breadcrumb-content">
                    <h2 class="tp-breadcrumb-title mb-15"><?php the_title(); ?></h2>
                    <div class="tp-breadcrumb-list">
                        <span><a href="<?php echo home_url(); ?>">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Content Section -->
<div class="content-main py-5">
    <div class="container">

        <?php
        // Define positions to exclude
        $excluded_positions = array(
            'Chief Minister, Kerala',
            'Minister for Excise & Local Self Government'
        );

        $args = array(
            'post_type' => 'director',
            'posts_per_page' => -1,
            'orderby' => 'menu_order',
            'order' => 'ASC'
        );
        $query = new WP_Query($args);

        $members = [];
        $others = [];

        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
                $title = get_the_title();
                $thumbnail = get_the_post_thumbnail(get_the_ID(), 'medium');
                $position = get_field('position');
                if (!$position) $position = 'Member'; // default if empty

                // Skip excluded positions
                if (in_array($position, $excluded_positions)) {
                    continue;
                }

                $person = array(
                    'title' => $title,
                    'thumbnail' => $thumbnail,
                    'position' => $position
                );

                if (strtolower(trim($position)) === 'member') {
                    $members[] = $person;
                } else {
                    $others[] = $person;
                }

            endwhile;
            wp_reset_postdata();
        endif;

        function render_directors($group) {
            if (!empty($group)) {
                echo '<div class="row">';
                foreach ($group as $person) {
                    echo '<div class="col-lg-3 col-md-4 col-sm-6 mb-4 text-center">
                        <div class="p-3 border rounded h-100">
                            <div class="mb-3">' . $person['thumbnail'] . '</div>
                            <h5 class="mb-1">' . esc_html($person['title']) . '</h5>
                            <p class="text-muted">' . esc_html($person['position']) . '</p>
                        </div>
                    </div>';
                }
                echo '</div>';
            } else {
                echo '<p>No data found.</p>';
            }
        }
        ?>

        <!-- Top Section: Chairman, Managing Director, etc. -->
        <div class="directors-top-section mb-5">
            <?php render_directors($others); ?>
        </div>

        <!-- Bottom Section: Only Members -->
        <div class="directors-member-section border-top pt-5 mt-5">
            <h3 class="mb-4">Members</h3>
            <?php render_directors($members); ?>
        </div>

    </div>
</div>

<?php get_footer(); ?>
