<?php
/*
Template Name: Contact Page
*/
get_header(); ?>
<main class="site-main">


<!-- breadcam-area-start -->
<div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 px-0">
                <div class="tp-breadcrumb-content">
                    <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s"
                        data-wow-delay=".3s">Contact Us</h2>
                    <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                        <span><a href="index.html">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre">Contact Us</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcam-area-end -->


<!-- tp-contact-item-area-start -->
<div class="tp-contact-item-area pt-80 mb-10">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-6 mb-50 wow fadeInUp" data-wow-duration=".9s" data-wow-delay=".3s">
                <div class="tp-contact-item-2 text-center">
                    <div class="tp-contact-icon mb-20">
                        <span><i class="flaticon-location"></i></span>
                    </div>
                    <div class="tp-contact-content">
                        <h4 class="tp-contact-title-3">Visit Our Place</h4>
                        <span><?php the_field('contact_address_'); ?></span>
                </span>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 mb-50 wow fadeInUp" data-wow-duration=".9s" data-wow-delay=".4s">
                <div class="tp-contact-item-2 text-center">
                    <div class="tp-contact-icon mb-20">
                        <span><i class="flaticon-mail"></i></span>
                    </div>
                    <div class="tp-contact-content">
                        <h4 class="tp-contact-title-3">Contact Us</h4>
                        <span translate="no"><a href="mailto:<?php the_field('email_'); ?>"><?php the_field('email_'); ?></a></span>
                        <span><a href="tel:<?php the_field('phone_number'); ?>"><?php the_field('phone_number'); ?></a></span>
                        <br>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-50 wow fadeInUp" data-wow-duration=".9s" data-wow-delay=".5s">
                <div class="tp-contact-item-2 text-center">
                    <div class="tp-contact-icon mb-20">
                        <span><i class="flaticon-clock-time"></i></span>
                    </div>
                    <div class="tp-contact-content">
                        <h4 class="tp-contact-title-3">Office Time</h4>
                        <span><?php the_field('office_time'); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- tp-contact-item-area-end -->

<!-- contact-form-area-start -->
<div class="tp-contact-form-area pb-140">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
            <div class="tp-contact-form-2">
               <h3 class="tp-contact-form-title-2 mb-40">Send your message</h3>
                 <?php echo do_shortcode('[contact-form-7 id="00833fb" title="KTIDB Contact Form"]'); ?>
               
            
                </div>

            </div>
        </div>
    </div>
</div>
<!-- contact-form-area-end -->

<!-- map area start  -->
<div class="tp-map-area fix">
    <div class="container-fluid p-0">
        <div class="row">
            <div class="col-xl-12">
                <div class="tp-contact-map-box">
                    <iframe
                        src=" <?php the_field('map_embed_code'); ?>"
                        height="535" style="border:0;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- map area end  -->
</main>
<?php get_footer(); ?>
