<?php
/*
Template Name: About Page
*/
get_header(); ?>
   <!-- breadcam-area-start -->
  <div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
         <div class="container">
            <div class="row">
               <div class="col-lg-12 px-0">
                  <div class="tp-breadcrumb-content">
                     <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
                     <?php the_title(); ?></h2>
                     <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                        <span><a href="<?php echo home_url(); ?>">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- breadcam-area-end -->

<?php
$image = get_field('ktidb_about_image');
$description = get_field('description');
$vision = get_field('vision_statement');
$mission = get_field('mission_statement');
?>

<div class="content-main">
    <div class="container">
   <!--1-->
                <div class="row">
                    <div class="col-md-12">
                    <h3 class="tp-service-details-title mb-20">Kerala Toddy Industry Development Board</h3>
                    <?= wp_kses_post($description); ?> </div>
                </div>
                <!--1-->

      <!--2-->
                <div class="row tp-feature-spacing justify-content-center mt-50">
                   <?php 
$args = array(
    'post_type' => 'director',
    'posts_per_page' => -1,
    'orderby' => 'menu_order',
    'order' => 'DESC'
);
$query = new WP_Query($args);

$allowed_positions = array(
    'Chief Minister, Kerala',
    'Chairman',
    'Minister for Excise & Local Self Government'
);

if ($query->have_posts()) :
    while ($query->have_posts()) : $query->the_post();
        $name = get_the_title();
        $position = get_field('position');
        
        if (in_array($position, $allowed_positions)) :
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            if (!$image_url) {
                $image_url = get_template_directory_uri() . '/assets/img/default.png';
            }
?>
    <div class="col-xl-4 col-lg-4 col-md-6 mb-30 wow fadeInUp" data-wow-duration=".9s" data-wow-delay=".2s">
        <div class="tp-feature-wrapper text-center">
            <div class="mb-25">
                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($name); ?>">
            </div>
            <div class="tp-feature-content">
                <h4 class="tp-feature-title mb-10"><?php echo esc_html($name); ?></h4>
                <p class="tp-feature-para"><?php echo esc_html($position); ?></p>
            </div>
        </div>
    </div>
<?php 
        endif;
    endwhile;
    wp_reset_postdata();
endif;
?>

            </div>
                <!--2-->

        <div class="tp-about-content-wrapper">

            <div class="tp-service-details-quick tp-service-details-list-2 mb-60">
                <h4 class="mb-30 fs-3">Vision Statement</h4>
                <?= wp_kses_post($vision); ?>
            </div>

            <div class="tp-about-section-title-wrapper mb-20 mt-30">
                <h4 class="mb-30 fs-3">Mission Statements</h4>
            </div>
            <div class="tp-about-info mb-55">
                <div class="tp-service-details-list-2 mb-60">
                    <?= wp_kses_post($mission); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
