<?php
/**
 * Template Name: Gallery Category Page
 */
get_header(); ?>

<!-- Breadcrumb Area Start -->
  <div class="tp-breadcrumb-area tp-breadcrumb-spacing bg-position" data-background="<?php echo get_template_directory_uri(); ?>/assets/img/01.jpg">
         <div class="container">
            <div class="row">
               <div class="col-lg-12 px-0">
                  <div class="tp-breadcrumb-content">
                     <h2 class="tp-breadcrumb-title mb-15 wow fadeInRight" data-wow-duration=".9s" data-wow-delay=".3s">
                     <?php the_title(); ?></h2>
                     <div class="tp-breadcrumb-list wow fadeInLeft" data-wow-duration=".9s" data-wow-delay=".3s">
                        <span><a href="index.html">Home</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span><a href="<?php echo home_url(); ?>/gallery">Gallery Category</a></span>
                        <span class="tp-breadcrumb-dvdr">-</span>
                        <span class="tp-breadcrumb-title-pre"><?php the_title(); ?></span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
<!-- Breadcrumb Area End -->

<?php
$term_id = isset($_GET['term_id']) ? intval($_GET['term_id']) : 0;
$term = get_term($term_id, 'gallery_category');
?>

<div class="container my-5">
   <!-- <a href="<?php echo site_url('/gallery'); ?>" class="btn btn-secondary mb-4">← Back to Categories</a>-->

    <?php if ($term): ?>
        <h2 class="mb-4"><?php echo esc_html($term->name); ?></h2>

        <div class="row">
        <?php
        $query = new WP_Query([
            'post_type' => 'ktidb_gallery',
            'posts_per_page' => -1,
            'tax_query' => [[
                'taxonomy' => 'gallery_category',
                'field' => 'term_id',
                'terms' => $term_id
            ]]
        ]);

        if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
                $img = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                ?>
                <div class="col-md-4 text-center mb-4"><div class="gallery-category-item">
                    <a href="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>" data-lightbox="gallery">
                        <img src="<?php echo esc_url($img); ?>" class="img-fluid  mb-2" />
                    </a>
                    <h5><?php echo esc_html(get_the_title()); ?></h5> <!-- show image title -->
            </div>
                </div>
                <?php
            endwhile;
            wp_reset_postdata();
        else:
            echo '<p>No images found in this category.</p>';
        endif;
        ?>
        </div>
    <?php else: ?>
        <p>Invalid category selected.</p>
    <?php endif; ?>
</div>

<?php get_footer(); ?>
