<?php
function ktidb_enqueue_scripts()
{
    $theme_uri = get_template_directory_uri();

    // CSS
    wp_enqueue_style('ktidb-bootstrap', $theme_uri . '/assets/css/bootstrap.css');
    wp_enqueue_style('ktidb-main', $theme_uri . '/assets/css/main.css');
    wp_enqueue_style('ktidb-spacing', $theme_uri . '/assets/css/spacing.css');
    wp_enqueue_style('ktidb-toddy', $theme_uri . '/assets/css/toddy-style.css');
    wp_enqueue_style('font-awesome', $theme_uri . '/assets/css/font-awesome-pro.css');
    wp_enqueue_style('flaticon', $theme_uri . '/assets/css/flaticon.css');

    // JS
    wp_enqueue_script('jquery');
    wp_enqueue_script('ktidb-bootstrap-bundle', $theme_uri . '/assets/js/bootstrap-bundle.js', ['jquery'], null, true);
    wp_enqueue_script('ktidb-popup', $theme_uri . '/assets/js/magnific-popup.js', ['jquery'], null, true);
    wp_enqueue_script('ktidb-purecounter', $theme_uri . '/assets/js/purecounter.js', [], null, true);
    wp_enqueue_script('ktidb-wow', $theme_uri . '/assets/js/wow.js', [], null, true);
    wp_enqueue_script('ktidb-main', $theme_uri . '/assets/js/main.js', ['jquery'], null, true);
}
add_action('wp_enqueue_scripts', 'ktidb_enqueue_scripts');


// Add Top Level Admin Menu
function ktidb_register_main_menu()
{
    add_menu_page(
        'KTIDB Home',      // Page title
        'Home Page',               // Menu title
        'edit_posts',      // Capability
        'ktidb-main',          // Menu slug
        '',                    // Callback (empty for now)
        'dashicons-admin-site-alt3', // Icon
        2                      // Position (optional)
    );
    add_menu_page(
        'About Us',      // Page title
        'About Us',               // Menu title
        'edit_posts',      // Capability
        'ktidb-about',          // Menu slug
        '',                    // Callback (empty for now)
        'dashicons-admin-site-alt3', // Icon
        3                      // Position (optional)
    );
}
add_action('admin_menu', 'ktidb_register_main_menu');


add_action('after_setup_theme', function () {
    add_theme_support('elementor');
});

//Register a Custom Post Type for Banners

function ktidb_register_banner_cpt()
{
    register_post_type('banner', [
        'labels' => [
            'name' => 'Banners',
            'singular_name' => 'Banner',
        ],
        'public' => true,
        'menu_icon' => 'dashicons-images-alt2',
        'supports' => ['title'],
        'has_archive' => false,
        'show_in_rest' => true,
        'show_in_menu' => 'ktidb-main',
        // ✅ Allow Editor-level access by using default post capabilities
        'capability_type' => 'post',
        'map_meta_cap' => true,
    ]);
}
add_action('init', 'ktidb_register_banner_cpt');




// Register a Custom Post Type for About Us
function ktidb_register_about_cpt()
{
    register_post_type('about_ktidb', [
        'labels' => [
            'name' => 'About',
            'singular_name' => 'About Us Section',
        ],
        'public' => true,
        'menu_icon' => 'dashicons-id',
        'supports' => ['title', 'editor'],
        'has_archive' => false,
        'show_in_rest' => true,
        'show_in_menu' => 'ktidb-main'
    ]);
}
add_action('init', 'ktidb_register_about_cpt');

//Custom Post Type for News
function ktidb_register_news_cpt()
{
    register_post_type('ktidb_news', [
        'labels' => [
            'name' => 'News',
            'singular_name' => 'News toddy',
        ],
        'public' => true,
        'has_archive' => true, // ✅ this enables the /news/ page
        'rewrite' => ['slug' => 'news-announcements'], // optional, defines URL
        'menu_icon' => 'dashicons-megaphone',
        'supports' => ['title', 'editor'],
        'show_in_rest' => true,
        'menu_position' => 24
        //'show_in_menu' => 'ktidb-main'
    ]);
}
add_action('init', 'ktidb_register_news_cpt');

function ktidb_news_shortcode($atts)
{
    ob_start();

    $news_query = new WP_Query([
        'post_type' => 'ktidb_news',
        'posts_per_page' => 10,
        'orderby' => 'date',
        'order' => 'DESC',
    ]);

    if ($news_query->have_posts()) : ?>
        <div class="news-shortcode-wrap">
            <marquee onmouseover="this.stop();" onmouseout="this.start();" scrollamount="5" direction="up" style="height: 260px;">
                <?php while ($news_query->have_posts()) : $news_query->the_post(); ?>
                    <div class="news-item">
                        <a href="<?php the_permalink(); ?>">
                            <p><?php the_title(); ?></p>
                        </a>

                        <?php
                        $pdfs = get_field('attachment');
                        if ($pdfs) {
                            $pdf_array = json_decode($pdfs, true);
                            if (is_array($pdf_array)) {
                                echo '<ul class="news-pdfs">';
                                foreach ($pdf_array as $pdf) {
                                    echo '<li><a href="' . esc_url($pdf) . '" target="_blank"><i class="fa fa-file-pdf-o"></i> ' . basename($pdf) . '</a></li>';
                                }
                                echo '</ul>';
                            }
                        }
                        ?>
                    </div>
                <?php endwhile; ?>
            </marquee>
            <a href="<?php echo get_post_type_archive_link('ktidb_news'); ?>" class="tp-btn p-3">
                View More <i class="fa fa-angle-double-right" aria-hidden="true"></i>
            </a>
        </div>
    <?php else :
        echo '<p>No news available right now.</p>';
    endif;

    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('ktidb_news', 'ktidb_news_shortcode');

/////////////Multiple file uplaod


// Add metabox
add_action('add_meta_boxes', function () {
    add_meta_box(
        'ktidb_news_attachments',
        'News Attachments',
        'ktidb_news_attachments_callback',
        'ktidb_news',
        'normal',
        'default'
    );
});

function ktidb_news_attachments_callback($post)
{
    wp_nonce_field('ktidb_news_attachments_nonce', 'ktidb_news_attachments_nonce_field');

    $attachments = get_post_meta($post->ID, 'ktidb_news_attachments', true);
    if (!is_array($attachments)) $attachments = [];

    ?>
    <div id="ktidb-news-attachments-container">
        <?php foreach ($attachments as $id):
            $url = wp_get_attachment_url($id); ?>
            <div class="ktidb-attachment-item" style="margin-bottom:8px;">
                <a href="<?php echo esc_url($url); ?>" target="_blank"><?php echo basename($url); ?></a>
                <input type="hidden" name="ktidb_news_attachments[]" value="<?php echo esc_attr($id); ?>">
                <button class="remove-attachment button">Remove</button>
            </div>
        <?php endforeach; ?>
    </div>
    <p>
        <button type="button" class="button" id="add-ktidb-attachments">Add Files</button>
    </p>

    <script nonce="<?php echo csp_nonce(); ?>">
        jQuery(document).ready(function($) {
            var file_frame;
            $('#add-ktidb-attachments').on('click', function(e) {
                e.preventDefault();
                if (file_frame) file_frame.close();
                file_frame = wp.media({
                    title: 'Select Attachments',
                    button: {
                        text: 'Add Files'
                    },
                    multiple: true
                });
                file_frame.on('select', function() {
                    var selection = file_frame.state().get('selection');
                    selection.map(function(attachment) {
                        attachment = attachment.toJSON();
                        var html = '<div class="ktidb-attachment-item" style="margin-bottom:8px;">' +
                            '<a href="' + attachment.url + '" target="_blank">' + attachment.filename + '</a>' +
                            '<input type="hidden" name="ktidb_news_attachments[]" value="' + attachment.id + '">' +
                            '<button class="remove-attachment button">Remove</button>' +
                            '</div>';
                        $('#ktidb-news-attachments-container').append(html);
                    });
                });
                file_frame.open();
            });

            $(document).on('click', '.remove-attachment', function(e) {
                e.preventDefault();
                $(this).closest('.ktidb-attachment-item').remove();
            });
        });
    </script>
<?php
}

// Save metabox data
add_action('save_post', function ($post_id) {
    if (
        !isset($_POST['ktidb_news_attachments_nonce_field']) ||
        !wp_verify_nonce($_POST['ktidb_news_attachments_nonce_field'], 'ktidb_news_attachments_nonce')
    ) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    $attachments = isset($_POST['ktidb_news_attachments']) ? array_map('intval', $_POST['ktidb_news_attachments']) : [];
    update_post_meta($post_id, 'ktidb_news_attachments', $attachments);
});

add_action('acf/input/admin_footer', function () {
?>
    <script nonce="<?php echo csp_nonce(); ?>">
        (function($) {
            $(document).on('click', '.acf-file-uploader .acf-button', function(e) {
                var frame = wp.media({
                    title: 'Select PDFs',
                    library: {
                        type: 'application/pdf'
                    },
                    multiple: true
                });

                frame.on('select', function() {
                    var selection = frame.state().get('selection');
                    var files = [];
                    selection.map(function(attachment) {
                        attachment = attachment.toJSON();
                        files.push(attachment.url);
                    });
                    // Store multiple URLs in a hidden textarea or JSON field
                    var field = $(e.currentTarget).closest('.acf-field').find('input[type="text"]');
                    field.val(JSON.stringify(files));
                });

                frame.open();
                return false;
            });
        })(jQuery);
    </script>
<?php
});


////////search
function ktidb_include_custom_post_types_in_search($query)
{
    if ($query->is_search && !is_admin()) {
        $query->set('post_type', ['post', 'page', 'ktidb_news']);
    }
    return $query;
}
add_filter('pre_get_posts', 'ktidb_include_custom_post_types_in_search');

///////////RTI
function register_rti_post_type()
{
    $args = [
        'label' => 'RTI',
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 22,
        'has_archive' => false,
        'rewrite' => false, // Important
        'supports' => ['title', 'editor'],
    ];
    register_post_type('rti', $args);
}
add_action('init', 'register_rti_post_type');



// Register Custom Post Type for Opportunities
function register_opportunity_post_type()
{
    $labels = array(
        'name'                  => _x('Opportunities', 'Post Type General Name', 'textdomain'),
        'singular_name'         => _x('Opportunity', 'Post Type Singular Name', 'textdomain'),
        'menu_name'             => __('Opportunities', 'textdomain'),
        'name_admin_bar'        => __('Opportunity', 'textdomain'),
        'add_new'               => __('Add New', 'textdomain'),
        'add_new_item'          => __('Add New Opportunity', 'textdomain'),
        'edit_item'             => __('Edit Opportunity', 'textdomain'),
        'new_item'              => __('New Opportunity', 'textdomain'),
        'view_item'             => __('View Opportunity', 'textdomain'),
        'search_items'          => __('Search Opportunities', 'textdomain'),
        'not_found'             => __('No opportunities found', 'textdomain'),
        'not_found_in_trash'    => __('No opportunities found in Trash', 'textdomain'),
        'all_items'             => __('All Opportunities', 'textdomain'),
    );

    $args = array(
        'label'                 => __('Opportunity', 'textdomain'),
        'description'           => __('Job opportunities', 'textdomain'),
        'labels'                => $labels,
        'supports'              => array('title', 'editor', 'thumbnail', 'revisions'),
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position' => 26,
        'menu_icon'             => 'dashicons-businessperson',
        'has_archive'           => true,
        'rewrite'               => array('slug' => 'opportunities'),
    );

    register_post_type('career', $args);
}
add_action('init', 'register_opportunity_post_type');

/*
// Register Custom Post Type for Careers
function register_career_post_typeold() {
    $labels = array(
        'name'                  => _x( 'Careers', 'Post Type General Name', 'textdomain' ),
        'singular_name'         => _x( 'Career', 'Post Type Singular Name', 'textdomain' ),
        'menu_name'             => __( 'Careers', 'textdomain' ),
        'name_admin_bar'        => __( 'Career', 'textdomain' ),
    );

    $args = array(
        'label'                 => __( 'Career', 'textdomain' ),
        'description'           => __( 'Career opportunities', 'textdomain' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'thumbnail', 'revisions' ), // editor for description
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_icon'             => 'dashicons-businessperson',
        'has_archive'           => true,
        'rewrite'               => array( 'slug' => 'careers' ),
    );

    register_post_type( 'career', $args );
}
add_action( 'init', 'register_career_post_type' );
*/


//Gallery
function remove_add_new_gallery_image_submenu()
{
    // Remove the submenu "Add New Gallery Image" under custom post type 'ktidb_gallery'
    remove_submenu_page('edit.php?post_type=ktidb_gallery', 'post-new.php?post_type=ktidb_gallery_image');
}
add_action('admin_menu', 'remove_add_new_gallery_image_submenu', 999);

function ktidb_register_gallery_cpt()
{
    register_post_type('ktidb_gallery', [
        'labels' => [
            'name' => __('Gallery'),
            'singular_name' => __('Gallery Item'),
            'add_new' => __('Add New Image'),
            'add_new_item' => __('Add New Gallery Image'),
            'edit_item' => __('Edit Gallery Image'),
            'new_item' => __('New Gallery Image'),
            'view_item' => __('View Gallery Image'),
            'search_items' => __('Search Gallery'),
        ],
        'public' => true,
        'has_archive' => false,
        'menu_icon' => 'dashicons-format-gallery',
        'supports' => ['title', 'thumbnail'],
        'show_in_rest' => true,
        'menu_position' => 23,
    ]);
}
add_action('init', 'ktidb_register_gallery_cpt');


function ktidb_register_gallery_taxonomy()
{
    register_taxonomy('gallery_category', 'ktidb_gallery', [
        'labels' => [
            'name' => __('Gallery Categories'),
            'singular_name' => __('Gallery Category'),
        ],
        'hierarchical' => true,
        'show_in_rest' => true,
        'supports' => array('title', 'thumbnail'),
    ]);
}
add_action('init', 'ktidb_register_gallery_taxonomy');

// Enable featured images
add_theme_support('post-thumbnails');

// Add thumbnail support for custom post type 'gallery'
add_action('init', function () {
    add_post_type_support('gallery', 'thumbnail');
});



function enqueue_gallery_scripts_conditionally()
{
    if (is_page_template('page-gallery.php')) {
        // Isotope
        wp_enqueue_script('isotope', 'https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js', [], null, true);

        // Lightbox
        wp_enqueue_script('lightbox2', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/js/lightbox.min.js', [], null, true);
        wp_enqueue_style('lightbox2', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/css/lightbox.min.css', [], null);

        // Custom Gallery Script
        wp_enqueue_script('ktidb-gallery', get_template_directory_uri() . '/assets/js/gallery.js', ['jquery', 'isotope', 'lightbox2'], null, true);

        wp_localize_script('ktidb-gallery', 'ajax_object', [
            'ajax_url' => admin_url('admin-ajax.php'),
        ]);
    }
    // Lightbox2 CSS & JS
    wp_enqueue_style('lightbox-css', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css');
    wp_enqueue_script('lightbox-js', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js', ['jquery'], null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_gallery_scripts_conditionally');

add_action('wp_ajax_load_gallery_items', 'ajax_load_gallery_items');
add_action('wp_ajax_nopriv_load_gallery_items', 'ajax_load_gallery_items');

function ajax_load_gallery_items()
{
    $term_id = intval($_POST['term_id']);

    $query = new WP_Query([
        'post_type' => 'ktidb_gallery',
        'posts_per_page' => -1,
        'tax_query' => [
            [
                'taxonomy' => 'gallery_category',
                'field' => 'term_id',
                'terms' => $term_id
            ]
        ]
    ]);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $img = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            echo '<div class="col-md-4 mb-4">';
            echo '<a href="' . esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')) . '" data-lightbox="gallery">';
            echo '<img src="' . esc_url($img) . '" class="img-fluid">';
            echo '</a>';
            echo '</div>';
        }
    } else {
        echo '<p>No images found in this category.</p>';
    }
    wp_die();
}

/////////////////validate category image size
add_filter('acf/validate_value/name=cover_image', 'validate_cover_image_size', 10, 4);
function validate_cover_image_size($valid, $value, $field, $input)
{
    // Skip validation if already invalid
    if (!$valid || empty($value)) return $valid;

    $image_id = $value;
    $image = wp_get_attachment_metadata($image_id);

    // Set your desired limits
    $max_width = 1024;
    $max_height = 650;
    $max_file_size_kb = 250; // 500KB

    // Get actual file size in KB
    $file_path = get_attached_file($image_id);
    $file_size_kb = filesize($file_path) / 1024;

    if ($image['width'] != $max_width || $image['height'] != $max_height) {
        return "Image must be {$max_width}px × {$max_height}px.";
    }

    if ($file_size_kb > $max_file_size_kb) {
        return "Image file size must be less than {$max_file_size_kb}KB.";
    }

    return $valid;
}

add_action('admin_footer-post.php', 'restrict_featured_image_js');
add_action('admin_footer-post-new.php', 'restrict_featured_image_js');

function restrict_featured_image_js()
{
    global $post_type;

    if ($post_type !== 'ktidb_gallery') {
        return; // Exit if not your custom post type
    }
?>
    <script nonce="<?php echo csp_nonce(); ?>">
        jQuery(document).ready(function($) {
            // Hook into featured image set
            wp.media.featuredImage.frame().on('select', function() {
                const attachment = wp.media.featuredImage.frame().state().get('selection').first().toJSON();

                const img = new Image();
                img.src = attachment.url;
                img.onload = function() {
                    const width = img.width;
                    const height = img.height;
                    const maxWidth = 1024;
                    const maxHeight = 650;
                    const maxSizeKB = 250;

                    // Fetch file size using ajax
                    $.ajax({
                        url: ajaxurl,
                        method: 'POST',
                        data: {
                            action: 'get_image_size',
                            id: attachment.id
                        },
                        success: function(res) {
                            const fileSizeKB = parseFloat(res);
                            if (width !== maxWidth || height !== maxHeight || fileSizeKB > maxSizeKB) {
                                alert(`Only images exactly ${maxWidth}x${maxHeight}px and less than ${maxSizeKB}KB are allowed as featured images.`);
                                // Remove thumbnail
                                $('#remove-post-thumbnail').click();
                            }
                        }
                    });
                };
            });
        });
    </script>
<?php
}

// Ajax to get file size in KB
add_action('wp_ajax_get_image_size', function () {
    $id = intval($_POST['id']);
    $file = get_attached_file($id);
    if (file_exists($file)) {
        echo round(filesize($file) / 1024, 2);
    } else {
        echo 0;
    }
    wp_die();
});


////////////////FAQ
function register_faq_post_type()
{
    register_post_type('faq', array(
        'labels' => array(
            'name' => 'FAQs',
            'singular_name' => 'FAQ',
            'add_new' => 'Add New FAQ',
            'add_new_item' => 'Add New FAQ',
            'edit_item' => 'Edit FAQ',
            'new_item' => 'New FAQ',
            'view_item' => 'View FAQ',
            'search_items' => 'Search FAQs',
            'not_found' => 'No FAQs found',
        ),
        'public' => true,
        'menu_icon' => 'dashicons-editor-help',
        'menu_position' => 27,
        'supports' => array('title', 'editor'),
        'has_archive' => false,
        'show_in_rest' => true
    ));
}
add_action('init', 'register_faq_post_type');

function ktidb_enqueue_bootstrap()
{
    if (is_page_template('page-faq.php')) {
        wp_enqueue_script(
            'bootstrap-bundle',
            'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js',
            array(),
            null,
            true
        );
    }
}
add_action('wp_enqueue_scripts', 'ktidb_enqueue_bootstrap');

/////////////////Directors -staffs

// Register Director Post Type
function register_director_post_type()
{
    register_post_type('director', [
        'label' => 'Directors Board',
        'public' => true,
        'menu_icon' => 'dashicons-businessman',
        'supports' => ['title', 'thumbnail'],
        'show_in_menu' => 'ktidb-about',
    ]);
}
add_action('init', 'register_director_post_type');

// Register Staff Post Type
function register_staff_post_type()
{
    register_post_type('staff', [
        'label' => 'Staff',
        'public' => true,
        'menu_icon' => 'dashicons-groups',
        'supports' => ['title'],
        'show_in_menu' => 'ktidb-about',
    ]);
}
add_action('init', 'register_staff_post_type');

/////////////////////////FAQ menu show
add_action('admin_menu', 'ktidb_theme_settings_page');

function ktidb_theme_settings_page()
{
    add_submenu_page(
        'edit.php?post_type=faq',
        'KTIDB FAQ Settings',
        'FAQ Settings',
        'edit_pages', // Editor-safe
        'ktidb-theme-settings',
        'ktidb_theme_settings_content'
    );
}

// Save the form data
add_action('admin_post_save_ktidb_faq_settings', 'ktidb_save_faq_settings');

function ktidb_save_faq_settings()
{
    if (!current_user_can('edit_pages')) {
        wp_die('Unauthorized');
    }

    check_admin_referer('ktidb_faq_settings_form');

    $show_faq_menu = isset($_POST['show_faq_menu']) ? 1 : 0;
    update_option('show_faq_menu', $show_faq_menu);

    wp_redirect(add_query_arg('settings-updated', 'true', wp_get_referer()));
    exit;
}

function ktidb_theme_settings_content()
{
    $show_faq_menu = get_option('show_faq_menu', 0);
?>
    <div class="wrap">
        <h1>KTIDB FAQ Settings</h1>
        <?php if (isset($_GET['settings-updated'])): ?>
            <div id="message" class="updated notice is-dismissible">
                <p>Settings saved.</p>
            </div>
        <?php endif; ?>
        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
            <?php wp_nonce_field('ktidb_faq_settings_form'); ?>
            <input type="hidden" name="action" value="save_ktidb_faq_settings">

            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Show FAQ Menu on Frontend?</th>
                    <td>
                        <input type="checkbox" name="show_faq_menu" value="1" <?php checked($show_faq_menu, 1); ?>>
                    </td>
                </tr>
            </table>

            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}


//Hide "Add Block" Button via CSS
function hide_add_block_button_for_pages()
{
    global $post;
    if ($post && $post->post_type === 'page') {
        echo '<style>
            .edit-post-header-toolbar__inserter-toggle, 
            .block-editor-inserter__toggle {
                display: none !important;
            }
        </style>';
    }
}
add_action('admin_head', 'hide_add_block_button_for_pages');

add_action('admin_menu', 'ktidb_editor_only_custom_page_links');

function ktidb_editor_only_custom_page_links()
{
    // Only run for Editors
    if (!current_user_can('editor')) {
        return;
    }

    // Hide the default Pages menu
    remove_menu_page('edit.php?post_type=page');

    // Custom page links and positions
    $pages = [
        //  'about'        => ['title' => 'About',        'icon' => 'dashicons-admin-page',  'position' => 21],
        'contact'      => ['title' => 'Contact',      'icon' => 'dashicons-email',       'position' => 26],
        // 'organogram'   => ['title' => 'Organogram',   'icon' => 'dashicons-networking',  'position' => 23],
        'project'      => ['title' => 'Project',      'icon' => 'dashicons-portfolio',   'position' => 21],
        'social-links' => ['title' => 'Social Links', 'icon' => 'dashicons-share',       'position' => 28],
    ];

    foreach ($pages as $slug => $data) {
        $page = get_page_by_path($slug);
        if ($page) {
            add_menu_page(
                $data['title'] . ' Page',                      // Page title
                $data['title'],                                // Menu title
                'edit_pages',                                  // Capability
                'post.php?post=' . $page->ID . '&action=edit', // Menu slug
                '',                                            // Callback
                $data['icon'],                                 // Icon
                $data['position']                              // Menu position
            );
        }
    }
}

add_action('admin_menu', 'add_about_and_organogram_under_ktidb_about');

function add_about_and_organogram_under_ktidb_about()
{
    // Register the parent menu


    // Define only the required pages
    $pages = [
        'about'      => ['title' => 'Vision & Mission',      'icon' => 'dashicons-admin-page', 'position' => 21],
        'organogram' => ['title' => 'Organogram', 'icon' => 'dashicons-networking', 'position' => 23],
    ];

    // Add each as a submenu under the parent menu
    foreach ($pages as $slug => $data) {
        $page = get_page_by_path($slug);
        if ($page) {
            add_submenu_page(
                'ktidb-about',                                     // Parent menu slug
                $data['title'] . ' Page',                          // Page title
                $data['title'],                                    // Submenu title
                'edit_pages',                                      // Capability
                'post.php?post=' . $page->ID . '&action=edit',     // Menu slug (link to page editor)
                '',                                                // No callback needed
                $data['position']                                  // Menu position (optional for submenu)
            );
        }
    }
}



function display_rti_enold()
{
    $args = [
        'post_type' => 'rti', // CPT slug
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'ASC'
    ];

    $query = new WP_Query($args);
    dd($query);
    if ($query->have_posts()) {
        $output = '<div class="rti-grid">';
        while ($query->have_posts()) {
            $query->the_post();
            $output .= '<div class="rti-card">';
            $output .= '<h3 class="rti-title">' . get_the_title() . '</h3>';
            $output .= '<div class="rti-description">' . get_the_content() . '</div>';
            $output .= '</div>';
        }
        $output .= '</div>';
        wp_reset_postdata();
    } else {
        $output = '<p>No RTI information found.</p>';
    }

    return $output;
}
add_shortcode('rti_listhhhg', 'display_rti_entries');


add_filter('wpcf7_validate_tel*', 'validate_phone_number_length', 10, 2);
function validate_phone_number_length($result, $tag)
{
    $name = $tag->name;

    if ($name === 'your-phonenumber') {
        $phone = isset($_POST[$name]) ? trim($_POST[$name]) : '';
        if (!preg_match('/^\d{10}$/', $phone)) {
            $result->invalidate($tag, "Please enter a valid 10-digit phone number.");
        }
    }

    return $result;
}

///Social Links
if (function_exists('acf_add_options_page')) {
    acf_add_options_page(array(
        'page_title' => 'Theme Settings',
        'menu_title' => 'Theme Settings',
        'menu_slug' => 'theme-settings',
        'capability' => 'edit_posts',
        'redirect' => false
    ));
}

///Useful liks
function register_useful_links_post_type()
{
    $labels = array(
        'name' => 'Useful Links',
        'singular_name' => 'Useful Link',
        'add_new' => 'Add New Link',
        'add_new_item' => 'Add New Useful Link',
        'edit_item' => 'Edit Useful Link',
        'new_item' => 'New Useful Link',
        'view_item' => 'View Useful Link',
        'search_items' => 'Search Useful Links',
        'not_found' => 'No useful links found',
        'menu_name' => 'Useful Links',
    );

    $args = array(
        'labels' => $labels,
        'public' => true,
        'show_ui' => true,
        'menu_position' => 25,
        'menu_icon' => 'dashicons-admin-links',
        'supports' => array('title'),
        'has_archive' => false,
        'rewrite' => false,
    );

    register_post_type('useful_link', $args);
}
add_action('init', 'register_useful_links_post_type');


function hide_title_field_for_useful_link()
{
    $screen = get_current_screen();
    if ($screen->post_type === 'useful_link') {
    ?>
        <style>
            #titlediv {
                display: none;
            }
        </style>
        <script nonce="<?php echo csp_nonce(); ?>">
            document.addEventListener('DOMContentLoaded', function() {
                const titleField = document.getElementById('title');
                if (titleField) {
                    titleField.value = 'hidden-title'; // fallback dummy value
                }
            });
        </script>
    <?php
    }
}
add_action('admin_head', 'hide_title_field_for_useful_link');

// Change the column title
function useful_link_custom_columns($columns)
{
    $columns['title'] = 'Link Name'; // Rename "Title" column
    return $columns;
}
add_filter('manage_useful_link_posts_columns', 'useful_link_custom_columns');

// Show ACF field value instead of post title
function useful_link_custom_column_content($column, $post_id)
{
    if ($column === 'title') {
        $link_text = get_field('link_text', $post_id); // ACF field
        echo esc_html($link_text ? $link_text : '(no name)');
    }
}
add_action('manage_useful_link_posts_custom_column', 'useful_link_custom_column_content', 10, 2);
function update_useful_link_post_title($post_id)
{
    // Only target 'useful_link' post type
    if (get_post_type($post_id) != 'useful_link') {
        return;
    }

    // Avoid infinite loop
    remove_action('acf/save_post', 'update_useful_link_post_title');

    $link_text = get_field('link_text', $post_id);

    if ($link_text) {
        // Update the actual post title
        wp_update_post([
            'ID' => $post_id,
            'post_title' => $link_text,
            'post_name' => sanitize_title($link_text), // update slug too
        ]);
    }

    // Re-add action
    add_action('acf/save_post', 'update_useful_link_post_title');
}
add_action('acf/save_post', 'update_useful_link_post_title', 20);


//////////////////User : editor
add_action('pre_get_posts', 'hide_template_pages_from_editors');

function hide_template_pages_from_editors($query)
{
    if (is_admin() && $query->is_main_query() && !current_user_can('administrator')) {
        $query->set('post__not_in', array(83, 142, 109, 93, 104, 9, 61, 25, 45, 72, 2, 153, 135)); // IDs of the pages to hide
    }
}


add_action('admin_menu', 'custom_remove_menus_for_editors', 999);

function custom_remove_menus_for_editors()
{
    if (!current_user_can('administrator')) {
        // Remove default menus
        remove_menu_page('edit-comments.php'); // Comments      
        remove_menu_page('tools.php'); // Tools

    }
}

add_action('admin_menu', 'custom_hide_menus_for_editors', 999);
function custom_hide_menus_for_editors()
{
    if (!current_user_can('administrator')) {
        remove_menu_page('edit.php'); // Posts
        remove_menu_page('upload.php'); // Media
        remove_menu_page('edit.php?post_type=elementor_library'); // Elementor Templates
        remove_menu_page('wpcf7');
    }
}
//remove_quick_edit_for_editors
function remove_quick_edit_for_editors($actions, $post)
{
    // Check if the current user is an Editor
    if (current_user_can('editor') && !current_user_can('administrator')) {
        unset($actions['inline hide-if-no-js']); // This is the "Quick Edit" link
    }
    return $actions;
}
add_filter('post_row_actions', 'remove_quick_edit_for_editors', 10, 2);
add_filter('page_row_actions', 'remove_quick_edit_for_editors', 10, 2);

//hide_add_block_button_for_editors

//Remove "Add Media" Button for Editors (on career post type)
function remove_add_media_button_for_editors()
{
    global $pagenow;

    // Only target Editors on 'career' post type editing screens
    if (
        current_user_can('editor') &&
        get_post_type() === 'career' &&
        in_array($pagenow, ['post-new.php', 'post.php'])
    ) {
        echo '<style>
            #insert-media-button, 
            .add_media, 
            .wp-media-buttons {
                display: none !important;
            }
        </style>';
    }
}
add_action('admin_head', 'remove_add_media_button_for_editors');

// Remove Featured Image Meta Box for Editors (on career)
function remove_featured_image_for_editor_on_career()
{
    if (current_user_can('editor') && !current_user_can('administrator')) {
        remove_meta_box('postimagediv', 'career', 'side');
    }
}
add_action('add_meta_boxes', 'remove_featured_image_for_editor_on_career', 11);


//////////////Dashboard
// 1. Remove default dashboard widgets
add_action('wp_dashboard_setup', 'ktidb_remove_default_dashboard_widgets', 999);
function ktidb_remove_default_dashboard_widgets()
{
    global $wp_meta_boxes;

    // Remove default widgets
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);

    // Remove popular plugin widgets (optional)
    remove_meta_box('yoast_db_widget', 'dashboard', 'normal');
    remove_meta_box('elementor_dashboard_overview', 'dashboard', 'normal');
    remove_meta_box('wpcf7-dashboard-overview', 'dashboard', 'normal');
    remove_meta_box('e-dashboard-overview', 'dashboard', 'normal');
}

// 2. Add custom branded widget
add_action('wp_dashboard_setup', 'ktidb_add_custom_dashboard_widget');
function ktidb_add_custom_dashboard_widget()
{
    wp_add_dashboard_widget(
        'ktidb_custom_welcome',
        'Welcome to KTIDB Admin Panel',
        'ktidb_custom_dashboard_content'
    );
}
add_action('admin_head', function () {
    if (!current_user_can('administrator')) {
    ?>
        <style>
            #edit-slug-box {
                display: none !important;
            }
        </style>
    <?php
    }
});

// 3. Define widget content
function ktidb_custom_dashboard_content()
{

    $upload_dir = wp_get_upload_dir();



    ?>
    <div style="padding: 20px; font-size: 15px;">
        <img src="<?php echo $upload_dir['baseurl']; ?>/2025/05/logo-toddy-industry-development-board.png" alt="KTIDB Logo" style="max-width: 150px; margin-bottom: 20px;">
        <p><strong>Welcome to the Kerala Toddy Industry Development Board (KTIDB) Admin Panel.</strong></p>
        <p>Use the menu on the left to manage:</p>
        <ul style="margin-left: 20px; list-style: disc;">
            <li><a href="edit.php?post_type=ktidb_news">News & Announcements</a></li>
            <li><a href="edit.php?post_type=ktidb_gallery">Gallery</a></li>
            <li><a href="edit.php?post_type=banner">Home Page Banners</a></li>
            <li><a href="edit.php?post_type=page">Static Pages</a></li>
        </ul>
        <!-- <p>If you need help, contact the site administrator or <a href="mailto:support@ktidb.in">support@ktidb.in</a>.</p>
-->
    </div>
<?php
}

function enqueue_fontawesome_icons()
{
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_fontawesome_icons');

///////////FONTS

function add_malayalam_fonts()
{
    wp_enqueue_style('malayalam-fonts', 'https://fonts.googleapis.com/css2?family=Noto+Sans+Malayalam&display=swap', false);
}
add_action('wp_enqueue_scripts', 'add_malayalam_fonts');


add_filter('login_errors', 'custom_login_error_message');

function custom_login_error_message()
{
    return "Invalid credentials";
}

add_filter('rest_endpoints', function ($endpoints) {

    if (isset($endpoints['/wp/v2/users'])) {
        unset($endpoints['/wp/v2/users']);
    }

    return $endpoints;
});

function get_allowed_origins()
{
    return [
        'https://toddy.test4u.in/',
        'https://toddy.svpstaging.com/',
        'https://ktidb.kerala.gov.in/'
    ];
}


add_action('init', 'set_cors_headers_safely');


function set_cors_headers_safely()
{
    if (is_admin()) {
        return;
    }

    $origin = (isset($_SERVER['HTTP_ORIGIN'])) ? $_SERVER['HTTP_ORIGIN'] : NULL;

    if (!$origin) {
        return;
    }

    $allowed_origins = get_allowed_origins();

    if (in_array($origin, $allowed_origins, true)) {

        header("Access-Control-Allow-Origin: $origin");
        header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        header('Access-Control-Allow-Credentials: true');
    }

    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        status_header(204); // No content
        exit;
    }
}



add_action('admin_post_nopriv_submit_form', 'handle_form_submission');
add_action('admin_post_submit_form', 'handle_form_submission');


function handle_form_submission()
{
    if (!isset($_POST['your-name'])) {
        wp_die('Name is required.');
    }

    $_POST['your-name'] = sanitize_text_field($_POST['your-name']);

    if (!isset($_POST['your-email'])) {
        wp_die('Email Id is required');
    }

    $_POST['your-email'] = sanitize_text_field($_POST['your-email']);

    if (!is_email($_POST['your-email'])) {
        wp_die("Invalid email");
    }

    if (!isset($_POST['your-phone'])) {
        wp_die('Phone number required');
    }

    $_POST['your-phone'] = sanitize_text_field($_POST['your-phone']);

    if (!preg_match('/^[6-9][0-9]{9}$/', $_POST['your-phone'])) {
        wp_die("PRovide Valid phone number"); // Valid
    }

    if (!isset($_POST['your-subject'])) {
        wp_die("Subject is required");
    }

    $_POST['your-subject'] = sanitize_text_field($_POST['your-subject']);


    if (!isset($_POST['your-message'])) {
        wp_die('Message is required');
    }

    $_POST['your-message'] = sanitize_text_field($_POST['your-message']);
}

add_action('send_headers', 'add_security_headers');

function add_security_headers()
{
    header('X-XSS-Protection: 1; mode=block');
}

add_action('send_headers', 'add_csp_header');

function add_csp_header()
{
    header("Content-Security-Policy: default-src 'self'; script-src 'self' https://cdnjs.cloudflare.com; style-src 'self' 'unsafe-inline' https://fonts.googleapis.com; font-src 'self' https://fonts.gstatic.com; img-src 'self' data:; object-src 'none';");
}

add_action('send_headers', 'send_xss_protection_header');

function send_xss_protection_header()
{
    header('X-XSS-Protection: 1; mode=block');
}

function csp_nonce()
{
    static $nonce = '';
    if (empty($nonce)) {
        $nonce = base64_encode(random_bytes(16));
    }

    

    return $nonce;
}

add_action('send_headers', 'set_custom_csp_header');

function set_custom_csp_header()
{
    $nonce = csp_nonce();
 //   header("Content-Security-Policy: script-src 'self' https://cdnjs.cloudflare.com 'nonce-{$nonce}';");

  //  header("Content-Security-Policy: script-src 'self' https://www.google.com https://www.gstatic.com; frame-src https://www.google.com https://www.gstatic.com; style-src 'self' 'unsafe-inline';");
/*
 header("Content-Security-Policy: 
        default-src 'self';
        script-src 'self' 'nonce-$nonce' https://www.google.com https://www.gstatic.com;
        frame-src https://www.google.com https://www.gstatic.com;
        style-src 'self' 'unsafe-inline';
        object-src 'none';
        base-uri 'self';
        form-action 'self';"
    );

    header("Content-Security-Policy: 
        default-src 'self';
        script-src 'self' 'nonce-$nonce' https://www.google.com https://www.gstatic.com;
        frame-src https://www.google.com https://www.gstatic.com;
        style-src 'self' 'unsafe-inline';
        object-src 'none';
        base-uri 'self';
        form-action 'self';"
    );*/

  //  $nonce = bin2hex(random_bytes(16)); // Generate a new nonce
   /*$csp_policy = "script-src 'self' 'nonce-{$nonce}' 'unsafe-inline' https://www.google.com https://www.gstatic.com; " .
                  "style-src 'self' 'nonce-{$nonce}' 'unsafe-inline' https://www.google.com; " .
                  "frame-src https://www.google.com https://www.recaptcha.net;";*/

    // Set the CSP header.
   define('MY_NONCE', $nonce);
    header("Content-Security-Policy: script-src 'self' 'nonce-" . MY_NONCE . "' https://www.google.com https://www.gstatic.com; https://cdnjs.cloudflare.com https://cdn.gtranslate.net frame-src https://www.google.com; style-src 'self' 'unsafe-inline';");
}

function my_theme_add_nonce_to_recaptcha($tag, $handle, $src) {
    if (strpos($src, 'recaptcha/api.js') !== false) {
        $nonce_attr = ' nonce="' . MY_NONCE . '"';
        $tag = str_replace('<script ', '<script' . $nonce_attr . ' ', $tag);
    }
    return $tag;
}
add_filter('script_loader_tag', 'my_theme_add_nonce_to_recaptcha', 10, 3);

function clear_site_data_header()
{
    header("Clear-Site-Data: \"cookies\", \"storage\", \"cache\"");
}

add_action('wp_logout', 'lear_site_data_header');

function add_x_frame_options_header()
{

    header('X-Frame-Options: DENY');

}

add_action('send_headers','add_x_frame_options_header');

add_filter( 'rest_prepare_post', 'remove_guid_from_rest', 10, 2 );

function remove_guid_from_rest( $response, $post ) {
    unset( $response->data['guid'] );
    return $response;
}

add_filter('pre_comment_content', 'wp_kses_post');
/*
function my_wpcf7_add_recaptcha_dependency( $scripts ) {
    if ( isset( $scripts['wpcf7-recaptcha'] ) && isset( $scripts['wpcf7'] ) ) {
        $scripts['wpcf7']->deps[] = 'wpcf7-recaptcha';
    }
    return $scripts;
}
add_filter( 'wpcf7_script_dependencies', 'my_wpcf7_add_recaptcha_dependency' );*/

function my_enqueue_scripts() {
    // Enqueue Contact Form 7 scripts if needed
    if (function_exists('wpcf7_enqueue_scripts')) {
        wpcf7_enqueue_scripts();
        wpcf7_enqueue_styles();
    }

    // Your script, loaded after CF7
    wp_enqueue_script('my-custom-script', get_template_directory_uri() . '/js/index.js', ['jquery'], '1.0', true);
}
add_action('wp_enqueue_scripts', 'my_enqueue_scripts');

/*

add_action( 'wp_mail_failed', function( $wp_error ) {
    if ( is_wp_error( $wp_error ) ) {
        $message = $wp_error->get_error_message();

        // Dynamically hook into footer right now
        add_action( 'wp_footer', function() use ( $message ) {
            echo '<div class="container mt-4">';
            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
            echo '<strong>Email Failed:</strong> ' . esc_html( $message );
            echo '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
            echo '</div></div>';
        } );
    }
}, 10, 1 ); */
/*
function ktidb_enqueue_styles() {
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css');
    wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/font-awesome-pro.css');
    wp_enqueue_style('flaticon', get_template_directory_uri() . '/assets/css/flaticon.css');
    wp_enqueue_style('main', get_template_directory_uri() . '/assets/css/main.css');
    wp_enqueue_style('spacing', get_template_directory_uri() . '/assets/css/spacing.css');
    wp_enqueue_style('toddy-style', get_template_directory_uri() . '/assets/css/toddy-style.css');
}
add_action('wp_enqueue_scripts', 'ktidb_enqueue_styles');

*/





/*
function ktidb_register_project_cpt() {
    register_post_type('project', [
        'labels' => [
            'name' => 'Projects',
            'singular_name' => 'Project',
        ],
        'public' => true,
        'menu_icon' => 'dashicons-portfolio',
        'supports' => ['title', 'editor', 'thumbnail'],
        'has_archive' => true,
        'rewrite' => ['slug' => 'projects'],
        'show_in_rest' => true,
    ]);
}
add_action('init', 'ktidb_register_project_cpt');
*/