import { createSlice } from '@reduxjs/toolkit';
const initialState = {
  vehiclesType: {}
};
const vehicleType = createSlice({
  name: 'vehicleType',
  initialState,
  reducers: {
    setVehicleTypeListData(state, action) {
      return {
        ...state,
        vehiclesType: action.payload
      };
    },
    addVehicleTypeAction(state, action) {
      const vehicleData = action.payload;
      const updatedVehiclesType = [...state.vehiclesType, vehicleData];
      return {
        ...state,
        vehiclesType: updatedVehiclesType
      };
    },
    updateVehicleTypeAction(state, action) {
      const updatedVehicle = action.payload;
      const idToUpdate = updatedVehicle.id;
      const indexToUpdate = state.vehiclesType.findIndex((vehicle) => vehicle.id === idToUpdate);
      if (indexToUpdate === -1) {
        return state;
      }
      const updatedVehiclesType = [
        ...state.vehiclesType.slice(0, indexToUpdate),
        updatedVehicle,
        ...state.vehiclesType.slice(indexToUpdate + 1)
      ];

      return {
        ...state,
        vehiclesType: updatedVehiclesType
      };
    },

    deleteVehicleTypeAction(state, action) {
      const id = action.payload.id;
      const updatedVehiclesType = state.vehiclesType.filter((vehicle) => vehicle.id != id);
      return {
        ...state,
        vehiclesType: updatedVehiclesType
      };
    }
  }
});

export default vehicleType.reducer;

export const { setVehicleTypeListData, addVehicleTypeAction, updateVehicleTypeAction, deleteVehicleTypeAction } = vehicleType.actions;
