// types.js
import { createSlice } from '@reduxjs/toolkit';

// initial state
const initialState = {
  vehicles: {}
};

// ==============================|| SLICE - MENU ||============================== //

const vehicle = createSlice({
  name: 'vehicle',
  initialState,
  reducers: {
    setVehicleListData(state, action) {
      // console.log('vehc', action.payload);
      return {
        ...state,
        vehicles: action.payload
      };
    },
    addVehicleAction(state, action) {
      const vehicleData = action.payload;
      // Push the new vehicle data to the existing vehicles array
      const updatedVehicles = [vehicleData, ...state.vehicles];
      return {
        ...state,
        vehicles: updatedVehicles
      };
    },
    updateVehicleAction(state, action) {
      const updatedVehicle = action.payload;
      const idToUpdate = updatedVehicle.id;

      // Find the index of the vehicle with the specified ID
      const indexToUpdate = state.vehicles.findIndex((vehicle) => vehicle.id === idToUpdate);

      // If the vehicle with the specified ID is not found, return the current state
      if (indexToUpdate === -1) {
        return state;
      }

      // Replace the existing vehicle data with the updated data
      const updatedVehicles = [
        ...state.vehicles.slice(0, indexToUpdate), // Elements before the updated vehicle
        updatedVehicle, // Updated vehicle
        ...state.vehicles.slice(indexToUpdate + 1) // Elements after the updated vehicle
      ];

      return {
        ...state,
        vehicles: updatedVehicles
      };
    },

    deleteVehicleAction(state, action) {
      const id = action.payload.id;
      const updatedVehicles = state.vehicles.filter((vehicle) => vehicle.id != id);
      return {
        ...state,
        vehicles: updatedVehicles
      };
    }
  }
});

export default vehicle.reducer;

export const { setVehicleListData, addVehicleAction, updateVehicleAction, deleteVehicleAction } = vehicle.actions;
