// types.js
import { createSlice } from '@reduxjs/toolkit';

// initial state
const initialState = {
  locations: {}
};

// ==============================|| SLICE - MENU ||============================== //

const location = createSlice({
  name: 'location',
  initialState,
  reducers: {
    setLocationListData(state, action) {
      // console.log('action', action);
      return {
        ...state,
        locations: action.payload
      };
    },
    addLocationAction(state, action) {
      const locationData = action.payload;
      // Push the new location data to the existing locations array
      const updateLocations = [...state.locations, locationData];
      return {
        ...state,
        locations: updateLocations
      };
    },
    updateLocationAction(state, action) {
      const updateLocation = action.payload;
      const idToUpdate = updateLocation.id;
      const indexToUpdate = state.locations.findIndex((location) => location.id === idToUpdate);
      if (indexToUpdate === -1) {
        return state;
      }
      const updateLocations = [...state.locations.slice(0, indexToUpdate), updateLocation, ...state.locations.slice(indexToUpdate + 1)];

      return {
        ...state,
        locations: updateLocations
      };
    },

    deleteLocationAction(state, action) {
      const id = action.payload.id;
      const updateLocations = state.locations.filter((location) => location.id != id);
      return {
        ...state,
        locations: updateLocations
      };
    }
  }
});

export default location.reducer;

export const { setLocationListData, addLocationAction, updateLocationAction, deleteLocationAction } = location.actions;
