// types.js
import { createSlice } from '@reduxjs/toolkit';

// initial state
const initialState = {
  drivers: {}
};

// ==============================|| SLICE - MENU ||============================== //

const driver = createSlice({
  name: 'driver',
  initialState,
  reducers: {
    setDriverListData(state, action) {
      return {
        ...state,
        drivers: action.payload
      };
    },
    addDriverAction(state, action) {
      const driverData = action.payload;
      // Push the new driver data to the existing drivers array
      const updatedDrivers = [...state.drivers, driverData];
      return {
        ...state,
        drivers: updatedDrivers
      };
    },
    updateDriverAction(state, action) {
      const updatedDriver = action.payload;
      const idToUpdate = updatedDriver.id;
      const indexToUpdate = state.drivers.findIndex((driver) => driver.id === idToUpdate);
      if (indexToUpdate === -1) {
        return state;
      }
      const updatedDrivers = [...state.drivers.slice(0, indexToUpdate), updatedDriver, ...state.drivers.slice(indexToUpdate + 1)];

      return {
        ...state,
        drivers: updatedDrivers
      };
    },

    deleteDriverAction(state, action) {
      const id = action.payload.id;
      const updatedDrivers = state.drivers.filter((driver) => driver.id != id);
      return {
        ...state,
        drivers: updatedDrivers
      };
    }
  }
});

export default driver.reducer;

export const { setDriverListData, addDriverAction, updateDriverAction, deleteDriverAction } = driver.actions;
