import { lazy } from 'react';

// project import
import Loadable from 'components/Loadable';
import MainLayout from 'layout/MainLayout';

// render - dashboard
const DashboardDefault = Loadable(lazy(() => import('pages/dashboard')));
const CustomerManagment = Loadable(lazy(() => import('pages/customer')));
const DriverManagement = Loadable(lazy(() => import('pages/driver')));
// const UserManagement = Loadable(lazy(() => import('pages/user')));
const VehicleManagement = Loadable(lazy(() => import('pages/vehicle')));
const VehicleTypeManagement = Loadable(lazy(() => import('pages/vehicleType')));
const RouteManagement = Loadable(lazy(() => import('pages/route')));
const CustomerSupport = Loadable(lazy(() => import('pages/customerSupport')));
const FinanceManagement = Loadable(lazy(() => import('pages/finance')));
const RiderSupport = Loadable(lazy(() => import('pages/riderSupport')));
const NotificationsManagement = Loadable(lazy(() => import('pages/notifications')));
const OperationsManagement = Loadable(lazy(() => import('pages/operations')));
const PolicyManagement = Loadable(lazy(() => import('pages/policy')));
const LocalityConfiurations = Loadable(lazy(() => import('pages/localityConfig')));
const BookingsManagement = Loadable(lazy(() => import('pages/bookings')));
const TripManagement = Loadable(lazy(() => import('pages/trip')));
const HistoryAndRecords = Loadable(lazy(() => import('pages/history')));
const SamplePage = Loadable(lazy(() => import('pages/extra-pages/SamplePage')));

// render - utilities
const Typography = Loadable(lazy(() => import('pages/components-overview/Typography')));
const Color = Loadable(lazy(() => import('pages/components-overview/Color')));
const Shadow = Loadable(lazy(() => import('pages/components-overview/Shadow')));
const AntIcons = Loadable(lazy(() => import('pages/components-overview/AntIcons')));

// ==============================|| MAIN ROUTING ||============================== //

const MainRoutes = {
  path: '/',
  element: <MainLayout />,
  children: [
    {
      path: '/',
      element: <DashboardDefault />
    },
    {
      path: 'color',
      element: <Color />
    },
    {
      path: 'dashboard',
      element: <DashboardDefault />
    },
    // {
    //   path: 'dashboard',
    //   children: [
    //     {
    //       path: 'default',
    //       element: <DashboardDefault />
    //     }
    //   ]
    // },
    {
      path: 'sample-page',
      element: <SamplePage />
    },
    {
      path: 'customer-management',
      element: <CustomerManagment />
    },
    {
      path: 'driver-management',
      element: <DriverManagement />
    },
    // {
    //   path: 'user-management',
    //   element: <UserManagement />
    // },
    {
      path: 'vehicle-management',
      element: <VehicleManagement />
    },
    {
      path: 'vehicle-type-management',
      element: <VehicleTypeManagement />
    },
    {
      path: 'locality-configuration',
      element: <LocalityConfiurations />
    },
    {
      path: 'route-management',
      element: <RouteManagement />
    },
    {
      path: 'booking-management',
      element: <BookingsManagement />
    },
    {
      path: 'finance-management',
      element: <FinanceManagement />
    },
    {
      path: 'trip-management',
      element: <TripManagement />
    },
    {
      path: 'history-management',
      element: <HistoryAndRecords />
    },
    {
      path: '/customer-support',
      element: <CustomerSupport />
    },
    {
      path: 'rider-support',
      element: <RiderSupport />
    },
    {
      path: 'notifications-management',
      element: <NotificationsManagement />
    },
    {
      path: 'operations-management',
      element: <OperationsManagement />
    },
    {
      path: 'policy-management',
      element: <PolicyManagement />
    },
    {
      path: 'shadow',
      element: <Shadow />
    },
    {
      path: 'typography',
      element: <Typography />
    },
    {
      path: 'icons/ant',
      element: <AntIcons />
    }
  ]
};

export default MainRoutes;
