import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import { useDispatch, useSelector } from 'react-redux';

import {
  Paper,
  Avatar,
  AvatarGroup,
  Box,
  Button,
  Grid,
  List,
  ListItemAvatar,
  ListItemButton,
  ListItemSecondaryAction,
  ListItemText,
  MenuItem,
  Stack,
  TextField,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton,
  FormControlLabel,
  Checkbox
} from '@mui/material';

import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';

const ViewVehicleType = (props) => {
  const commonData = useSelector((state) => state?.common?.commonData) || [];

  const [open, setOpen] = useState(props.handleClickOpenViewFlag);
  const [viewData, setViewData] = useState(props.data);

  const [scroll, setScroll] = useState('paper');

  const handleClose = () => {
    props.closeViewModal(false);
    setViewData('');
  };
  useEffect(() => {
    setViewData(commonData);
  }, [commonData]);

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenViewFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenViewFlag);
  }, [props.handleClickOpenViewFlag]);

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        {viewData && (
          <>
            <DialogTitle id="scroll-dialog-title">
              <Grid container justifyContent="space-between" alignItems="center">
                <Grid item>
                  <Typography variant="h5">Vehicle Type Details</Typography>
                </Grid>
                <Grid item>
                  <Tooltip title="Close" placement="top">
                    <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                      <CloseIcon />
                    </IconButton>
                  </Tooltip>
                </Grid>
              </Grid>
            </DialogTitle>
            <DialogContent dividers={scroll === 'paper'}>
              <MainCard sx={{ padding: 2 }} content={false}>
                <Grid container spacing={2}>
                  <Grid item xs={4}>
                    <Typography variant="body1" gutterBottom>
                      <strong>ID:</strong> {viewData?.id}
                    </Typography>
                  </Grid>

                  <Grid item xs={4}>
                    <Typography variant="body1" gutterBottom>
                      <strong>Vehicle Type:</strong> {viewData?.vehicle_type}
                    </Typography>
                  </Grid>

                  <Grid item xs={4}>
                    <Typography variant="body1" gutterBottom>
                      <strong>Seating Capacity:</strong> {viewData?.seating_capacity}
                    </Typography>
                  </Grid>

                  <Grid item xs={4}>
                    <Typography variant="body1" gutterBottom>
                      <strong>Per KM Charge:</strong> ₹ {viewData?.per_km_charge}/-
                    </Typography>
                  </Grid>
                </Grid>
              </MainCard>
            </DialogContent>
          </>
        )}
      </Dialog>
    </React.Fragment>
  );
};

export default ViewVehicleType;
ViewVehicleType.propTypes = {
  data: PropTypes.object.isRequired,
  closeViewModal: PropTypes.func.isRequired,
  handleClickOpenViewFlag: PropTypes.bool.isRequired
};
