import React, { useState, useEffect } from 'react';
import { setVehicleTypeListData, deleteVehicleTypeAction } from '../../store/reducers/vehiclesType';
import { setCommonViewData } from '../../store/reducers/common';
import { useDispatch, useSelector } from 'react-redux';
import ModeEditIcon from '@mui/icons-material/ModeEdit';
import DeleteIcon from '@mui/icons-material/Delete';
import ViewIcon from '@mui/icons-material/Visibility';
import { DataGrid } from '@mui/x-data-grid';
import DeleteModal from '../../components/deleteModal/deleteModal';
import EditModal from '../../components/editConfirm/editModal';

import { toast } from 'react-toastify';
import { Box, Button, Grid, Typography, Tooltip } from '@mui/material';
import { PlusIcon } from 'utils/icons';
import CreateVehicleType from './createVehicleType';
import { deleteVehicleType, listVehiclesType } from '../../apiCalls/vehicleType';
import ViewVehicle from './viewVehicleType';
import MainCard from 'components/MainCard';

const VehicleTypeManagement = () => {
  const dispatch = useDispatch();
  const newVehicleList = useSelector((state) => state?.vehicleType?.vehiclesType) || [];
  const [open, setOpen] = React.useState(false);
  const [showDeleteModal, setShowDeleteModal] = React.useState(false);
  const [showEditModal, setShowEditModal] = React.useState(false);
  const [showViewModal, setShowViewModal] = React.useState(false);
  const [list, setList] = React.useState('');
  const [selectedData, setSelectedData] = React.useState(null);
  useEffect(() => {
    listVehiclesType().then((res) => {
      if (res?.data) {
        dispatch(setVehicleTypeListData(res?.data));
      }
    });
  }, []);

  useEffect(() => {
    setList(newVehicleList);
  }, [newVehicleList]);
  const onModeEditIconClick = (e, row) => {
    setSelectedData(row);
    setShowEditModal(true);
    // handleClickOpen(true);
  };
  const onDeleteIconClick = (e, row) => {
    setSelectedData(row);
    setShowDeleteModal(true);
  };
  const onViewIconClick = (e, row) => {
    setSelectedData(row);
    dispatch(setCommonViewData(row));
    setShowViewModal(true);
  };

  const columns = [
    {
      field: 'id',
      headerName: 'Sl no',
      width: 100,
      disableColumnMenu: true,
      sortable: false,
      hideSortIcon: true,
      renderCell: (params) => {
        if (list.length > 0) {
          const indexToUpdate = list?.findIndex((vehicle) => vehicle.id === params.id);
          return <>{indexToUpdate + 1}</>;
        }
      }
    },
    {
      field: 'vehicle_type',
      headerName: 'Vehicle Type',
      width: 200,
      editable: false,
      disableColumnMenu: true,
      sortable: false,
      hideSortIcon: true
    },

    {
      field: 'seating_capacity',
      headerName: 'Seat Capacity',
      align: 'left',
      width: 200,
      editable: false,
      disableColumnMenu: true,
      sortable: false,
      hideSortIcon: true
    },
    {
      field: 'actions',
      headerName: 'Actions',
      hideMenu: true,
      width: 250,
      disableColumnMenu: true,
      sortable: false,
      hideSortIcon: true,
      renderCell: (params) => {
        return (
          <>
            <Tooltip title="Edit the details" placement="top">
              <ModeEditIcon style={{ cursor: 'pointer' }} color="primary" onClick={(e) => onModeEditIconClick(e, params.row)}>
                Edit
              </ModeEditIcon>
            </Tooltip>{' '}
            &nbsp; &nbsp;
            <Tooltip title="Delete the details" placement="top">
              <DeleteIcon color="primary" style={{ cursor: 'pointer', color: '#ff4d4f' }} onClick={(e) => onDeleteIconClick(e, params.row)}>
                Delete
              </DeleteIcon>
            </Tooltip>{' '}
            &nbsp; &nbsp;
            <Tooltip title="View the details" placement="top">
              <ViewIcon color="primary" style={{ cursor: 'pointer', color: '#1fb141' }} onClick={(e) => onViewIconClick(e, params.row)}>
                View
              </ViewIcon>
            </Tooltip>{' '}
          </>
        );
      }
    }
  ];

  const handleClickOpen = (flag) => {
    setOpen(flag);
  };

  const closeModal = (flag) => {
    setSelectedData(null);
    setOpen(false);
  };
  const closeDeleteModal = (flag) => {
    setSelectedData(null);
    setShowDeleteModal(false);
  };
  const closeEditModal = (flag) => {
    setSelectedData(null);
    setShowEditModal(false);
  };
  const closeViewModal = (flag) => {
    setSelectedData(null);
    setShowViewModal(false);
  };
  const deleteItem = async () => {
    try {
      await deleteVehicleType(selectedData?.id).then((res) => {
        console.log('res delete', res);
        // if (res?.data) {
        toast.success(`${'vehicle type deleted successfully'}`, {
          autoClose: 1500
        });
        dispatch(deleteVehicleTypeAction(selectedData));
        setShowDeleteModal(false);
        setSelectedData(null);
        // } else {
        //   toast.error(`${'something went wrong'}`, {
        //     autoClose: 1500
        //   });
        // }
      });
    } catch (err) {
      console.log('err', err);
    }
  };
  const doDelete = (flag) => {
    deleteItem(selectedData);
    setShowDeleteModal(false);
  };
  const doEdit = (flag) => {
    setShowEditModal(false);
    handleClickOpen(true);
  };

  return (
    <Grid container rowSpacing={4.5} columnSpacing={2.75}>
      <Grid item xs={12} md={12} lg={12}>
        <Grid container alignItems="center" justifyContent="space-between">
          <Grid item>
            <Typography variant="h5">Vehicle Type Management</Typography>
          </Grid>
          <Grid item />
          <Grid item>
            <Tooltip title="Create Vehicle Type" placement="top">
              <Button onClick={() => handleClickOpen(true)} variant="contained" color="primary" startIcon={<PlusIcon />}>
                Create Vehicle Type
              </Button>
            </Tooltip>
          </Grid>
        </Grid>
        <CreateVehicleType handleClickOpenFlag={open} data={selectedData || 'add'} closeModal={(e) => closeModal(e)} />
        <DeleteModal
          handleClickOpenDeleteFlag={showDeleteModal}
          doDelete={(e) => doDelete(e)}
          data={selectedData}
          closeDeleteModal={(e) => closeDeleteModal(e)}
        />
        <EditModal
          handleClickOpenEditFlag={showEditModal}
          doEdit={(e) => doEdit(e)}
          data={selectedData}
          closeEditModal={(e) => closeEditModal(e)}
        />

        <ViewVehicle handleClickOpenViewFlag={showViewModal} data={selectedData} closeViewModal={(e) => closeViewModal(e)} />

        <MainCard sx={{ mt: 2 }} content={false}>
          <div>
            <Box sx={{ height: 400, width: '100%' }}>
              <DataGrid
                sx={{
                  '.MuiDataGrid-columnHeaders': {
                    backgroundColor: '#1677ff',
                    opacity: '.75'
                  },
                  '.MuiDataGrid-columnHeaderTitle': {
                    color: 'white',
                    fontSize: '14px'
                  },
                  '.MuiTablePagination-selectLabel': {
                    marginTop: '12px'
                  },
                  '.MuiTablePagination-displayedRows': {
                    marginTop: '12px'
                  },
                  '.MuiDataGrid-row.Mui-odd': {
                    backgroundColor: '#a5e5a54d'
                  },
                  '.MuiDataGrid-sortIcon': {
                    color: 'white'
                  }
                }}
                rows={list}
                columns={columns}
                checkboxSelection={false}
                pageSizeOptions={[10, 50, 100]}
                initialState={{
                  pagination: { paginationModel: { pageSize: 10 } }
                }}
                disableRowSelectionOnClick
                getRowClassName={(params) => (params.indexRelativeToCurrentPage % 2 === 0 ? 'Mui-even' : 'Mui-odd')}
              />
            </Box>
          </div>
        </MainCard>
      </Grid>
    </Grid>
  );
};

export default VehicleTypeManagement;
