import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import { isEmpty, isEqual } from 'lodash';
import { FormControl, InputLabel, Select } from '@mui/material';
import Autocomplete from '@mui/material/Autocomplete';
import { addVehicleType, updateVehicleType } from '../../apiCalls/vehicleType';
import { toast } from 'react-toastify';
import { addVehicleTypeAction, updateVehicleTypeAction } from '../../store/reducers/vehiclesType';
import {
  TextField,
  Grid,
  Button,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton
} from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';
import { useDispatch, useSelector } from 'react-redux';

const CreateVehicleType = (props) => {
  const dispatch = useDispatch();
  const [open, setOpen] = useState(props.handleClickOpenFlag);
  const [validationMsg, setValidationMsg] = useState({});
  const [error, setError] = useState('');
  const [selectedDate, setSelectedDate] = useState(null);
  const [scroll, setScroll] = useState('paper');
  const [formValues, setFormData] = useState({});
  useEffect(() => {
    if (props.data != 'add') {
      setFormData({
        per_km_charge: props.data.per_km_charge,
        seating_capacity: props.data.seating_capacity,
        vehicle_type: props.data.vehicle_type
      });
    }
  }, [props.data]);
  const updateFormValues = (feild, value) => {
    setValidationMsg({});
    setError('');
    let curValues = { ...formValues };
    curValues[`${feild}`] = value;
    setFormData(curValues);
  };
  const validateForm = () => {
    let validationMessages = { ...validationMsg };
    const { per_km_charge, seating_capacity, vehicle_type } = formValues;

    if (isEmpty(per_km_charge)) {
      validationMessages.per_km_charge = 'Please enter per km charge';
    }
    if (isEmpty(vehicle_type) || vehicle_type?.length < 2) {
      validationMessages.vehicle_type = 'Please enter vehicle discription';
    }
    if (seating_capacity == null) {
      validationMessages.seating_capacity = 'Please enter seating capacity';
    }

    setValidationMsg(validationMessages);
    return isEmpty(Object.keys(validationMessages));
  };
  const onSubmit = async () => {
    const validForm = validateForm();
    if (validForm) {
      if (props.data == 'add') {
        try {
          await addVehicleType(formValues).then((res) => {
            console.log('res111', res);
            if (res?.data) {
              dispatch(addVehicleTypeAction(res?.data));
              toast.success('Vehicle created successfully', {
                autoClose: 1500
              });
              handleClose();
            } else {
              toast.error(`${'Something went wrong'}`, {
                autoClose: 1500
              });
            }
          });
        } catch (err) {
          console.log('err', err);
        }
      } else {
        try {
          await updateVehicleType(props?.data?.id, formValues).then((res) => {
            console.log('res1222', res);
            if (res?.data) {
              dispatch(updateVehicleTypeAction(res?.data));
              toast.success(`${'Vehicle updated successfully'}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              toast.error(`${'Something went wrong'}`, {
                autoClose: 1500
              });
            }
          });
        } catch (err) {
          console.log('err', err);
        }
      }
    }
  };

  const handleClose = () => {
    setFormData('');
    setValidationMsg('');
    props.closeModal(false);
  };

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenFlag);
  }, [props.handleClickOpenFlag]);

  const typesOfVehicles = [
    { id: 1, name: 'Sedan', value: 'sedan' },
    { id: 2, name: 'SUV', value: 'suv' },
    { id: 3, name: 'Van', value: 'van' },
    { id: 4, name: 'Coupe', value: 'Coupe' },
    { id: 5, name: 'Car', value: 'car' },
    { id: 6, name: 'Hatchback', value: 'hatchback' },
    { id: 7, name: 'Convertible', value: 'convertible' },
    { id: 8, name: 'Jeep', value: 'jeep' }
  ];
  const vehiclesStatus = [
    { id: 1, name: 'Active', value: true },
    { id: 2, name: 'Inactive', value: false }
  ];

  const isOptionEqualToValue = (option, value) => option?.value == value?.value;

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <DialogTitle id="scroll-dialog-title">
          <Grid container justifyContent="space-between" alignItems="center">
            <Grid item>
              <Typography variant="h5">Vehicle Management</Typography>
            </Grid>
            <Grid item>
              <Tooltip title="Close" placement="top">
                <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                  <CloseIcon />
                </IconButton>
              </Tooltip>
            </Grid>
          </Grid>
        </DialogTitle>
        <DialogContent dividers={scroll === 'paper'}>
          <MainCard
            sx={{
              padding: 2
            }}
            content={false}
          >
            <DialogContentText id="scroll-dialog-description" ref={descriptionElementRef} tabIndex={-1}>
              <Grid container spacing={2}>
                <Grid item xs={12}>
                  <Typography variant="h5">Vehicle information</Typography>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    value={formValues.vehicle_type}
                    onChange={(e) => updateFormValues('vehicle_type', e.target.value)}
                    label="Vehicle type"
                    fullWidth
                    onKeyDown={(e) => {
                      const key = e.key.toLowerCase();
                      if ((key >= 'a' && key <= 'z') || key === 'backspace' || key === ' ') {
                        console.log('Valid key pressed');
                      } else {
                        e.preventDefault();
                      }
                    }}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.vehicle_type}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    value={formValues.seating_capacity}
                    onChange={(e) => updateFormValues('seating_capacity', e.target.value)}
                    label="Seating Capacity"
                    fullWidth
                    onKeyDown={(e) => {
                      if (
                        (e.keyCode >= 48 && e.keyCode <= 57) ||
                        (e.keyCode >= 96 && e.keyCode <= 105) ||
                        (e.key >= 0 && e.key <= 9) ||
                        e.key == 'Backspace' ||
                        e.key == 'Delete'
                      ) {
                        console.log('ok');
                      } else {
                        e.preventDefault();
                      }
                    }}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.seating_capacity}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    value={formValues.per_km_charge}
                    onChange={(e) => updateFormValues('per_km_charge', e.target.value)}
                    label="Per Km Charge"
                    fullWidth
                    onKeyDown={(e) => {
                      if (
                        (e.keyCode >= 48 && e.keyCode <= 57) ||
                        (e.keyCode >= 96 && e.keyCode <= 105) ||
                        (e.key >= 0 && e.key <= 9) ||
                        e.key == 'Backspace' ||
                        e.key == 'Delete'
                      ) {
                        console.log('ok');
                      } else {
                        e.preventDefault();
                      }
                    }}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.per_km_charge}
                  </span>
                </Grid>
              </Grid>
            </DialogContentText>
          </MainCard>
        </DialogContent>
        <DialogActions>
          <Button variant="contained" color="secondary" onClick={handleClose}>
            Cancel
          </Button>
          <Button variant="contained" onClick={(e) => onSubmit(e)}>
            Submit
          </Button>
        </DialogActions>
      </Dialog>
    </React.Fragment>
  );
};

export default CreateVehicleType;
CreateVehicleType.propTypes = {
  data: PropTypes.object.isRequired,
  closeModal: PropTypes.func.isRequired,
  handleClickOpenFlag: PropTypes.bool.isRequired
};
