import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import { useDispatch, useSelector } from 'react-redux';

import { Grid, Typography, Tooltip, Dialog, DialogContent, DialogContentText, DialogTitle, IconButton } from '@mui/material';

import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';

const ViewVehicle = (props) => {
  const commonData = useSelector((state) => state?.common?.commonData) || [];
  // console.log('common', commonData);
  const [open, setOpen] = useState(props.handleClickOpenViewFlag);
  const [viewData, setViewData] = useState(props.data);
  const [scroll, setScroll] = useState('paper');
  const handleClose = () => {
    props.closeViewModal(false);
    setViewData('');
  };
  useEffect(() => {
    setViewData(commonData);
  }, [commonData]);
  const descriptionElementRef = React.useRef(null);
  // console.log('viewData', viewData);

  useEffect(() => {
    if (props.handleClickOpenViewFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenViewFlag);
  }, [props.handleClickOpenViewFlag]);

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        {viewData && (
          <>
            <DialogTitle id="scroll-dialog-title">
              <Grid container justifyContent="space-between" alignItems="center">
                <Grid item>
                  <Typography variant="h5">Vehicle Details</Typography>
                </Grid>
                <Grid item>
                  <Tooltip title="Close" placement="top">
                    <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                      <CloseIcon />
                    </IconButton>
                  </Tooltip>
                </Grid>
              </Grid>
            </DialogTitle>
            <DialogContent dividers={scroll === 'paper'}>
              <MainCard sx={{ padding: 2 }} content={false}>
                <Typography variant="body1" gutterBottom>
                  <Grid container spacing={2}>
                    <Grid item xs={4}>
                      <strong>ID:</strong> {viewData?.row?.id}
                    </Grid>

                    <Grid item xs={4}>
                      <strong>Vehicle Type:</strong> {viewData?.row?.vehicle_type?.vehicle_type}
                    </Grid>

                    <Grid item xs={4}>
                      <strong>Seating Capacity:</strong> {viewData?.row?.vehicle_type?.seating_capacity}
                    </Grid>

                    <Grid item xs={4}>
                      <strong>Per KM Charge:</strong> ₹ {viewData?.row?.vehicle_type?.per_km_charge}/-
                    </Grid>

                    <Grid item xs={4}>
                      <strong>Status:</strong> {viewData?.row?.status ? 'Active' : 'Inactive'}
                    </Grid>

                    <Grid item xs={4}>
                      <strong>Plate Number:</strong> {viewData?.row?.plate_number}
                    </Grid>
                  </Grid>
                </Typography>
              </MainCard>
            </DialogContent>
          </>
        )}
      </Dialog>
    </React.Fragment>
  );
};

export default ViewVehicle;
ViewVehicle.propTypes = {
  data: PropTypes.object.isRequired,
  closeViewModal: PropTypes.func.isRequired,
  handleClickOpenViewFlag: PropTypes.bool.isRequired
};
