import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import { isEmpty, isEqual } from 'lodash';
import Autocomplete from '@mui/material/Autocomplete';
import { addVehicle, updateVehicle } from '../../apiCalls/vehicle';
import { toast } from 'react-toastify';
import { addVehicleAction, updateVehicleAction } from '../../store/reducers/vehicles';
import { setVehicleTypeListData } from '../../store/reducers/vehiclesType';
import { listVehiclesType } from '../../apiCalls/vehicleType';
import {
  Button,
  Grid,
  TextField,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton
} from '@mui/material';
import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';
import { useDispatch, useSelector } from 'react-redux';

const CreateVehicle = (props) => {
  // console.log('props', props);
  const vehicleTypeList = useSelector((state) => state?.vehicleType?.vehiclesType) || [];
  // console.log('vehicleTypeList', vehicleTypeList);
  const dispatch = useDispatch();
  const [open, setOpen] = useState(props.handleClickOpenFlag);
  const [validationMsg, setValidationMsg] = useState({});
  const [error, setError] = useState('');
  const [selectedDate, setSelectedDate] = useState(null);
  const [scroll, setScroll] = useState('paper');
  const [formValues, setFormData] = useState({});
  useEffect(() => {
    if (props.data != 'add') {
      setFormData({
        per_km_charge: props.data.vehicle_type.per_km_charge,
        plate_number: props.data.plate_number,
        seating_capacity: props.data.vehicle_type.seating_capacity,
        status: props.data.status,
        vehicle_type: props.data.vehicle_type.id
      });
    }
  }, [props.data]);
  useEffect(() => {
    listVehiclesType().then((res) => {
      if (res?.data) {
        dispatch(setVehicleTypeListData(res?.data));
      }
    });
  }, []);
  useEffect(() => {
    // console.log('form', formValues);
  }, [formValues]);
  const updateFormValues = (feild, value) => {
    setValidationMsg({});
    setError('');
    let curValues = { ...formValues };
    curValues[`${feild}`] = value;
    setFormData(curValues);
  };
  const validateForm = () => {
    let validationMessages = { ...validationMsg };
    const { per_km_charge, plate_number, seating_capacity, status, vehicle_type } = formValues;

    // if (isEmpty(per_km_charge)) {
    //   validationMessages.per_km_charge = 'Please enter per km charge';
    // }
    if (vehicle_type == null) {
      validationMessages.vehicle_type = 'Please enter vehicle type';
    }
    if (isEmpty(plate_number) || plate_number?.length < 8) {
      validationMessages.plate_number = 'Please enter vehicle number';
    }
    // if (seating_capacity == null) {
    //   validationMessages.seating_capacity = 'Please enter seating capacity';
    // }
    if (status == null) {
      validationMessages.status = 'Please choose status';
    }

    setValidationMsg(validationMessages);
    return isEmpty(Object.keys(validationMessages));
  };
  const onSubmit = async () => {
    const validForm = validateForm();
    if (validForm) {
      if (props.data == 'add') {
        try {
          await addVehicle(formValues).then((res) => {
            if (res?.data?.status == 1) {
              dispatch(addVehicleAction(res?.data?.vehicle));
              toast.success(`${res?.data?.message}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              if (res?.status == 0) {
                toast.error(`${res?.message}`, {
                  autoClose: 1500
                });
              }
            }
          });
        } catch (err) {
          console.log('err', err);
        }
      } else {
        try {
          await updateVehicle(props?.data?.id, formValues).then((res) => {
            if (res?.data?.status == 1) {
              dispatch(updateVehicleAction(res?.data?.vehicle));
              toast.success(`${res?.data?.message}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              if (res?.status == 0) {
                toast.error(`${res?.message}`, {
                  autoClose: 1500
                });
              }
            }
          });
        } catch (err) {
          console.log('err', err);
        }
      }
    }
  };

  const handleClose = () => {
    setFormData('');
    setValidationMsg('');
    props.closeModal(false);
  };

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenFlag);
  }, [props.handleClickOpenFlag]);

  const typesOfVehicles = [
    { id: 1, name: 'Sedan', value: 'sedan' },
    { id: 2, name: 'SUV', value: 'suv' },
    { id: 3, name: 'Van', value: 'van' },
    { id: 4, name: 'Coupe', value: 'Coupe' },
    { id: 5, name: 'Car', value: 'car' },
    { id: 6, name: 'Hatchback', value: 'hatchback' },
    { id: 7, name: 'Convertible', value: 'convertible' },
    { id: 8, name: 'Jeep', value: 'jeep' }
  ];

  const typeArray = [
    {
      id: 15,
      vehicle_type: 'sedan',
      seating_capacity: 41,
      per_km_charge: '91.00'
    },
    {
      id: 17,
      vehicle_type: 'sedan',
      seating_capacity: 41,
      per_km_charge: '91.00'
    }
  ];
  const vehiclesStatus = [
    { id: 1, name: 'Active', value: true },
    { id: 2, name: 'Inactive', value: false }
  ];
  const updateFormValuesWithType = (value) => {
    if (value) {
      setFormData((prevFormData) => ({
        ...prevFormData,
        per_km_charge: value.per_km_charge,
        seating_capacity: value.seating_capacity,
        vehicle_type: value.id
      }));
    }
  };

  const isOptionEqualToValue = (option, value) => option?.id == value?.id;

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <DialogTitle id="scroll-dialog-title">
          <Grid container justifyContent="space-between" alignItems="center">
            <Grid item>
              <Typography variant="h5">Vehicle Management</Typography>
            </Grid>
            <Grid item>
              <Tooltip title="Close" placement="top">
                <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                  <CloseIcon />
                </IconButton>
              </Tooltip>
            </Grid>
          </Grid>
        </DialogTitle>
        <DialogContent dividers={scroll === 'paper'}>
          <MainCard
            sx={{
              padding: 2
            }}
            content={false}
          >
            <DialogContentText id="scroll-dialog-description" ref={descriptionElementRef} tabIndex={-1}>
              <Grid container spacing={2}>
                <Grid item xs={12}>
                  <Typography variant="h5">Vehicle information</Typography>
                </Grid>
                <Grid item xs={4}>
                  {vehicleTypeList.length > 0 && (
                    <Autocomplete
                      sx={{
                        '& .MuiOutlinedInput-root': {
                          padding: '0px',
                          paddingBottom: '5px'
                        },
                        '& .MuiOutlinedInput-root .MuiAutocomplete-input': {
                          paddingLeft: '15px'
                        },
                        maxWidth: 420
                      }}
                      options={vehicleTypeList}
                      value={vehicleTypeList.find((vehicle) => vehicle.id === formValues.vehicle_type)}
                      isOptionEqualToValue={(option, value) => isOptionEqualToValue(option, value)}
                      onChange={(e, value) => {
                        updateFormValuesWithType(value);
                      }}
                      getOptionLabel={(option) => option.vehicle_type || 'Select'}
                      renderInput={(params) => (
                        <TextField
                          sx={{
                            '& .MuiInputLabel-root': {
                              height: '1rem'
                            }
                          }}
                          {...params}
                          InputLabelProps={{ shrink: props?.data != 'add' || formValues.vehicle_type ? true : false }}
                          label="Vehicle Type"
                        />
                      )}
                    />
                  )}
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.vehicle_type}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    InputLabelProps={{ shrink: props?.data != 'add' || formValues.seating_capacity ? true : false }}
                    value={formValues.seating_capacity}
                    onChange={(e) => updateFormValues('seating_capacity', e.target.value)}
                    label="Seating Capacity"
                    disabled
                    fullWidth
                    onKeyDown={(e) => {
                      if (
                        (e.keyCode >= 48 && e.keyCode <= 57) ||
                        (e.keyCode >= 96 && e.keyCode <= 105) ||
                        (e.key >= 0 && e.key <= 9) ||
                        e.key == 'Backspace' ||
                        e.key == 'Delete'
                      ) {
                        console.log('ok');
                      } else {
                        e.preventDefault();
                      }
                    }}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.seating_capacity}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    value={formValues.per_km_charge}
                    disabled
                    onChange={(e) => updateFormValues('per_km_charge', e.target.value)}
                    label="Per Km Charge"
                    fullWidth
                    InputLabelProps={{ shrink: props?.data != 'add' || formValues.per_km_charge ? true : false }}
                    onKeyDown={(e) => {
                      if (
                        (e.keyCode >= 48 && e.keyCode <= 57) ||
                        (e.keyCode >= 96 && e.keyCode <= 105) ||
                        (e.key >= 0 && e.key <= 9) ||
                        e.key == 'Backspace' ||
                        e.key == 'Delete'
                      ) {
                        console.log('ok');
                      } else {
                        e.preventDefault();
                      }
                    }}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.per_km_charge}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <Autocomplete
                    sx={{
                      '& .MuiOutlinedInput-root': {
                        padding: '0px',
                        paddingBottom: '5px'
                      },
                      '& .MuiOutlinedInput-root .MuiAutocomplete-input': {
                        paddingLeft: '15px'
                      },
                      maxWidth: 420
                    }}
                    disablePortal
                    id="combo-box-demo"
                    options={vehiclesStatus}
                    value={vehiclesStatus.find((stat) => stat.value === formValues.status)}
                    getOptionLabel={(option) => option.name || 'Select'}
                    onChange={(e, value) => {
                      updateFormValues('status', value?.value);
                    }}
                    isOptionEqualToValue={(option, value) => isOptionEqualToValue(option, value)}
                    renderInput={(params) => (
                      <TextField
                        sx={{
                          '& .MuiInputLabel-root': {
                            height: '1rem'
                          }
                        }}
                        {...params}
                        label="Status"
                        // InputLabelProps={{ shrink: props?.data != 'add' || !isEmpty(formValues.status) ? true : false }}
                      />
                    )}
                  />

                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.status}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    label="Number"
                    value={formValues.plate_number}
                    onChange={(e) => {
                      if (e.target.value.length <= 10) {
                        updateFormValues('plate_number', e.target.value);
                      }
                    }}
                    fullWidth
                    onKeyDown={(e) => {
                      const key = e.key.toLowerCase();
                      if ((key >= 'a' && key <= 'z') || (key >= '0' && key <= '9') || key === 'backspace') {
                        console.log('Valid key pressed');
                      } else {
                        e.preventDefault();
                      }
                    }}
                    InputLabelProps={{ shrink: props?.data != 'add' || formValues.plate_number ? true : false }}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.plate_number}
                  </span>
                </Grid>
              </Grid>
            </DialogContentText>
          </MainCard>
        </DialogContent>
        <DialogActions>
          <Button variant="contained" color="secondary" onClick={handleClose}>
            Cancel
          </Button>
          <Button variant="contained" onClick={(e) => onSubmit(e)}>
            Submit
          </Button>
        </DialogActions>
      </Dialog>
    </React.Fragment>
  );
};

export default CreateVehicle;
CreateVehicle.propTypes = {
  data: PropTypes.object.isRequired,
  closeModal: PropTypes.func.isRequired,
  handleClickOpenFlag: PropTypes.bool.isRequired
};
