import React, { useState, useEffect } from 'react';

const MapWithSearch = () => {
  const [map, setMap] = useState(null);
  const [searchInput, setSearchInput] = useState('');
  const [selectedLocation, setSelectedLocation] = useState(null);
  const [autocomplete, setAutocomplete] = useState(null);

  useEffect(() => {
    const mapInstance = new window.google.maps.Map(document.getElementById('map'), {
      center: { lat: 0, lng: 0 },
      zoom: 14
    });
    setMap(mapInstance);

    const autocompleteInstance = new window.google.maps.places.Autocomplete(document.getElementById('searchInput'));
    setAutocomplete(autocompleteInstance);

    autocompleteInstance.addListener('place_changed', () => {
      const place = autocompleteInstance.getPlace();
      if (!place.geometry) {
        console.error('Place not found');
        return;
      }
      const location = place.geometry.location;
      mapInstance.setCenter(location);
      setSelectedLocation({ lat: location.lat(), lng: location.lng() });
    });
  }, []);

  const handleInputChange = (event) => {
    setSearchInput(event.target.value);
  };

  const handleSearch = () => {
    if (autocomplete && searchInput !== '') {
      autocomplete.setFields(['geometry']);
      autocomplete.setBounds(map.getBounds());
    }
  };

  return (
    <div>
      <input id="searchInput" placeholder="Enter your address" value={searchInput} onChange={handleInputChange} />
      <button onClick={handleSearch}>Search</button>
      <div id="map" style={{ width: '100%', height: '400px', marginTop: '10px' }}></div>
    </div>
  );
};

export default MapWithSearch;
