import React, { useState, useEffect } from 'react';
import { setLocationListData, deleteLocationAction } from '../../store/reducers/location';
import { setCommonViewData } from '../../store/reducers/common';
import { useDispatch, useSelector } from 'react-redux';
import ModeEditIcon from '@mui/icons-material/ModeEdit';
import DeleteIcon from '@mui/icons-material/Delete';
import ViewIcon from '@mui/icons-material/Visibility';
import { DataGrid } from '@mui/x-data-grid';
import DeleteModal from '../../components/deleteModal/deleteModal';
import { toast } from 'react-toastify';
import EditModal from '../../components/editConfirm/editModal';

import {
  Avatar,
  AvatarGroup,
  Box,
  Button,
  Grid,
  List,
  ListItemAvatar,
  ListItemButton,
  ListItemSecondaryAction,
  ListItemText,
  MenuItem,
  Stack,
  TextField,
  Typography,
  Tooltip
} from '@mui/material';
import { PlusIcon } from 'utils/icons';
import CreateDriver from './createLocation';
import { deleteLocation, listLocation } from '../../apiCalls/locations';
import ViewDriver from './viewLocation';
import MainCard from 'components/MainCard';

const LocalityConfigurations = () => {
  const dispatch = useDispatch();
  const newLocationList = useSelector((state) => state?.location?.locations) || [];
  const [open, setOpen] = React.useState(false);
  const [showDeleteModal, setShowDeleteModal] = React.useState(false);
  const [showViewModal, setShowViewModal] = React.useState(false);
  const [list, setList] = React.useState('');
  const [selectedData, setSelectedData] = React.useState(null);
  const [showEditModal, setShowEditModal] = React.useState(false);
  useEffect(() => {
    listLocation().then((res) => {
      if (res?.data?.length > 0) {
        dispatch(setLocationListData(res?.data));
      }
    });
  }, []);

  useEffect(() => {
    setList(newLocationList);
  }, [newLocationList]);
  const onModeEditIconClick = (e, row) => {
    setSelectedData(row);
    setShowEditModal(true);
    // handleClickOpen(true);
  };
  const onDeleteIconClick = (e, row) => {
    setSelectedData(row);
    setShowDeleteModal(true);
  };
  const onViewIconClick = (e, row) => {
    setSelectedData(row);
    dispatch(setCommonViewData(row));
    setShowViewModal(true);
  };

  const closeEditModal = (flag) => {
    setSelectedData(null);
    setShowEditModal(false);
  };
  const doEdit = (flag) => {
    setShowEditModal(false);
    handleClickOpen(true);
  };

  const columns = [
    {
      field: 'id',
      headerName: 'Sl no',
      sortable: false,
      width: 70,
      disableColumnMenu: true,
      hideSortIcon: true,
      renderCell: (params) => {
        if (list.length > 0) {
          const indexToUpdate = list?.findIndex((location) => location.id === params.id);
          return <>{indexToUpdate + 1}</>;
        }
      }
    },
    {
      field: 'Location Name',
      headerName: 'name',
      width: 120,
      editable: false,
      renderCell: (params) => {
        return <>{params.row.name}</>;
      }
    },
    {
      field: 'latitude',
      headerName: 'Latitude',
      width: 210,
      sortable: false,
      disableColumnMenu: true,
      editable: false
    },
    {
      field: 'longitude',
      headerName: 'Longitude',
      width: 210,
      editable: false
    },
    {
      field: 'actions',
      headerName: 'Actions',
      sortable: false,
      hideMenu: true,
      // width: 400,
      renderCell: (params) => {
        return (
          <>
            <Tooltip title="Edit the details" placement="top">
              <ModeEditIcon style={{ cursor: 'pointer' }} color="primary" onClick={(e) => onModeEditIconClick(e, params.row)}>
                Edit
              </ModeEditIcon>
            </Tooltip>{' '}
            &nbsp; &nbsp;
            <Tooltip title="Delete the details" placement="top">
              <DeleteIcon color="primary" style={{ cursor: 'pointer', color: '#ff4d4f' }} onClick={(e) => onDeleteIconClick(e, params.row)}>
                Delete
              </DeleteIcon>
            </Tooltip>{' '}
            {/* &nbsp; &nbsp;
            <Tooltip title="View the details" placement="top">
              <ViewIcon color="primary" style={{ cursor: 'pointer', color: '#1fb141' }} onClick={(e) => onViewIconClick(e, params.row)}>
                View
              </ViewIcon>
            </Tooltip>{' '} */}
          </>
        );
      }
    }
  ];

  const handleClickOpen = (flag) => {
    setOpen(flag);
  };

  const closeModal = (flag) => {
    setSelectedData(null);
    setOpen(false);
  };
  const closeDeleteModal = (flag) => {
    setSelectedData(null);
    setShowDeleteModal(false);
  };
  const closeViewModal = (flag) => {
    setSelectedData(null);
    setShowViewModal(false);
  };
  const deleteItem = async () => {
    try {
      await deleteLocation(selectedData?.id).then((res) => {
        if (res) {
          toast.success(`${'Vehicle deleted successfully'}`, {
            autoClose: 1500
          });
          dispatch(deleteLocationAction(selectedData));
          setShowDeleteModal(false);
          setSelectedData(null);
        } else {
          // if (res?.response?.data.status == 0) {
          toast.error(`${'Something went wrong, please try later'}`, {
            autoClose: 1500
          });
          // }
        }
      });
    } catch (err) {
      // console.log('err', err);
    }
  };
  const doDelete = (flag) => {
    deleteItem(selectedData);
    setShowDeleteModal(false);
  };

  return (
    <Grid container rowSpacing={4.5} columnSpacing={2.75}>
      <Grid item xs={12} md={12} lg={12}>
        <Grid container alignItems="center" justifyContent="space-between">
          <Grid item>
            <Typography variant="h5">Locality Configurations Management</Typography>
          </Grid>
          <Grid item />
          <Grid item>
            <Tooltip title="Create LocalityConfigurations" placement="top">
              <Button onClick={() => handleClickOpen(true)} variant="contained" color="primary" startIcon={<PlusIcon />}>
                Create Locality Configurations
              </Button>
            </Tooltip>
          </Grid>
        </Grid>
        <CreateDriver handleClickOpenFlag={open} data={selectedData || 'add'} closeModal={(e) => closeModal(e)} />
        <DeleteModal
          handleClickOpenDeleteFlag={showDeleteModal}
          doDelete={(e) => doDelete(e)}
          data={selectedData}
          closeDeleteModal={(e) => closeDeleteModal(e)}
          heading={'Are you sure do you want to delete the location' + selectedData?.first_name + ' ' + selectedData?.last_name + '?'}
        />
        <EditModal
          handleClickOpenEditFlag={showEditModal}
          doEdit={(e) => doEdit(e)}
          data={selectedData}
          closeEditModal={(e) => closeEditModal(e)}
        />
        <ViewDriver handleClickOpenViewFlag={showViewModal} data={selectedData} closeViewModal={(e) => closeViewModal(e)} />

        <MainCard sx={{ mt: 2 }} content={false}>
          <div>
            <Box sx={{ height: 400, width: '100%' }}>
              <DataGrid
                sx={{
                  '.MuiDataGrid-columnHeaders': {
                    backgroundColor: '#1677ff',
                    opacity: '.75'
                  },
                  '.MuiDataGrid-columnHeaderTitle': {
                    color: 'white',
                    fontSize: '14px'
                  },
                  '.MuiTablePagination-selectLabel': {
                    marginTop: '12px'
                  },
                  '.MuiTablePagination-displayedRows': {
                    marginTop: '12px'
                  },
                  '.MuiDataGrid-row.Mui-odd': {
                    backgroundColor: '#a5e5a54d'
                  },
                  '.MuiDataGrid-sortIcon': {
                    color: 'white'
                  }
                }}
                rows={list}
                columns={columns}
                // initialState={{
                //   pagination: {
                //     paginationModel: {
                //       pageSize: 5
                //     }
                //   }
                // }}
                checkboxSelection={false}
                pageSizeOptions={[5, 10, 50, 100]}
                disableRowSelectionOnClick
                getRowClassName={(params) => (params.indexRelativeToCurrentPage % 2 === 0 ? 'Mui-even' : 'Mui-odd')}
              />
            </Box>
          </div>
        </MainCard>
      </Grid>
    </Grid>
  );
};

export default LocalityConfigurations;
