import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';
import { isEmpty, isEqual } from 'lodash';
import { addLocation, updateLocation, listLocation } from '../../apiCalls/locations';
import { toast } from 'react-toastify';
import { addLocationAction, updateLocationAction } from '../../store/reducers/location';
import { setLocationListData } from '../../store/reducers/location';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { GoogleMap, MarkerF } from '@react-google-maps/api';

import {
  Button,
  Grid,
  TextField,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton,
  Autocomplete,
  Box
} from '@mui/material';

import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';
import { useDispatch, useSelector } from 'react-redux';
import usePlacesAutocomplete, { getGeocode, getLatLng } from 'use-places-autocomplete';
import useOnclickOutside from 'react-cool-onclickoutside';
// import GoogleMaps from 'components/googlemap';

const CreateLocation = (props) => {
  const {
    ready,
    value,
    suggestions: { status, data },
    setValue,
    clearSuggestions
  } = usePlacesAutocomplete({
    callbackName: 'initmap',
    requestOptions: {
      /* Define search scope here */
    },
    debounce: 300
  });

  const ref = useOnclickOutside(() => {
    // When the user clicks outside of the component, we can dismiss
    // the searched suggestions by calling this method
    clearSuggestions();
  });

  const handleInput = (e) => {
    setValue(e.target.value);
  };
  const handleSelect = (val) => {
    setAutovalue(val);
    updateFormValues('name', val?.description?.split(',')[0]);
    setValue(val?.description, false);
    clearSuggestions();
    getGeocode({ address: val?.description }).then((results) => {
      const { lat, lng } = getLatLng(results[0]);
      setSelectedLocation({ lat: lat, lng: lng });
      setFormData((prevFormData) => ({
        ...prevFormData,
        lat: lat,
        lng: lng
      }));
    });
  };

  const dispatch = useDispatch();
  const [open, setOpen] = useState(props.handleClickOpenFlag);
  const [validationMsg, setValidationMsg] = useState({});
  const [selectedLocation, setSelectedLocation] = useState(null);
  const [autoval, setAutovalue] = useState(null);
  const mapContainerStyle = {
    width: '60%',
    height: '50vh'
  };
  const center = {
    lat: 8.557777314828595,
    lng: 76.88076833661518
  };

  const [scroll, setScroll] = useState('paper');
  const [formValues, setFormData] = useState({});
  const handleMapClick = (e) => {
    setAutovalue('');
    setValue('');
    setFormData((prevFormData) => ({
      ...prevFormData,
      lat: e.latLng.lat(),
      lng: e.latLng.lng(),
      name: ''
    }));
    setSelectedLocation((prevFormData) => ({
      ...prevFormData,
      lat: e.latLng.lat(),
      lng: e.latLng.lng()
    }));
  };
  useEffect(() => {
    if (props.data != 'add') {
      setFormData({
        name: props.data.name,
        lat: props.data.latitude,
        lng: props.data.longitude
      });
      setSelectedLocation({ lat: props.data.latitude, lng: props.data.longitude });
    }
  }, [props.data]);
  const updateFormValues = (feild, value) => {
    setValidationMsg({});
    let curValues = { ...formValues };
    curValues[`${feild}`] = value;
    setFormData(curValues);
  };
  const validateForm = () => {
    let validationMessages = { ...validationMsg };
    const { name, lat, lng } = formValues;

    if (isEmpty(name) || name.length < 3) {
      validationMessages.name = 'Please enter valid name';
    }

    if (lat == null) {
      validationMessages.latitude = 'Please select location';
    }
    if (lng == null) {
      validationMessages.longitude = 'Please select location';
    }

    setValidationMsg(validationMessages);
    return isEmpty(Object.keys(validationMessages));
  };
  const onSubmit = async () => {
    const validForm = validateForm();
    const dataUp = { name: formValues?.name, latitude: formValues?.lat, longitude: formValues?.lng };
    if (validForm) {
      if (props?.data == 'add') {
        try {
          await addLocation(dataUp).then((res) => {
            if (res?.statusText == 'Created') {
              listLocation().then((res2) => {
                if (res2?.data) {
                  dispatch(setLocationListData(res2?.data));
                }
              });
              // dispatch(addLocationAction(res?.data?.vehicle));
              toast.success(`${'Location created successfully'}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              if (res?.status == 0) {
                toast.error(`${res?.message}`, {
                  autoClose: 1500
                });
              }
            }
          });
        } catch (err) {
          // console.log('err', err);
        }
      } else {
        try {
          await updateLocation(props?.data?.id, formValues).then((res) => {
            if (res?.statusText == 'OK') {
              listLocation().then((res) => {
                if (res?.data) {
                  dispatch(setLocationListData(res?.data));
                }
              });
              // dispatch(updateLocationAction(res?.data?.vehicle));
              toast.success(`${'Data updated successfully'}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              // if (res?.status == 0) {
              toast.error(`${'Please try later'}`, {
                autoClose: 1500
              });
              // }
            }
          });
        } catch (err) {
          console.log('err', err);
        }
      }
    }
  };

  const handleClose = () => {
    props.closeModal(false);
    setFormData('');
    setValidationMsg('');
  };
  // useEffect(() => {
  //   console.log('selectedLocation', selectedLocation);
  // }, [selectedLocation]);

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenFlag);
  }, [props.handleClickOpenFlag]);

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <DialogTitle id="scroll-dialog-title">
          <Grid container justifyContent="space-between" alignItems="center">
            <Grid item>
              <Typography variant="h5">Location Management</Typography>
            </Grid>
            <Grid item>
              <Tooltip title="Close" placement="top">
                <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                  <CloseIcon />
                </IconButton>
              </Tooltip>
            </Grid>
          </Grid>
        </DialogTitle>
        <DialogContent dividers={scroll === 'paper'}>
          <MainCard
            sx={{
              padding: 2
            }}
            content={false}
          >
            <DialogContentText id="scroll-dialog-description" ref={descriptionElementRef} tabIndex={-1}>
              <Grid container spacing={2} style={{ width: 900 }}>
                <Grid item xs={3}>
                  <Grid item xs={12}>
                    <TextField
                      sx={{
                        '& .MuiInputLabel-root': {
                          height: '1rem'
                        }
                      }}
                      value={formValues.name}
                      onChange={(e) => {
                        updateFormValues('name', e.target.value);
                      }}
                      InputLabelProps={{ shrink: props?.data != 'add' || formValues.name }}
                      label="Location Name"
                      onKeyDown={(e) => {
                        const key = e.key.toLowerCase();
                        if ((key >= 'a' && key <= 'z') || key === 'backspace' || key === ' ') {
                          console.log('');
                        } else {
                          e.preventDefault();
                        }
                      }}
                      fullWidth
                    />
                    <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                      {validationMsg?.name}
                    </span>
                  </Grid>
                  <br></br>

                  <Grid item xs={12}>
                    <TextField
                      label="Latitude"
                      sx={{
                        '& .MuiInputLabel-root': {
                          height: '1rem'
                        }
                      }}
                      value={formValues.lat}
                      disabled
                      InputLabelProps={{ shrink: props?.data != 'add' || formValues.lat ? true : false }}
                      onChange={(e) => updateFormValues('lat', e.target.value)}
                      fullWidth
                      onKeyDown={(e) => {
                        if (
                          (e.keyCode >= 48 && e.keyCode <= 57) ||
                          (e.keyCode >= 96 && e.keyCode <= 105) ||
                          (e.key >= 0 && e.key <= 9) ||
                          e.key == 'Backspace' ||
                          e.key == 'Delete'
                        ) {
                          console.log('');
                        } else {
                          e.preventDefault();
                        }
                      }}
                    />
                    <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                      {validationMsg?.latitude}
                    </span>
                  </Grid>
                  <br></br>
                  <Grid item xs={12}>
                    <TextField
                      label="Longitude"
                      sx={{
                        '& .MuiInputLabel-root': {
                          height: '1rem'
                        }
                      }}
                      InputLabelProps={{ shrink: props?.data != 'add' || formValues.lng ? true : false }}
                      disabled
                      value={formValues.lng}
                      onChange={(e) => updateFormValues('lng', e.target.value)}
                      fullWidth
                      onKeyDown={(e) => {
                        if (
                          (e.keyCode >= 48 && e.keyCode <= 57) ||
                          (e.keyCode >= 96 && e.keyCode <= 105) ||
                          (e.key >= 0 && e.key <= 9) ||
                          e.key == 'Backspace' ||
                          e.key == 'Delete'
                        ) {
                          console.log('');
                        } else {
                          e.preventDefault();
                        }
                      }}
                    />
                    <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                      {validationMsg?.longitude}
                    </span>
                  </Grid>
                </Grid>

                <Grid item xs={9}>
                  <div
                  //  style={{ backgroundColor: 'lightblue' }}
                  >
                    <div style={{ height: '300px' }}>
                      <div ref={ref}>
                        <div style={{ width: '60%', marginBottom: '10px' }} className="mb-3">
                          <Autocomplete
                            value={autoval || ''}
                            sx={{
                              '& .MuiOutlinedInput-root': {
                                backgroundColor: 'white',

                                legend: {
                                  marginLeft: '10px'
                                }
                              },
                              '& .MuiAutocomplete-inputRoot': {
                                paddingLeft: '20px !important',
                                borderRadius: '50px',
                                height: '50px'
                              }
                            }}
                            disablePortal
                            id="combo-box-demo"
                            className="w-100"
                            autoHighlight
                            options={data}
                            getOptionLabel={(data) => {
                              if (data) {
                                return data?.structured_formatting?.main_text + ' ' + (data?.structured_formatting?.secondary_text ?? '');
                              } else {
                                return '';
                              }
                            }}
                            // renderOption={(props1, option) => (
                            //   <Box component="li" sx={{ '& > img': { mr: 2, flexShrink: 0 } }} {...props1}>
                            //     {option?.structured_formatting?.main_text + (option?.structured_formatting?.secondary_text ?? '')}
                            //   </Box>
                            // )}
                            onChange={(event, newValue) => {
                              if (newValue?.description) {
                                handleSelect(newValue);
                              }
                            }}
                            renderInput={(params) => (
                              <TextField
                                {...params}
                                label="Search the place"
                                inputProps={{
                                  ...params.inputProps
                                }}
                                onChange={(e) => {
                                  if (e?.target?.value?.length >= 1) {
                                    handleInput(e);
                                  }
                                }}
                                sx={{
                                  '& .MuiInputLabel-root': {
                                    paddingTop: '4px',
                                    height: '1.2rem'
                                  }
                                }}
                              />
                            )}
                          />
                        </div>
                      </div>
                      <GoogleMap
                        onClick={(e) => handleMapClick(e)}
                        mapContainerStyle={mapContainerStyle}
                        zoom={16}
                        center={selectedLocation || center}
                      >
                        <MarkerF position={selectedLocation || center}></MarkerF>
                      </GoogleMap>
                    </div>
                  </div>
                </Grid>
              </Grid>
            </DialogContentText>
          </MainCard>
        </DialogContent>
        <DialogActions>
          <Button variant="contained" color="secondary" onClick={handleClose}>
            Cancel
          </Button>
          <Button variant="contained" onClick={(e) => onSubmit(e)}>
            Submit
          </Button>
        </DialogActions>
      </Dialog>
    </React.Fragment>
  );
};

export default CreateLocation;
CreateLocation.propTypes = {
  data: PropTypes.object.isRequired,
  closeModal: PropTypes.func.isRequired,
  handleClickOpenFlag: PropTypes.bool.isRequired
};
