import React, { useState, useEffect } from 'react';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { DatePicker } from '@mui/x-date-pickers/DatePicker';
import PropTypes from 'prop-types';
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormLabel from '@mui/material/FormLabel';
import { isEmpty, isEqual } from 'lodash';
import { FormControl, InputLabel, Select } from '@mui/material';
import Autocomplete from '@mui/material/Autocomplete';
import { addVehicle, updateVehicle } from '../../apiCalls/vehicle';
import { toast } from 'react-toastify';
import { addVehicleAction, updateVehicleAction } from '../../store/reducers/vehicles';
import { setDriverListData } from '../../store/reducers/driver';

import {
  Paper,
  Avatar,
  AvatarGroup,
  Box,
  Button,
  Grid,
  List,
  ListItemAvatar,
  ListItemButton,
  ListItemSecondaryAction,
  ListItemText,
  MenuItem,
  Stack,
  ToggleButton,
  ToggleButtonGroup,
  TextField,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton,
  FormControlLabel,
  Checkbox
} from '@mui/material';

import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';
import { useDispatch, useSelector } from 'react-redux';
import { addDriver, updateDriver, listDrivers } from 'apiCalls/driver';

const CreateDriver = (props) => {
  const dispatch = useDispatch();
  const [open, setOpen] = useState(props.handleClickOpenFlag);
  const [validationMsg, setValidationMsg] = useState({});
  const [error, setError] = useState('');
  const [selectedDate, setSelectedDate] = useState(null);
  const [scroll, setScroll] = useState('paper');
  const [formValues, setFormData] = useState({});
  useEffect(() => {
    if (props.data != 'add') {
      setFormData({
        mobile_number: props.data.mobile_number,
        gender: props.data.gender,
        first_name: props.data.first_name,
        last_name: props.data.last_name,
        email: props.data.email,
        age: props.data.age,
        license_number: props.data.license_number,
        is_verified: props.data.is_verified
      });
    }
  }, [props.data]);
  const updateFormValues = (feild, value) => {
    setValidationMsg({});
    setError('');
    let curValues = { ...formValues };
    curValues[`${feild}`] = value;
    setFormData(curValues);
  };
  const validateForm = () => {
    let validationMessages = { ...validationMsg };
    const { mobile_number, password, gender, first_name, last_name, email, age, is_verified, license_number } = formValues;

    if (isEmpty(mobile_number) || !mobile_number.match('^[0-9]{10}$')) {
      validationMessages.mobile_number = 'Please enter valid mobile number';
    }
    if (props?.data == 'add') {
      if (isEmpty(password) || password?.length < 6) {
        validationMessages.password = 'Please enter valid password';
      }
    }
    if (isEmpty(gender)) {
      validationMessages.gender = 'Please select gender';
    }
    if (isEmpty(first_name)) {
      validationMessages.first_name = 'Please enter first name';
    }
    if (isEmpty(last_name)) {
      validationMessages.last_name = 'Please enter last name';
    }
    if (age == null || age < 18) {
      validationMessages.age = 'Please enter valid age';
    }
    if (isEmpty(email) || !email?.match('^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$')) {
      validationMessages.email = 'Please enter email';
    }
    if (isEmpty(license_number)) {
      validationMessages.license_number = 'Please enter license number';
    }
    if (is_verified == null) {
      validationMessages.is_verified = 'Please choose verification status';
    }

    setValidationMsg(validationMessages);
    return isEmpty(Object.keys(validationMessages));
  };
  const onSubmit = async () => {
    const validForm = validateForm();
    console.log('validForm', validForm);
    console.log('validationMsg', validationMsg);

    if (validForm) {
      if (props?.data == 'add') {
        try {
          await addDriver(formValues).then((res) => {
            if (res?.data?.status == 1) {
              listDrivers({
                is_driver: 'True'
              }).then((res) => {
                if (res?.data?.status == 1) {
                  dispatch(setDriverListData(res?.data?.data));
                }
              });

              // dispatch(addVehicleAction(res?.data?.vehicle));
              toast.success(`${res?.data?.message}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              if (res?.status == 0) {
                toast.error(`${res?.message}`, {
                  autoClose: 1500
                });
              }
            }
          });
        } catch (err) {
          // console.log('err', err);
        }
      } else {
        try {
          await updateDriver(props?.data?.id, formValues).then((res) => {
            if (res?.data?.status == 1) {
              listDrivers({
                is_driver: 'True'
              }).then((res) => {
                if (res?.data?.status == 1) {
                  dispatch(setDriverListData(res?.data?.data));
                }
              });
              // dispatch(updateVehicleAction(res?.data?.vehicle));
              toast.success(`${res?.data?.message}`, {
                autoClose: 1500
              });
              handleClose();
            } else {
              if (res?.status == 0) {
                toast.error(`${res?.message}`, {
                  autoClose: 1500
                });
              }
            }
          });
        } catch (err) {
          console.log('err', err);
        }
      }
    }
  };
  const handleIsVerifiedChange = (event, newValue) => {
    updateFormValues('is_verified', newValue);
  };

  const handleClose = () => {
    props.closeModal(false);
    setFormData('');
    setValidationMsg('');
  };
  // useEffect(() => {
  //   console.log('valiii', validationMsg);
  // }, [validationMsg]);

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenFlag);
  }, [props.handleClickOpenFlag]);
  // useEffect(() => {
  //   console.log('form', formValues);
  // }, [formValues]);

  const genderArray = [
    { id: 1, name: 'Male', value: 'male' },
    { id: 2, name: 'Female', value: 'female' }
  ];

  const isOptionEqualToValue = (option, value) => option?.value == value?.value;

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <DialogTitle id="scroll-dialog-title">
          <Grid container justifyContent="space-between" alignItems="center">
            <Grid item>
              <Typography variant="h5">Driver Management</Typography>
            </Grid>
            <Grid item>
              <Tooltip title="Close" placement="top">
                <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                  <CloseIcon />
                </IconButton>
              </Tooltip>
            </Grid>
          </Grid>
        </DialogTitle>
        <DialogContent dividers={scroll === 'paper'}>
          <MainCard
            sx={{
              padding: 2
            }}
            content={false}
          >
            <DialogContentText id="scroll-dialog-description" ref={descriptionElementRef} tabIndex={-1}>
              <Grid container spacing={2}>
                <Grid item xs={12}>
                  <Typography variant="h5">Driver information</Typography>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    value={formValues.mobile_number}
                    onChange={(e) => {
                      if (e.target.value.length <= 10) {
                        updateFormValues('mobile_number', e.target.value);
                      }
                    }}
                    label="Mobile number"
                    onKeyDown={(e) => {
                      if (
                        (e.keyCode >= 48 && e.keyCode <= 57) ||
                        (e.keyCode >= 96 && e.keyCode <= 105) ||
                        (e.key >= 0 && e.key <= 9) ||
                        e.key == 'Backspace' ||
                        e.key == 'Delete'
                      ) {
                        console.log('ok');
                      } else {
                        e.preventDefault();
                      }
                    }}
                    // error={validationMsg.mobile_number}
                    fullWidth
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.mobile_number}
                  </span>
                </Grid>
                {props?.data == 'add' ? (
                  <Grid item xs={4}>
                    <TextField
                      sx={{
                        '& .MuiInputLabel-root': {
                          height: '1rem'
                        }
                      }}
                      value={formValues.password}
                      onChange={(e) => updateFormValues('password', e.target.value)}
                      label="Password"
                      fullWidth
                      // error={validationMsg.password}
                    />
                    <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                      {validationMsg?.password}
                    </span>
                  </Grid>
                ) : null}
                <Grid item xs={4}>
                  <TextField
                    label="First Name"
                    value={formValues.first_name}
                    onChange={(e) => updateFormValues('first_name', e.target.value)}
                    fullWidth
                    onKeyDown={(e) => {
                      // Get the key pressed
                      const key = e.key.toLowerCase();

                      // Check if the key is a letter or space
                      if ((key >= 'a' && key <= 'z') || key === 'backspace' || key === ' ') {
                        console.log('Valid key pressed');
                      } else {
                        e.preventDefault(); // Prevent input if the key is not a letter or space
                      }
                    }}
                    // error={validationMsg.first_name}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.first_name}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    label="Last Name"
                    value={formValues.last_name}
                    onKeyDown={(e) => {
                      // Get the key pressed
                      const key = e.key.toLowerCase();

                      // Check if the key is a letter or space
                      if ((key >= 'a' && key <= 'z') || key === 'backspace' || key === ' ') {
                        console.log('Valid key pressed');
                      } else {
                        e.preventDefault(); // Prevent input if the key is not a letter or space
                      }
                    }}
                    // error={validationMsg.last_name}
                    onChange={(e) => updateFormValues('last_name', e.target.value)}
                    fullWidth
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.last_name}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    label="Lisense number"
                    value={formValues.license_number}
                    onChange={(e) => updateFormValues('license_number', e.target.value)}
                    fullWidth
                    onKeyDown={(e) => {
                      const key = e.key.toLowerCase();
                      if ((key >= 'a' && key <= 'z') || (key >= '0' && key <= '9') || key === 'backspace') {
                        console.log('Valid key pressed');
                      } else {
                        e.preventDefault();
                      }
                    }}
                    // error={validationMsg.license_number}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.license_number}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    // InputProps={{
                    //   inputProps: {
                    //     pattern: '^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$',
                    //     title: 'Enter a valid email address'
                    //   }
                    // }}
                    // error={formValues?.email && !formValues?.email?.match('^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$')}
                    label="Email"
                    value={formValues.email}
                    onChange={(e) => updateFormValues('email', e.target.value)}
                    fullWidth
                    // error={validationMsg.email}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.email}
                  </span>
                </Grid>
                <Grid item xs={4}>
                  <TextField
                    sx={{
                      '& .MuiInputLabel-root': {
                        height: '1rem'
                      }
                    }}
                    label="Age"
                    value={formValues.age}
                    onChange={(e) => {
                      if (e.target.value.length <= 2) {
                        updateFormValues('age', e.target.value);
                      }
                    }}
                    fullWidth
                    // error={validationMsg.age}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.age}
                  </span>
                </Grid>{' '}
                <Grid item xs={4}>
                  <Autocomplete
                    sx={{
                      '& .MuiOutlinedInput-root': {
                        padding: '0px',
                        paddingBottom: '5px',
                        paddingLeft: '7px'
                      },
                      maxWidth: 420
                    }}
                    options={genderArray}
                    value={genderArray.find((gen) => gen.value === formValues.gender)}
                    isOptionEqualToValue={(option, value) => isOptionEqualToValue(option, value)}
                    onChange={(e, value) => {
                      updateFormValues('gender', value?.value);
                    }}
                    getOptionLabel={(option) => option.name || 'Select'}
                    renderInput={(params) => (
                      <TextField
                        sx={{
                          '& .MuiInputLabel-root': {
                            height: '1rem'
                          }
                        }}
                        {...params}
                        label="Gender"
                        // error={validationMsg.gender}
                      />
                    )}
                  />
                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.gender}
                  </span>
                </Grid>{' '}
                <Grid item xs={4}>
                  <ToggleButtonGroup
                    sx={{
                      transform: 'scale(.85)',
                      border: '1px solid #b0adad',
                      '&:hover': {
                        border: '1px solid #1677ff' // Border on hover
                      },
                      marginTop: '-5px',
                      marginLeft: '-12px'
                    }}
                    value={formValues.is_verified}
                    exclusive
                    onChange={(e, v) => handleIsVerifiedChange(e, v)}
                    // error={validationMsg.is_verified}
                  >
                    <ToggleButton value={true}>Verified</ToggleButton>
                    <ToggleButton value={false}>Not Verified</ToggleButton>
                  </ToggleButtonGroup>
                  <br></br>

                  <span style={{ color: 'red', fontSize: '12px' }} className="errorMsg">
                    {validationMsg?.is_verified}
                  </span>
                </Grid>
              </Grid>
            </DialogContentText>
          </MainCard>
        </DialogContent>
        <DialogActions>
          <Button variant="contained" color="secondary" onClick={handleClose}>
            Cancel
          </Button>
          <Button variant="contained" onClick={(e) => onSubmit(e)}>
            Submit
          </Button>
        </DialogActions>
      </Dialog>
    </React.Fragment>
  );
};

export default CreateDriver;
CreateDriver.propTypes = {
  data: PropTypes.object.isRequired,
  closeModal: PropTypes.func.isRequired,
  handleClickOpenFlag: PropTypes.bool.isRequired
};
