import React, { useState, useEffect, useMemo } from 'react';
import PropTypes from 'prop-types';
import { useDispatch, useSelector } from 'react-redux';

import { Grid, Typography, Tooltip, Dialog, DialogActions, DialogContent, DialogContentText, DialogTitle, IconButton } from '@mui/material';

import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';

const ViewCustomer = (props) => {
  // const commonData = useMemo(() => useSelector((state) => state?.common?.commonData) || [], []);

  const commonData = useSelector((state) => state?.common?.commonData) || [];
  console.log('commonData', commonData);
  const [open, setOpen] = useState(props.handleClickOpenViewFlag);
  const [viewData, setViewData] = useState(props.data);
  const [scroll, setScroll] = useState('paper');
  const handleClose = () => {
    props.closeViewModal(false);
    setViewData('');
  };
  useEffect(() => {
    setViewData(commonData);
  }, [commonData]);

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenViewFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenViewFlag);
  }, [props.handleClickOpenViewFlag]);

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <>
          <DialogTitle id="scroll-dialog-title">
            <Grid container justifyContent="space-between" alignItems="center">
              <Grid item>
                <Typography variant="h5">Customer Details</Typography>
              </Grid>
              <Grid item>
                <Tooltip title="Close" placement="top">
                  <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                    <CloseIcon />
                  </IconButton>
                </Tooltip>
              </Grid>
            </Grid>
          </DialogTitle>
          <DialogContent dividers={scroll === 'paper'}>
            <MainCard
              sx={{
                padding: 2
              }}
              content={false}
            >
              <Grid container spacing={2}>
                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>ID:</strong> {viewData?.id}
                  </Typography>
                </Grid>

                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>Mobile number:</strong> {viewData?.mobile_number}
                  </Typography>
                </Grid>

                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>Gender:</strong> {viewData?.gender}
                  </Typography>
                </Grid>

                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>Name:</strong> {viewData?.first_name + ' ' + viewData?.last_name}
                  </Typography>
                </Grid>

                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>Is verified:</strong> {viewData?.is_verified == true ? 'Yes' : 'No'}
                  </Typography>
                </Grid>

                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>Age:</strong> {viewData?.age}
                  </Typography>
                </Grid>
                <Grid item xs={4}>
                  <Typography variant="body1" gutterBottom>
                    <strong>Email:</strong> {viewData?.email}
                  </Typography>
                </Grid>
              </Grid>
            </MainCard>
          </DialogContent>
        </>
      </Dialog>
    </React.Fragment>
  );
};

export default ViewCustomer;
ViewCustomer.propTypes = {
  data: PropTypes.object.isRequired,
  closeViewModal: PropTypes.func.isRequired,
  handleClickOpenViewFlag: PropTypes.bool.isRequired
};
