import React, { useState, useEffect } from 'react';
import { setDriverListData, deleteDriverAction } from '../../store/reducers/driver';
import { setCommonViewData } from '../../store/reducers/common';
import { useDispatch, useSelector } from 'react-redux';
import ModeEditIcon from '@mui/icons-material/ModeEdit';
import DeleteIcon from '@mui/icons-material/Delete';
import ViewIcon from '@mui/icons-material/Visibility';
import { DataGrid } from '@mui/x-data-grid';
import DeleteModal from '../../components/deleteModal/deleteModal';
import { toast } from 'react-toastify';
import { Box, Button, Grid, Typography, Tooltip, FormControl, InputAdornment, OutlinedInput } from '@mui/material';
import { PlusIcon } from 'utils/icons';
import { SearchOutlined } from '@ant-design/icons';
// import CreateDriver from './createDriver';
import { deleteDriver, listDrivers } from '../../apiCalls/driver';
import ViewCustomer from './viewCustomer';
import MainCard from 'components/MainCard';

const Customer = () => {
  const dispatch = useDispatch();

  const [searchResults, setSearchResults] = useState([]);
  const [searchTerm, setSearchTerm] = useState('');
  const newDriverList = useSelector((state) => state?.driver?.drivers) || [];
  const [open, setOpen] = React.useState(false);
  const [showDeleteModal, setShowDeleteModal] = React.useState(false);
  const [showViewModal, setShowViewModal] = React.useState(false);
  const [list, setList] = React.useState('');
  const [selectedData, setSelectedData] = React.useState(null);

  useEffect(() => {
    if (Array.isArray(newDriverList)) {
      console.log('newDriverList', newDriverList);
      const swappedArray = newDriverList?.filter((item) => item.first_name != '' && item.mobile_number != '')?.reverse();
      setList(swappedArray);
    }
  }, [newDriverList]);
  const search = (query) => {
    return list.filter((item) => {
      return (
        item.last_name.toLowerCase().includes(query.toLowerCase()) ||
        item.first_name.toLowerCase().includes(query.toLowerCase()) ||
        item.mobile_number.includes(query)
      );
    });
  };
  const onSearchClick = (val) => {
    setSearchResults(search(val));
    setSearchTerm(val);
  };
  const onModeEditIconClick = (e, row) => {
    setSelectedData(row);
    handleClickOpen(true);
  };
  const onDeleteIconClick = (e, row) => {
    setSelectedData(row);
    setShowDeleteModal(true);
  };
  const onViewIconClick = (e, row) => {
    setSelectedData(row);
    dispatch(setCommonViewData(row));
    setShowViewModal(true);
  };
  // console.log('selected', selectedData);
  const columns = [
    {
      field: 'id',
      headerName: 'Sl no',
      sortable: false,
      width: 70,
      hideSortIcon: true,
      disableColumnMenu: true,
      renderCell: (params) => {
        if (list.length > 0) {
          const indexToUpdate = list?.findIndex((driver) => driver.id === params.id);
          return <>{indexToUpdate + 1}</>;
        }
      }
    },
    {
      field: 'first_name',
      headerName: 'Full Name',
      width: 120,
      editable: false,
      renderCell: (params) => {
        return <>{params.row.first_name + ' ' + (params.row.last_name != null ? params.row.last_name : '')}</>;
      }
    },
    {
      field: 'mobile_number',
      headerName: 'Mobile number',
      type: 'number',
      width: 110,
      editable: false
    },
    {
      field: 'email',
      headerName: 'Email',
      width: 170,
      editable: false
    },
    // {
    //   field: 'gender',
    //   headerName: 'Gender',
    //   width: 70,
    //   editable: false
    // },
    // {
    //   field: 'age',
    //   headerName: 'Age',
    //   width: 70,
    //   editable: false
    // },
    {
      field: 'is_verified',
      headerName: 'is verified',
      description: 'This column has a value getter and is not sortable.',
      sortable: false,
      hideMenu: true,
      width: 90,
      renderCell: (params) => <div className="mx-auto text-center py-1">{params?.row?.is_verified != false ? 'Yes' : 'No'} </div>
    },
    {
      field: 'actions',
      headerName: 'Actions',
      sortable: false,
      hideMenu: true,
      // width: 400,
      renderCell: (params) => {
        return (
          <>
            {/* <ModeEditIcon style={{ cursor: 'pointer' }} color="primary" onClick={(e) => onModeEditIconClick(e, params.row)}>
              Edit
            </ModeEditIcon>{' '} */}
            {/* &nbsp; &nbsp;
            <DeleteIcon color="primary" style={{ cursor: 'pointer' }} onClick={(e) => onDeleteIconClick(e, params.row)}>
              Delete
            </DeleteIcon>{' '}
            &nbsp; &nbsp; */}
            <Tooltip title="View the details" placement="top">
              <ViewIcon color="primary" style={{ cursor: 'pointer', color: '#1fb141' }} onClick={(e) => onViewIconClick(e, params.row)}>
                View
              </ViewIcon>
            </Tooltip>{' '}
          </>
        );
      }
    }
  ];
  useEffect(() => {
    var data = {
      is_driver: 'False'
    };
    listDrivers(data).then((res) => {
      if (res?.data?.status == 1) {
        dispatch(setDriverListData(res?.data?.data));
      }
    });
  }, []);
  const handleClickOpen = (flag) => {
    setOpen(flag);
  };

  const closeModal = (flag) => {
    setSelectedData(null);
    setOpen(false);
  };
  const closeDeleteModal = (flag) => {
    setSelectedData(null);
    setShowDeleteModal(false);
  };
  const closeViewModal = (flag) => {
    setSelectedData(null);
    setShowViewModal(false);
  };
  const deleteItem = async () => {
    try {
      await deleteDriver(selectedData?.id).then((res) => {
        if (res?.data?.status == 1) {
          toast.success(`${res?.data?.message}`, {
            autoClose: 1500
          });
          dispatch(deleteDriverAction(selectedData));
          setShowDeleteModal(false);
          setSelectedData(null);
        } else {
          if (res?.response?.data.status == 0) {
            toast.error(`${res?.message}`, {
              autoClose: 1500
            });
          }
        }
      });
    } catch (err) {
      // console.log('err', err);
    }
  };
  const doDelete = (flag) => {
    deleteItem(selectedData);
    setShowDeleteModal(false);
  };

  return (
    <Grid container rowSpacing={4.5} columnSpacing={2.75}>
      <Grid item xs={12} md={12} lg={12}>
        <Grid container alignItems="center" justifyContent="space-between">
          <Grid item>
            <Typography variant="h5">Customer Management</Typography>
          </Grid>
          <Grid item>
            <Box sx={{ width: '100%', ml: { xs: 0, md: 1 } }}>
              <FormControl sx={{ width: { xs: '100%', md: 224 } }}>
                <OutlinedInput
                  size="small"
                  id="header-search"
                  startAdornment={
                    <InputAdornment position="start" sx={{ mr: -0.5 }}>
                      <SearchOutlined />
                    </InputAdornment>
                  }
                  onChange={(e) => {
                    console.log('eee', e.target.value);
                    onSearchClick(e.target.value);
                  }}
                  aria-describedby="header-search-text"
                  inputProps={{
                    'aria-label': 'weight'
                  }}
                  placeholder="Search by name or mobile"
                />
              </FormControl>
            </Box>
          </Grid>
          <Grid item />
          {/* <Grid item>
            <Tooltip title="Create Driver" placement="top">
              <Button onClick={() => handleClickOpen(true)} variant="contained" color="primary" startIcon={<PlusIcon />}>
                Create Driver
              </Button>
            </Tooltip>
          </Grid> */}
        </Grid>
        {/* <CreateDriver handleClickOpenFlag={open} data={selectedData || 'add'} closeModal={(e) => closeModal(e)} /> */}
        <DeleteModal
          handleClickOpenDeleteFlag={showDeleteModal}
          doDelete={(e) => doDelete(e)}
          data={selectedData}
          closeDeleteModal={(e) => closeDeleteModal(e)}
          heading={'Are you sure do you want to delete ?'}
        />
        <ViewCustomer handleClickOpenViewFlag={showViewModal} data={selectedData} closeViewModal={(e) => closeViewModal(e)} />

        <MainCard sx={{ mt: 2 }} content={false}>
          <div>
            <Box sx={{ height: 400, width: '100%' }}>
              <DataGrid
                sx={{
                  '.MuiDataGrid-columnHeaders': {
                    backgroundColor: '#1677ff',
                    opacity: '.75'
                  },
                  '.MuiDataGrid-columnHeaderTitle': {
                    color: 'white',
                    fontSize: '14px'
                  },
                  '.MuiTablePagination-selectLabel': {
                    marginTop: '12px'
                  },
                  '.MuiTablePagination-displayedRows': {
                    marginTop: '12px'
                  },
                  '.MuiDataGrid-row.Mui-odd': {
                    backgroundColor: '#a5e5a54d'
                  },
                  '.MuiDataGrid-sortIcon': {
                    color: 'white'
                  }
                }}
                rows={searchTerm.length > 0 ? searchResults : list}
                columns={columns}
                checkboxSelection={false}
                pageSizeOptions={[10, 50, 100]}
                initialState={{
                  pagination: { paginationModel: { pageSize: 10 } }
                }}
                disableRowSelectionOnClick
                getRowClassName={(params) => (params.indexRelativeToCurrentPage % 2 === 0 ? 'Mui-even' : 'Mui-odd')}
              />
            </Box>
          </div>
        </MainCard>
      </Grid>
    </Grid>
  );
};

export default Customer;
