import * as React from 'react';
import { Button, Box } from '@mui/material';
import { DataGrid } from '@mui/x-data-grid';
import ModeEditIcon from '@mui/icons-material/ModeEdit';
import DeleteIcon from '@mui/icons-material/Delete';

const columns = [
  { field: 'id', headerName: 'ID', width: 90 },
  {
    field: 'firstName',
    headerName: 'First name',
    width: 150,
    editable: true
  },
  {
    field: 'lastName',
    headerName: 'Last name',
    width: 150,
    editable: true
  },
  {
    field: 'age',
    headerName: 'Age',
    type: 'number',
    width: 110,
    editable: true
  },
  {
    field: 'fullName',
    headerName: 'Full name',
    description: 'This column has a value getter and is not sortable.',
    sortable: false,
    renderCell: (params) => (
      <div className="mx-auto text-center py-1">
        {params?.row?.firstName || ''} {params?.row?.lastName || ''}
      </div>
    )
  },
  {
    field: 'actions',
    headerName: 'Actions',
    // width: 400,
    renderCell: (params) => {
      return (
        <>
          <ModeEditIcon color="primary" onClick={(e) => onModeEditIconClick(e, params.row)}>
            Edit
          </ModeEditIcon>{' '}
          <DeleteIcon color="primary" onClick={(e) => onDeleteIconClick(e, params.row)}>
            Delete
          </DeleteIcon>{' '}
        </>
      );
    }
  }
];

const rows = [
  { id: 1, lastName: 'Snow', firstName: 'Jon', age: 14 },
  { id: 2, lastName: 'Lannister', firstName: 'Cersei', age: 31 },
  { id: 3, lastName: 'Lannister', firstName: 'Jaime', age: 31 },
  { id: 4, lastName: 'Stark', firstName: 'Arya', age: 11 },
  { id: 5, lastName: 'Targaryen', firstName: 'Daenerys', age: null },
  { id: 6, lastName: 'Melisandre', firstName: null, age: 150 },
  { id: 7, lastName: 'Clifford', firstName: 'Ferrara', age: 44 },
  { id: 8, lastName: 'Frances', firstName: 'Rossini', age: 36 },
  { id: 9, lastName: 'Roxie', firstName: 'Harvey', age: 65 }
];

export default function DataGridDemo() {
  return (
    <Box sx={{ height: 400, width: '100%' }}>
      <DataGrid
        sx={{
          '.MuiDataGrid-columnHeaders': {
            backgroundColor: '#1677ff',
            opacity: '.75'
          },
          '.MuiDataGrid-columnHeaderTitle': {
            color: 'white'
          },
          '.MuiTablePagination-selectLabel': {
            marginTop: '12px'
          },
          '.MuiTablePagination-displayedRows': {
            marginTop: '12px'
          },
          '.MuiDataGrid-row.Mui-odd': {
            backgroundColor: '#a5e5a54d'
          },
          '.MuiDataGrid-sortIcon': {
            color: 'white'
          }
        }}
        rows={rows}
        columns={columns}
        initialState={{
          pagination: {
            paginationModel: {
              pageSize: 5
            }
          }
        }}
        checkboxSelection={false}
        pageSizeOptions={[5]}
        disableRowSelectionOnClick
        getRowClassName={(params) => (params.indexRelativeToCurrentPage % 2 === 0 ? 'Mui-even' : 'Mui-odd')}
      />
    </Box>
  );
}
