import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';

import {
  Button,
  Grid,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton
} from '@mui/material';
import EditOutlinedIcon from '@mui/icons-material/EditOutlined';
import Alert from '@mui/material/Alert';
import { WarningOutlined } from '@mui/icons-material';

import CloseIcon from '@mui/icons-material/Close';
import MainCard from 'components/MainCard';

const EditModal = (props) => {
  const [open, setOpen] = useState(props.handleClickOpenEditFlag);
  const [scroll, setScroll] = useState('paper');

  const handleClose = () => {
    props.closeEditModal(false);
  };
  const doEdit = () => {
    props.doEdit(true);
  };

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenEditFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenEditFlag);
  }, [props.handleClickOpenEditFlag]);

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <DialogTitle id="scroll-dialog-title">
          <Grid container justifyContent="space-between" alignItems="center">
            <Grid item>
              <Typography variant="h5">Confirm Edit</Typography>
            </Grid>
            <Grid item>
              <Tooltip title="Close" placement="top">
                <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                  <CloseIcon />
                </IconButton>
              </Tooltip>
            </Grid>
          </Grid>
        </DialogTitle>
        <DialogContent dividers={scroll === 'paper'}>
          <MainCard
            sx={{
              padding: 2
            }}
            content={false}
          >
            <Grid container spacing={2} alignItems="center">
              <Grid style={{ alignItems: 'center', paddingLeft: '45%' }} item xs={12}>
                <EditOutlinedIcon
                  sx={{
                    transform: 'scale(1.85)'
                  }}
                  fontSize="large"
                  style={{ color: '#1677FF' }}
                />
              </Grid>
              <Grid item xs={12}>
                <Typography variant="h5">{props?.heading || 'Are you sure do you want to edit?'}</Typography>
              </Grid>
            </Grid>
          </MainCard>
        </DialogContent>
        <DialogActions>
          <Button variant="contained" color="secondary" onClick={handleClose}>
            No
          </Button>
          <Button
            sx={{
              backgroundColor: '#ff4d4f',
              color: 'white',
              border: 'none',
              borderRadius: '5px',
              cursor: 'pointer',
              transition: 'background-color 0.3s ease',
              '&:hover': {
                backgroundColor: 'red'
              }
            }}
            onClick={(e) => doEdit(e)}
          >
            Yes
          </Button>
        </DialogActions>
      </Dialog>
    </React.Fragment>
  );
};

export default EditModal;
EditModal.propTypes = {
  data: PropTypes.object.isRequired,
  closeEditModal: PropTypes.func.isRequired,
  doEdit: PropTypes.func.isRequired,
  handleClickOpenEditFlag: PropTypes.bool.isRequired,
  heading: PropTypes.string.isRequired
};
