import React, { useState, useEffect } from 'react';
import PropTypes from 'prop-types';

import {
  Button,
  Grid,
  Typography,
  Tooltip,
  Dialog,
  DialogActions,
  DialogContent,
  DialogContentText,
  DialogTitle,
  IconButton
} from '@mui/material';
import { WarningOutlined } from '@mui/icons-material';

import CloseIcon from '@mui/icons-material/Close';
import { PlusIcon } from 'utils/icons';
import MainCard from 'components/MainCard';

const DeleteModal = (props) => {
  const [open, setOpen] = useState(props.handleClickOpenDeleteFlag);
  const [scroll, setScroll] = useState('paper');

  const handleClose = () => {
    props.closeDeleteModal(false);
  };
  const doDelete = () => {
    props.doDelete(true);
  };

  const descriptionElementRef = React.useRef(null);
  useEffect(() => {
    if (props.handleClickOpenDeleteFlag) {
      const { current: descriptionElement } = descriptionElementRef;
      if (descriptionElement !== null) {
        descriptionElement.focus();
      }
    }
    setOpen(props.handleClickOpenDeleteFlag);
  }, [props.handleClickOpenDeleteFlag]);
  const buttonStyle = {
    backgroundColor: 'blue',
    color: 'white',
    padding: '10px 20px',
    border: 'none',
    borderRadius: '5px',
    cursor: 'pointer',
    transition: 'background-color 0.3s ease',
    // Define hover color
    '&:hover': {
      backgroundColor: 'red'
    }
  };

  return (
    <React.Fragment>
      <Dialog
        open={open}
        onClose={handleClose}
        scroll={scroll}
        aria-labelledby="scroll-dialog-title"
        aria-describedby="scroll-dialog-description"
      >
        <DialogTitle id="scroll-dialog-title">
          <Grid container justifyContent="space-between" alignItems="center">
            <Grid item>
              <Typography variant="h5">Confirm Deletion</Typography>
            </Grid>
            <Grid item>
              <Tooltip title="Close" placement="top">
                <IconButton edge="start" color="inherit" onClick={() => handleClose(true)} aria-label="close">
                  <CloseIcon />
                </IconButton>
              </Tooltip>
            </Grid>
          </Grid>
        </DialogTitle>
        <DialogContent dividers={scroll === 'paper'}>
          <MainCard
            sx={{
              padding: 2
            }}
            content={false}
          >
            <Grid container spacing={2} alignItems="center">
              <Grid style={{ alignItems: 'center', paddingLeft: '45%' }} item xs={12}>
                <WarningOutlined
                  sx={{
                    transform: 'scale(1.85)'
                  }}
                  fontSize="large"
                  color="error"
                />
              </Grid>
              <Grid item xs={12}>
                <Typography variant="h5">{props?.heading || 'Are you sure do you want to delete?'}</Typography>
              </Grid>
            </Grid>
          </MainCard>
        </DialogContent>
        <DialogActions>
          <Button variant="contained" color="secondary" onClick={handleClose}>
            No
          </Button>
          <Button
            sx={{
              backgroundColor: '#ff4d4f',
              color: 'white',
              // padding: '10px 20px',
              border: 'none',
              borderRadius: '5px',
              cursor: 'pointer',
              transition: 'background-color 0.3s ease',
              '&:hover': {
                backgroundColor: 'red'
              }
            }}
            onClick={(e) => doDelete(e)}
          >
            Yes
          </Button>
        </DialogActions>
      </Dialog>
    </React.Fragment>
  );
};

export default DeleteModal;
DeleteModal.propTypes = {
  data: PropTypes.object.isRequired,
  closeDeleteModal: PropTypes.func.isRequired,
  doDelete: PropTypes.func.isRequired,
  handleClickOpenDeleteFlag: PropTypes.bool.isRequired,
  heading: PropTypes.string.isRequired
};
