import axios from 'axios';
import config from '../config/index';

const vehicleTypeClient = axios.create({
  baseURL: config.apiHost,
  timeout: config.timeout,
  //  withCredentials: true,
  // credentials: "include",
  headers: {
    // Accept: 'application/json; charset=utf-8',
    // 'Access-Control-Allow-Origin': '*',
    // 'Access-Control-Allow-Credentials': 'true',
    'Content-Type': 'application/json',
    Authorization: 'Bearer ' + localStorage.getItem('jwt')
  }
});
vehicleTypeClient.interceptors.response.use(
  function (response) {
    return response;
  }
  // function (error) {
  //   if (error.response.status === 401 && error.response.data.code === 10005) {
  //     localStorage.removeItem('jwt');
  //     localStorage.removeItem('user');
  //     // location.reload();
  //   }
  //   return error;
  // }
);
export async function addVehicleType(data) {
  let result = await vehicleTypeClient
    .post('/vehiclehub/vehicle-types/add/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err;
    });
  return result;
}
export async function updateVehicleType(id, data) {
  let result = await vehicleTypeClient
    .patch(`/vehiclehub/vehicle-types/${id}/`, data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err;
    });
  return result;
}

export async function listVehiclesType(data) {
  let result = await vehicleTypeClient
    .get('/vehiclehub/vehicle-types/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err;
    });
  return result;
}
export async function deleteVehicleType(id) {
  let result = await vehicleTypeClient
    .delete(`/vehiclehub/vehicle-types/${id}/`)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err;
    });
  return result;
}
