import axios from 'axios';
import config from '../config/index';

const vehicleClient = axios.create({
  baseURL: config.apiHost,
  timeout: config.timeout,
  //  withCredentials: true,
  // credentials: "include",
  headers: {
    // Accept: 'application/json; charset=utf-8',
    // 'Access-Control-Allow-Origin': '*',
    // 'Access-Control-Allow-Credentials': 'true',
    'Content-Type': 'application/json',
    Authorization: 'Bearer ' + localStorage.getItem('jwt')
  }
});
vehicleClient.interceptors.response.use(
  function (response) {
    return response;
  }
  // function (error) {
  //   if (error.response.status === 401 && error.response.data.code === 10005) {
  //     localStorage.removeItem('jwt');
  //     localStorage.removeItem('user');
  //     // location.reload();
  //   }
  //   return error;
  // }
);
export async function addVehicle(data) {
  let result = await vehicleClient
    .post('/vehiclehub/vehicles/add/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
export async function updateVehicle(id, data) {
  let result = await vehicleClient
    .patch(`/vehiclehub/vehicles/${id}/`, data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}

export async function listVehicles(data) {
  let result = await vehicleClient
    .get('/vehiclehub/vehicles/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
export async function deleteVehicle(id) {
  let result = await vehicleClient
    .delete(`/vehiclehub/vehicles/${id}/`)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
