import axios from 'axios';
import config from '../config/index';

const loginClient = axios.create({
  baseURL: config.apiHost,
  timeout: config.timeout,
  //  withCredentials: true,
  // credentials: "include",
  headers: {
    // Accept: 'application/json; charset=utf-8',
    // 'Access-Control-Allow-Origin': '*',
    // 'Access-Control-Allow-Credentials': 'true'
    'Content-Type': 'application/json'

    //'Authorization': 'token <your-token-here> -- https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token'
  }
});
loginClient.interceptors.response.use(
  function (response) {
    return response;
  },
  function (error) {
    if (error.response.status === 401 && error.response.data.code === 10005) {
      localStorage.removeItem('jwt');
      localStorage.removeItem('user');
      // location.reload();
    }
    return error;
  }
);
export async function loginUser(data) {
  let result = await loginClient
    .post('/accounts/admin-login/', data)
    .then((res) => {
      if (res?.data?.token) {
        localStorage.setItem('jwt', res?.data?.token);
      }

      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}

export async function logoutUser(id) {
  let result = await loginClient
    .post(
      '/nricompe/api/v1/users/logout/',
      { user_id: id },
      {
        headers: { Authorization: 'Bearer ' + localStorage.getItem('jwt') }
      }
    )
    .then((res) => {
      localStorage.removeItem('jwt');
      localStorage.removeItem('user');
      return res?.data || res?.response?.data;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
