import axios from 'axios';
import config from '../config/index';

const LocationClient = axios.create({
  baseURL: config.apiHost,
  timeout: config.timeout,
  headers: {
    'Content-Type': 'application/json',
    Authorization: 'Bearer ' + localStorage.getItem('jwt')
  }
});
LocationClient.interceptors.response.use(
  function (response) {
    return response;
  }
  // function (error) {
  //   if (error.response.status === 401 && error.response.data.code === 10005) {
  //     localStorage.removeItem('jwt');
  //     localStorage.removeItem('user');
  //     // location.reload();
  //   }
  //   return error;
  // }
);
export async function addLocation(data) {
  let result = await LocationClient.post('/booking/locations/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
export async function updateLocation(id, data) {
  let result = await LocationClient.patch(`/booking/locations/${id}/`, data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}

export async function listLocation(data) {
  let result = await LocationClient.get('/booking/locations', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
export async function deleteLocation(id) {
  let result = await LocationClient.delete(`/booking/locations/${id}/`)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
