import axios from 'axios';
import config from '../config/index';

const driverClient = axios.create({
  baseURL: config.apiHost,
  timeout: config.timeout,
  headers: {
    'Content-Type': 'application/json',
    Authorization: 'Bearer ' + localStorage.getItem('jwt')
  }
});
driverClient.interceptors.response.use(
  function (response) {
    return response;
  }
  // function (error) {
  //   if (error.response.status === 401 && error.response.data.code === 10005) {
  //     localStorage.removeItem('jwt');
  //     localStorage.removeItem('user');
  //     // location.reload();
  //   }
  //   return error;
  // }
);
export async function addDriver(data) {
  let result = await driverClient
    .post('accounts/create-driver/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
export async function updateDriver(id, data) {
  let result = await driverClient
    .patch(`/accounts/update-driver/${id}/`, data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}

export async function listDrivers(data) {
  let result = await driverClient
    .post('/accounts/users/', data)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
export async function deleteDriver(id) {
  let result = await driverClient
    .delete(`/accounts/delete-driver/${id}/`)
    .then((res) => {
      return res;
    })
    .catch((err) => {
      return err?.response?.data;
    });
  return result;
}
