<?php $__env->startSection('title','edit Course'); ?>

<?php $__env->startSection('content'); ?>

    <div class="container-fluid">
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Edit <?php echo e($course->training_name); ?></h1>
            <a href="<?php echo e(route('courseList')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Course List</a>
        </div>
        <div class="row">
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <div class="card-body">
                    <?php if(count($errors) > 0): ?>
                            <div class = "alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <!-- <form id="update_course_details" method="post" action="<?php echo e(route('updateCourseDetails',['course'=>base64_encode($course->id)])); ?>" > -->
                        <form id="update_training_details" method="post" action="<?php echo e(route('updateTrainingDetails')); ?>" >

                        <?php echo csrf_field(); ?>
                                <div class="row">
                                <!--left-->
                                        <input id="id" type="hidden" name="id" value="<?php echo e($course->id); ?>">

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">Sector<span style="color:red;">*</span></label><br>
                                                <div class="form-group">
                                                    <select id = "sectordropdown" name="SectorID" class="form-control">
                                                        <option value="">Choose Sector</option>
                                                        <?php $__currentLoopData = $Sector; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sector): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                        <?php if($sector->Sector->id==$course->sector_id): ?>
                                                            <option selected="selected" value="<?php echo e($sector->Sector->id); ?>"><?php echo e($sector->Sector->name); ?></option>
                                                        <?php else: ?>
                                                            <option  value="<?php echo e($sector->Sector->id); ?>"><?php echo e($sector->Sector->name); ?></option>
                                                        <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <span id="sector_error" style="color:red"></span>
                                                </div>                                
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <label for="">Trade Name<span style="color:red;">*</span></label><br>
                                            <div class="form-group">
                                            <input name = "CourseMasterID" id = "coursename" type="hidden" class="form-control">
                                                <select id="trainingdropdown" class="form-control" name="trainingdropdown">
                                                    <option value="">Choose Trade</option>
                                                        <?php $__currentLoopData = $CourseMaster; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($cm->id==$course->coursemaster_id): ?>
                                                                <option selected value="<?php echo e($cm->id); ?>"><?php echo e($cm->tradename); ?></option>
                                                            <?php else: ?>
                                                                <option  value="<?php echo e($cm->id); ?>"><?php echo e($cm->tradename); ?></option>
                                                            <?php endif; ?>
                                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <span id="course_error" style="color:red"></span>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <label for="">Trade Code<span style="color:red;"></span></label><br>
                                            <div class="form-group">
                                            <?php $__currentLoopData = $CourseMaster; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($cm->id==$course->coursemaster_id): ?>
                                                    <input value="<?php echo e($cm->tradecode); ?>" type="text" id="coursecode" class="form-control" name="CourseCode" readonly="readonly">
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                              
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">Training Programme Name<span style="color:red">*</span></label>
                                                <input id="training_name" type="text" class="form-control" name="TrainingName"
                                                placeholder="Training Programme Name" value="<?php echo e($course->training_name); ?>">
                                                <span id="training_name_error" style="color:red;"></span>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">Training Programme Description<span style="color:red">*</span></label>
                                                <input id="description" type="text" class="form-control" maxlength="150" name="Description"
                                                placeholder="Description" value="<?php echo e($course->description); ?>">
                                                <span id="description_error" style="color:red;"></span>
                                            </div>
                                        </div>




                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">Skills<span style="color:red;">*</span></label><br>
                                                <div class="form-group">
                                                    <select name="Skill[]" id="skill" class="chosen-select" multiple >
                                                        <?php $__currentLoopData = $Skill; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option  value="<?php echo e($skill->id); ?>" 
                                                                <?php $__currentLoopData = $course->SkillList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course_skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if($course_skill->skill_id==$skill->id): ?>
                                                                        selected="selected"
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            />
                                                            <?php echo e($skill->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <span id="skill_error" style="color:red"></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6" type="hidden" hidden>
                                            <div class="form-group">
                                                <label for="">Agency Name<span style="color:red">*</span></label>
                                                <input id="PIA" type="text" class="form-control" name="PiaID" value="<?php echo e(auth()->user()->Piaid->id); ?>">
                                            </div>
                                        </div>


                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">District<span style="color:red;">*</span></label><br>
                                                    <div class="form-group">
                                                        <select id = "districtdropdown" name="DistrictID" class="form-control">
                                                            <option value="">Choose District</option>
                                                            <?php $__currentLoopData = $District; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                            <?php if($district->id==$course->district_id): ?>
                                                                <option selected="selected" value="<?php echo e($district->id); ?>"><?php echo e($district->name); ?></option>
                                                            <?php else: ?>
                                                                <option  value="<?php echo e($district->id); ?>"><?php echo e($district->name); ?></option>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <span id="district_error" style="color:red"></span>
                                                    </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">Local Body<span style="color:red;">*</span></label><br>
                                                    <div class="form-group">
                                                    <input name = "LocalBodyID" id = "localbodydropdown" type="hidden" class="form-control">
                                                        <select id="lbdropdown" name="LocalBodyID" class="form-control">
                                                            <option value="">Choose Local Body</option>
                                                            <?php $__currentLoopData = $LocalBody; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                            <?php if($lb->id==$course->localbody_id): ?>
                                                                <option selected="selected" value="<?php echo e($lb->id); ?>"><?php echo e($lb->name_eng); ?></option>
                                                            <?php else: ?>
                                                                <option  value="<?php echo e($lb->id); ?>"><?php echo e($lb->name_eng); ?></option>
                                                            <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                        <span id="local_body_error" style="color:red"></span>
                                                    </div>
                                 
                                            </div>
                                        </div>

                                    <!--left-->

                                    <!--right-->

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Venue<span style="color:red">*</span></label>
                                            <input id="venue" type="text" class="form-control" maxlength="100" name="Venue"
                                            value="<?php echo e($course->venue); ?>">
                                            <span id="venue_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Start Date<span style="color:red">*</span></label>
                                            <input id="start_date_edit" type="date" class="form-control" name="start_date"
                                             value="<?php echo e($course->start_date); ?>" onchange="validateDates()">
                                             <span id="start_date_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">End Date<span style="color:red">*</span></label>
                                            <input id="end_date_edit" type="date" class="form-control" name="end_date"
                                             value="<?php echo e($course->end_date); ?>" onchange="validateDates()">
                                             <span id="end_date_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Duration<span style="color:red">*</span></label>
                                            <input id="duration" type="text" class="form-control" maxlength="15" name="Duration"
                                             value="<?php echo e($course->duration); ?>">
                                             <span id="duration_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">General Seats<span style="color:red">*</span></label>
                                            <input id = "gen_seats" type="text" class="seats form-control" name="GeneralSeats"
                                            value="<?php echo e($course->general_seats); ?>" maxlength="5" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                            <span id="gen_seats_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">SC/ST Seats<span style="color:red">*</span></label>
                                            <input id = "sc_seats" type="text" class="seats form-control" name="SCSTSeats"
                                            value="<?php echo e($course->scst_seats); ?>" maxlength="5" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                            <span id="sc_seats_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Minority Seats<span style="color:red">*</span></label>
                                            <input id = "min_seats" type="text" class="seats form-control" name="MinoritySeats"
                                            value="<?php echo e($course->minority_seats); ?>" maxlength="5" oninput="this.value = this.value.replace(/[^0-9]/g, '');">
                                            <span id="min_seats_error" style="color:red;"></span>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Total Number of seats<span style="color:red">*(Total of the above mentioned seats)</span></label>
                                            <input id = "total" type="text" class="form-control" name="TotSeats" readonly="readonly"
                                            value="<?php echo e($course->no_of_seats); ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Remarks</label>
                                            <input type="text" class="form-control" maxlength="150" name="Remarks"
                                             value="<?php echo e($course->Remarks); ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Potential Employers</label>
                                            <input type="text" class="form-control" maxlength="150" name="FuturePossibilities"
                                             value="<?php echo e($course->future_possibilities); ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="">Training Programme Status<span style="color:red;">*</span></label><br>
                                            <div class="form-group">
                                                <select id="tpstatusdropdown" name="TPStatus" class="form-control">
                                                    <option value="">Choose Training Programme Status</option>
                                                    <option value = "1" <?php echo e($course->course_status == 1 ? 'selected':''); ?>>Active(In Progress)</option>
                                                    <option value = "3" <?php echo e($course->course_status == 3 ? 'selected':''); ?>>Completed</option>
                                                    <option value = "23" <?php echo e($course->course_status == 23 ? 'selected':''); ?>>Featured</option>
                                                    <option value = "9" <?php echo e($course->course_status == 9 ? 'selected':''); ?>>Cancelled</option>
                                                    <option value = "10" <?php echo e($course->course_status == 10 ? 'selected':''); ?>>Postponed</option>
                                                </select>
                                                <span id="tp_status_error" style="color:red;"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            <div class="row">
                                <div class="col-12 text-right">
                                    <hr>
                                    <div id="plwait" style="display:none" class="alert alert-info">Please wait.Process in progress.......
                                    </div>
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="reset" class="btn btn-default"><a href="<?php echo e(route('courseList')); ?>">Cancel</a></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script src="<?php echo e(asset('admin/global_assets/js/plugins/tables/datatables/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/global_assets/js/demo_pages/datatables_advanced.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.4.2/chosen.jquery.min.js"></script>

    <script>
        $('#start_date').datetimepicker({
            format: 'YYYY-MM-DD',
            useCurrent: false
        })

        $('#end_date').datetimepicker({
            format: 'YYYY-MM-DD',
            useCurrent: false
        })
    </script>


<?php $__env->stopSection(); ?>



<?php echo $__env->make('pia.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Kudumbashree_TrainingCourses/resources/views/admin/courses/edit.blade.php ENDPATH**/ ?>