<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo e(asset('img/favicon.png')); ?>" />
   
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v6.0.0-beta3/css/all.css">
    <link href="<?php echo e(asset('public_site/css/custom-kud-training.css')); ?>" rel="stylesheet">
    <!-- Include SweetAlert2 CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<!-- Include SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <title>Kudumbashree Training</title>
</head>

<body>

    <div class="container-fluid">

        <!--header nav-->
        
        <?php echo $__env->yieldContent('header'); ?>
    
        <!--header nav-->

      

        <!--content part-->
        <div class="container">
        <?php echo $__env->yieldContent('content'); ?>
       </div>
        
        <!--content part-->
        

    </div>
    <!--Bootstrap Bundle with Popper -->
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
 
    
    <script>
        $(document).ready(function() {
            // On page load, check the initial selected value
    
    // Get the current date
    var currentDate = new Date();

    // Calculate the date 18 years ago
    var eighteenYearsAgo = new Date(currentDate.getFullYear() - 18, currentDate.getMonth(), currentDate.getDate());

    // Format the date to YYYY-MM-DD (required by the date input type)
    var formattedDate = eighteenYearsAgo.toISOString().split('T')[0];

    // Set the default value of the input element
    document.getElementById('dob').value = formattedDate;
    document.getElementById('dob').max = formattedDate;
  
            
            toggleDivVisibility();

            // When the dropdown value changes
            $('#block_id').change(function(){
                LBTID=$('#lbt').val();
                DistrictID=$('#district').val();
                blockID=$('#blocl_list').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-localbodywithBlock/" + DistrictID+ "?LBT=" + LBTID+"?blockID="+blockID,
                        data: { DistrictID: DistrictID ,LBTID: LBTID,blockID:blockID }, // Pass data as an object
                        success: function (data) {
                            //console.log(data);
                            //Clear and populate options in the block_list element
                            $('#localbody').html('<option value="0">Choose Block</option>');
                            $.each(data.data, function (index, value) {
                                $('#localbody').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });
            });
            $('#lbt').change(function() {
                toggleDivVisibility();

                LBTID=$('#lbt').val();
                DistrictID=$('#district').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-localbody/" + DistrictID+ "?LBT=" + LBTID,
                        data: { DistrictID: DistrictID ,LBTID: LBTID }, // Pass data as an object
                        success: function (data) {
                            //console.log(data);
                            //Clear and populate options in the block_list element
                            $('#localbody').html('<option value="0">Choose Local Body</option>');
                            $.each(data.data, function (index, value) {
                                $('#localbody').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });
                
            });

            function toggleDivVisibility() {
                var selectedValue = $('#lbt').val();

                // Show or hide the div based on the selected value
                if (selectedValue === '1') {
                    $('#block_div').show();

                    DistrictID=$('#district').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-blocks/" + DistrictID,
                        data: { DistrictID: DistrictID }, // Pass data as an object
                        success: function (data) {
                            // Clear and populate options in the block_list element
                            $('#block_list').html('<option value="0">Choose Block</option>');
                            $.each(data.data, function (index, value) {
                                $('#block_list').append('<option value="' + value.id + '">' + value.name + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });
                  
                } else {
                    $('#block_div').hide();
                }
            }
        });
        
    </script>


<script>
    function calculateMaxYear() {
        var currentDate = new Date();
        var defaultMaxYear = currentDate.getFullYear() - 35;
        
        var genderElements = document.getElementsByName('gender');
        var selectedGender;

        for (var i = 0; i < genderElements.length; i++) {
            if (genderElements[i].checked) {
                selectedGender = genderElements[i].value;
                break;
            }
        }

        var maxYear;

        if (selectedGender === 'male') {
            maxYear = currentDate.getFullYear() - 35;
        } else if (selectedGender === 'female' || selectedGender === 'transgender') {
            maxYear = currentDate.getFullYear() - 45;
        } else {
            maxYear = defaultMaxYear;
        }

        return maxYear;
    }

    document.getElementById('dob').addEventListener('change', function() {
        var validationMessagedob = document.getElementById('dobValidationMessage');
        var maxYear = calculateMaxYear();
        var dobYear = new Date(this.value).getFullYear();

        if (dobYear < maxYear) {
            this.setCustomValidity('Maximum age limit exceeded for the selected gender.');
            validationMessagedob.textContent = 'Maximum age limit exceeded for the selected gender';
            validationMessagedob.style.color = 'red';
        } else {
            this.setCustomValidity('');
            validationMessagedob.textContent = 'DOB matched';
            validationMessagedob.style.color = 'green';
        }
    });

    var genderRadios = document.getElementsByName('gender');
    for (var i = 0; i < genderRadios.length; i++) {
        genderRadios[i].addEventListener('change', function() {
            var maxYear = calculateMaxYear();
            var dobYear = new Date(document.getElementById('dob').value).getFullYear();
            var validationMessagedob = document.getElementById('dobValidationMessage');

            if (dobYear < maxYear) {
            this.setCustomValidity('Maximum age limit exceeded for the selected gender.');
            validationMessagedob.textContent = 'Maximum age limit exceeded for the selected gender';
            validationMessagedob.style.color = 'red';
        } else {
            this.setCustomValidity('');
            validationMessagedob.textContent = 'DOB matched';
            validationMessagedob.style.color = 'green';
        }
        });
    }
</script>
<script>
        function validateMobileNumber() {
            var mobileNumber = document.getElementById('mobileNumber').value;

            // Define a regular expression for a typical international mobile number format
            //var mobileNumberPattern = /^[+]?[0-9]{1,4}[-\s]?[0-9]{6,}$/;
            var mobileNumberPattern = /^[0-9]{10}$/;
            var mobvalidationMessage = document.getElementById('mobValidationMessage');

           

            if (mobileNumberPattern.test(mobileNumber)) {
                mobvalidationMessage.textContent = 'Mobile number is valid!';
                mobvalidationMessage.style.color = 'green';
            } else {
                mobvalidationMessage.textContent = 'Invalid mobile number!';
                mobvalidationMessage.style.color = 'red';
            }
        }
    </script>
    <script>
        function liveValidateEmail() {
            var emailInput = document.getElementById('email');
            var email = emailInput.value;

            // Use a regular expression for basic email validation
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            var validationMessage = document.getElementById('emailValidationMessage');

            if (emailPattern.test(email)) {
                validationMessage.textContent = 'Email is valid';
                validationMessage.style.color = 'green';
            } else {
                validationMessage.textContent = 'Invalid email address';
                validationMessage.style.color = 'red';
            }
        }
    </script>


<script>
        $(document).ready(function () {
            // Fade out the error message div after 5 seconds (5000 milliseconds)
            setTimeout(function () {
                $('#errorMessage').fadeOut('slow');
                $('#errorMessage1').fadeOut('slow');
            }, 10000);
        });
    </script>
<script>
        $(document).ready(function() {
       // Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }

        $('#submitBtn').click(function(event) {
           // Swal.fire('Form submitted!');
           var candidatename = $("#candidatename").val();
var Gender =$("input[name='gender']:checked").val();
var dobYear = $("#dob").val();
var maxYear = calculateMaxYear();
var category = $("#category").val();
var email = $("#email").val();
var mobileNumber = $("#mobileNumber").val();
var BuildingName = $("#BuildingName").val();
var Landmark = $("#Landmark").val();
var PostOffice = $("#PostOffice").val();
var PIN_Code = $("#PIN_Code").val();
var district = $("#district").val();
var pwd = $("input[name='pwd']:checked").val();
var rationCard = $("input[name='rationCard']:checked").val();
var mgnrega = $("input[name='mgnrega']:checked").val();
var kudMember = $("input[name='kudMember']:checked").val();
var JoiTocourse = $("input[name='JoiTocourse']:checked").val();
if (!candidatename||!Gender||!dobYear||!category||!email||!mobileNumber||!BuildingName||!Landmark||!PostOffice||!PIN_Code||!district||!pwd||!rationCard||!mgnrega||!kudMember||!JoiTocourse)
{
                $("input[name='candidatename']").addClass("error");
                $("input[name='mobileNumber']").addClass("error");
                $("input[name='dob']").addClass("error");
                $("input[name='gender']").addClass("error");
                $("#district").addClass("error");
                $("input[name='pwd']").addClass("error");
                $("input[name='rationCard']").addClass("error");
                $("input[name='kudMember']").addClass("error");
                $("input[name='JoiTocourse']").addClass("error");
                $("input[name='mgnrega']").addClass("error");
                $("input[name='BuildingName']").addClass("error");
                $("input[name='Landmark']").addClass("error");
                $("input[name='PostOffice']").addClass("error");
                $("input[name='PIN_Code']").addClass("error");
                $("#category").addClass("error");
                $("#hQualification").addClass("error");
                $("input[name='email']").addClass("error");
                
                Swal.fire("Please fill in all required fields in the Personal Details tab.");
                return false;
            }

            if (dobYear < maxYear) {
                $("input[name='dob']").addClass("error");
                displayValidationError('Maximum age limit exceeded for the selected gender.');
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            $("input[name='dob']").removeClass("error");
            $("input[name='gender']").removeClass("error");
            validationMessage.hide();

            // Prevent default form submission
            event.preventDefault();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($("#myForm")[0]);
            console.log(formData);
            

            $.ajax({
                
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
    url: "<?php echo e(route('SubmitInterest')); ?>",
    type: "POST",
    data: formData,
    dataType: "json",
    processData: false,
    contentType: false,
    success: function (response) {
        if (response.status == "success") {
        //     Swal.fire("Interest Submited",response.message,"success");
        //    $("#myForm")[0].reset();
        //     $("#ajax-loader").hide();
        //     window.location.href = response.redirect;
            Swal.fire({
                        title: "Interest Submitted",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#myForm")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#myForm")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
        } else{

            var errorMessage = "Something went wrong";

            if (response && response.message) {
                errorMessage = response.message;

            }

            Swal.fire("Failed", errorMessage, "error");

            $("#ajax-loader").hide();


}
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);
        console.log(JSON.parse(xhr.responseText).message);
        Swal.fire("Error", JSON.parse(xhr.responseText).message, "error");
        $("#ajax-loader").hide();
    }



});
    });
});
    
</script>

</body>

</html>
<?php echo $__env->make('Public_site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('Public_site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Kudumbashree_TrainingCourses/resources/views/Public_site/layouts/appcontact.blade.php ENDPATH**/ ?>