    
    

<?php $__env->startSection('title','Employer List'); ?>

<?php $__env->startSection('content'); ?>


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Employer List </h1>
           
            <a href="<?php echo e(route('piaAddEmployer')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Create New</a>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                    <div style="text-align: right;">
                    <a href="<?php echo e(route('piaPendingEmployers')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Pending Employers</a>
                    <a href="<?php echo e(route('piaRejectedEmployers')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-warning shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Rejected Employers</a>
</div><br/>
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Employer Name</th>
                                        <th>District</th>
                                        <th>Contact Number</th>
                                        <th>Email Id</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                <?php $__currentLoopData = $employers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$employer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(($key+1)); ?></td>
                                        <td><?php echo e($employer->name); ?></td>
                                        <td><?php echo e($employer->District->name); ?></td>
                                        <td><?php echo e($employer->phone_number); ?></td>
                                        <td><?php echo e($employer->email); ?></td>

                                        <td>
                                            <?php if($employer->status==11): ?>

                                              <div class="alert alert-danger">Waiting for Approval</div>

                                            <?php else: ?>

                                               <?php if($employer->status==1): ?>

                                                    <?php if($employer->approval_status==11): ?>

                                                        <div class="alert alert-warning">Approval Pending</div>

                                                    <?php elseif($employer->approval_status==1): ?>

                                                    <div class="alert alert-success">Active</div>


                                                    <?php endif; ?>

                                               <?php endif; ?>


                                            <?php endif; ?>
                                        </td>
                                        
                                        <td>

                                            <a href="<?php echo e(route('piaViewEmployer',['id'=>base64_encode($employer->id)])); ?>" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                            <?php if(auth()->user()->user_role_id==1): ?>

                                                <?php if($employer->approval_status==1): ?>
                                            
                                                <a href="<?php echo e(route('adminEditEmployer',['id'=>base64_encode($employer->id)])); ?>" class="btn btn-success btn-circle btn-sm" title="Edit">
                                                    <i class="fas fa-pen"></i>
                                                </a>

                                                <?php else: ?>

                                                <a href="#" class="btn btn-success btn-circle btn-sm approve-employer" data-employer="<?php echo e(base64_encode($employer->id)); ?>" title="Approve">
                                                    <i class="fas fa-check"></i>
                                                </a>

                                                


                                                <?php endif; ?>
                                            <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-employer" data-employer="<?php echo e(base64_encode($employer->id)); ?>" >
                                                <i class="fas fa-trash"></i>
                                            </a>

                                            <?php elseif(auth()->user()->user_role_id==4): ?>

                                               <?php if(auth()->user()->id==$employer->created_by): ?>

                                              <a href="<?php echo e(route('piaEditEmployer',['id'=>base64_encode($employer->id)])); ?>" class="btn btn-success btn-circle btn-sm" title="Edit">
                                                <i class="fas fa-pen"></i>
                                                </a>

                                            <!--
                                                <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-employer" data-employer="<?php echo e(base64_encode($employer->id)); ?>" >
                                                    <i class="fas fa-trash"></i>
                                                </a>-->

                                               <?php endif; ?>

                                               

                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('pia.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Kudumbashree_TrainingCourses/resources/views/pia/employers/list.blade.php ENDPATH**/ ?>