  


<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="<?php echo e(asset('img/favicon.png')); ?>" />
    <meta name="description" content="Kudumbashree">
    <meta name="author" content="Kudumbashree">
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Custom fonts for this template-->
    <link href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('vendor/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet" type="text/css">

    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Custom styles for this template-->
    <link href="<?php echo e(asset('css/kudumbashree.css')); ?>" rel="stylesheet">

    <!--<link rel="stylesheet" href="<?php echo e(asset('plugins/multiselect/dist/css/bootstrap-multiselect.css')); ?>" type="text/css"/>-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css" type="text/css"/>

    <style>
        .form-check-input {
            width: 1em;
            height: 1em;
            margin-top: 0;
            vertical-align: top;
            background-color: #fff;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            border: 1px solid rgba(0,0,0,.25);
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            -webkit-print-color-adjust: exact;
            color-adjust: exact;
            }
            .form-check-input[type=radio] {
            border-radius: 50%;
        }

        .form-check-input:checked {
            background-color:#0079F6;
            border-color:#0079F6;
            box-shadow: none;
        }

        .form-check-input:checked[type=radio] {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='2' fill='%23fff'/%3e%3c/svg%3e")
        }

    </style>


   


</head>

<body id="page-top">


    <!-- Page Wrapper -->
    <div id="wrapper">

                     <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

            <!-- Sidebar - Brand -->
            <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?php echo e(route('pia-dashboard')); ?>">
                <img src="<?php echo e(asset('img/logo.png')); ?>" title="Kudumbashree" class="img-responsive">
            </a>

            <!-- Divider -->
            <hr class="sidebar-divider my-0">

            <!-- Nav Item - Dashboard -->
            <li class="nav-item active">
                <a class="nav-link" href="<?php echo e(route('pia-dashboard')); ?>">
                <i class="fas fa-fw fa-home"></i>
                    <span>Dashboard</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('courseList')); ?>">
                <i class="fas fa-fw fa-list-alt"></i>
                    <span>Training Program</span></a>
            </li>
             <!--  <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('piaList')); ?>">
                    <i class="fas fa-fw fa-info"></i>
                    <span>Program Implementing Agencies</span></a>
            </li>-->

             <!-- Sidebar Toggler (Sidebar) -->
            <?php if(auth()->user()->user_role_id==4): ?>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('piaEmployerList')); ?>">
                <i class="fas fa-fw fa-clipboard-list"></i>
                    <span>Employer List</span></a>
            </li>

            <?php endif; ?>

          <!--  <li class="nav-item">
                <a class="nav-link" href="#">
                    <i class="fas fa-fw fa-user"></i>
                    <span>Candidates</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#">
                    <i class="fas fa-bell fa-fw"></i>
                    <span>Announcements</span></a>
            </li>-->

            <?php if(auth()->user()->user_role_id==4): ?> 

             <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('candidateInterestList')); ?>">
                <i class="fas fa-fw fa-th-list"></i>
                    <span>Course Interest Pending List</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('candidateInterestJoinedList')); ?>">
                <i class="fas fa-fw fa-house-user"></i>
                    <span>Course Joined List</span></a>
            </li> 
            <li class="nav-item">
                <a class="nav-link <?php echo e(Route::is( 'CandidateReportView_pia') ? '' : 'collapsed'); ?>" href="#" data-toggle="collapse" data-target="#collapseOne"
                    aria-expanded="<?php echo e(Route::is( 'CandidateReportView_pia') ? 'true' : 'false'); ?>" aria-controls="collapseOne">
                    <i class="fas fa-fw fa-briefcase"></i>
                    <span>Reports</span>
                </a>
                <div id="collapseOne" class="collapse <?php echo e(Route::is( 'CandidateReportView_pia') ? 'show' : ''); ?>" aria-labelledby="headingOne" data-parent="#accordionSidebar">
                    <div class="bg-white py-2 collapse-inner rounded">
                        <a class="collapse-item" href="<?php echo e(route('CandidateReport_pia')); ?>">Candidates</a>
                       
                        
                        
                       
                        
                    </div>
                </div>
            </li>

            <?php endif; ?>

           
            

            <!-- Sidebar Toggler (Sidebar) -->
            <div class="text-center d-none d-md-inline">
                <button class="rounded-circle border-0" id="sidebarToggle"></button>
            </div>

        </ul>
            <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

                       <!-- Topbar -->
                       <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

<!-- Sidebar Toggle (Topbar) -->
<button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
    <i class="fa fa-bars"></i>
</button>

<!-- Topbar Search -->
<!--<form
    class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
    <div class="input-group">
        <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..."
            aria-label="Search" aria-describedby="basic-addon2">
        <div class="input-group-append">
            <button class="btn btn-primary" type="button">
                <i class="fas fa-search fa-sm"></i>
            </button>
        </div>
    </div>
</form>-->

<!-- Topbar Navbar -->
<ul class="navbar-nav ml-auto">

    <!-- Nav Item - Search Dropdown (Visible Only XS) -->
    <li class="nav-item dropdown no-arrow d-sm-none">
        <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-search fa-fw"></i>
        </a>
        <!-- Dropdown - Messages -->
        <!--<div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
            aria-labelledby="searchDropdown">
            <form class="form-inline mr-auto w-100 navbar-search">
                <div class="input-group">
                    <input type="text" class="form-control bg-light border-0 small"
                        placeholder="Search for..." aria-label="Search"
                        aria-describedby="basic-addon2">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="button">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>-->
    </li>

    <!-- Nav Item - Alerts -->
    <!--<li class="nav-item dropdown no-arrow mx-1">
        <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-bell fa-fw"></i>
           
            <span class="badge badge-primary badge-counter">3+</span>
        </a>
       
        <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
            aria-labelledby="alertsDropdown">
            <h6 class="dropdown-header">
                Alerts Center
            </h6>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-primary">
                        <i class="fas fa-file-alt text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 12, 2019</div>
                    <span class="font-weight-bold">A new monthly report is ready to download!</span>
                </div>
            </a>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-success">
                        <i class="fas fa-donate text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 7, 2019</div>
                    $290.29 has been deposited into your account!
                </div>
            </a>
            <a class="dropdown-item d-flex align-items-center" href="#">
                <div class="mr-3">
                    <div class="icon-circle bg-warning">
                        <i class="fas fa-exclamation-triangle text-white"></i>
                    </div>
                </div>
                <div>
                    <div class="small text-gray-500">December 2, 2019</div>
                    Spending Alert: We've noticed unusually high spending for your account.
                </div>
            </a>
            <a class="dropdown-item text-center small text-gray-500" href="#">Show All Alerts</a>
        </div>
    </li>-->
    <!--alert-->

    <div class="topbar-divider d-none d-sm-block"></div>

    <!-- Nav Item - User Information -->
    <li class="nav-item dropdown no-arrow">
        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <span class="mr-2 d-none d-lg-inline text-gray-600 small">  <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo e(auth()->user()->name); ?> (<?php if(auth()->user()->user_role_id==1): ?>
            Super admin
            <?php elseif(auth()->user()->user_role_id==2): ?>
            District admin
            <?php elseif(auth()->user()->user_role_id==3): ?>
            Block admin
            <?php elseif(auth()->user()->user_role_id==4): ?>
            PIA
            <?php elseif(auth()->user()->user_role_id==5): ?>
            Employer
            <?php elseif(auth()->user()->user_role_id==6): ?>
            Candidates
            <?php endif; ?>
            )</span></span>
            <img class="img-profile rounded-circle" src="<?php echo e(asset('img/undraw_profile.svg')); ?>">
        </a>
        <!-- Dropdown - User Information -->
        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
            aria-labelledby="userDropdown">
            <a class="dropdown-item" href="<?php echo e(route('pia-profile')); ?>">
                <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                Profile
            </a>
            <!--<a class="dropdown-item" href="#">
                <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                Settings
            </a>
            <div class="dropdown-divider"></div>-->
            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                Logout
            </a>
        </div>
    </li>

</ul>

</nav>

             <?php echo $__env->yieldContent('content'); ?>

       

          <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Kudumbashree <?php echo e(date('Y')); ?></span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal-->
    

    

    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">To continue to log out, please select the logout button.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="<?php echo e(url('/logout')); ?>">Logout</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
<script src="<?php echo e(asset('vendor/jquery/jquery.min.js')); ?>"></script>

<script src="<?php echo e(asset('js/demo/datatables-demo.js')); ?>"></script>

<script src="<?php echo e(asset('vendor/datatables/jquery.dataTables.js')); ?>"></script>

    <script>

        $(document).ready(function()
        {
            $("dataTable").DataTable();
        });
    </script>

    <script src="<?php echo e(asset('vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Core plugin JavaScript-->
    <script src="<?php echo e(asset('vendor/jquery-easing/jquery.easing.min.js')); ?>"></script>

    <!-- Custom scripts for all pages-->
    <script src="<?php echo e(asset('js/kudumbashree.js')); ?>"></script>

    <!-- Page level plugins -->
    <script src="<?php echo e(asset('vendor/chart.js/Chart.min.js')); ?>"></script>

    <!-- Page level custom scripts -->
    <script src="<?php echo e(asset('js/demo/chart-area-demo.js')); ?>"></script>
    <script src="<?php echo e(asset('js/demo/chart-pie-demo.js')); ?>"></script>

    <script src="<?php echo e(asset('js/sweetalert.js')); ?>"></script>

    <script src="<?php echo e(asset('vendor/jquery-easing/jquery.easing.min.js')); ?>"></script>

    <!--<script type="text/javascript" src="<?php echo e(asset('plugins/multiselect/dist/js/bootstrap-multiselect.js')); ?>"></script>-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script>
    <script>
        $(document).ready(function () {
            $('#skill').multiselect({
                nonSelectedText: 'Select Skill',
                enableFiltering: true,
                enableCaseInsensitiveFiltering: true,
                buttonWidth: '400px'
            });

        });
    </script>
 <!--   <script>

        $(document).ready(function()
{
            $(".multiselect").multiselect();
        });

</script>-->

    <script>


      

   
        $(document).ready(function()
        {

         $("input[name='ExtraMasterId']").removeClass("error");     
         var ExtraMasterId = $('#ExtraMasterId');
        // Attach the change event handler to the dropdown
        ExtraMasterId.change(function() {
        // This function will be executed when the dropdown value changes
        var selectedValue = ExtraMasterId.val();
        $("#trainings").html("");
            $.ajax({
                headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                url:"<?php echo e(route('loadTrainings')); ?>",
                type:"POST",
                data:{master:selectedValue},
                dataType:"JSON",
                success:function(response)
                {
                   if(response.status=="success")
                   {
                        var trainings=response.training;

                        $("#trainings").html("");

                        $("#trainings").append("<option value=''>Choose Trainings</option>");

                        trainings.forEach(function(trainings)
                        {
                            $("#trainings").append("<option value='"+trainings.id+"'>"+trainings.training_name+"</option>");
                        });
                   }
                }
            });

    });


            $(document).on("change","#course_master",function()
            {
                var course_master=$(this).val();

                
                $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadTrainings')); ?>",
                        type:"POST",
                        data:{master:course_master},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var trainings=response.training;

                                $("#trainings").html("");

                                $("#trainings").append("<option value=''>Choose Trainings</option>");

                                trainings.forEach(function(trainings)
                                {
                                    $("#trainings").append("<option value='"+trainings.id+"'>"+trainings.training_name+"</option>");
                                });
                           }
                        }
                    });


            });
            ////////////////////Training Course Selection Based on Master Course for Candidate interest status change///////////////////////////////////
            $(document).on("change", "input[type=radio][name=MasterCourse]", function () {
                // Get the selected radio button value
                var radVal = $("input[type=radio][name=MasterCourse]:checked").val();

                if(radVal!="")
                {
                    $("input[name='MasterCourse']").removeClass("error");            
            $("#MasterCourse_error").html("");

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadTrainings')); ?>",
                        type:"POST",
                        data:{master:radVal},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var trainings=response.training;

                                $("#trainings").html("");

                                $("#trainings").append("<option value=''>Choose Trainings</option>");

                                trainings.forEach(function(trainings)
                                {
                                    $("#trainings").append("<option value='"+trainings.id+"'>"+trainings.training_name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            ///////////////////////////////////////////////////////
            
            $(document).on("change","#country",function()
            {
                var country=$(this).val();
                var stateDropdown = document.getElementById('country');
                if (stateDropdown.value === '') {
                    $("#state").html("");

                    $("#state").append("<option value=''>Choose State</option>");
                    $("#district").html("");

                    $("#district").append("<option value=''>Choose District</option>");
                }

                if(country!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadStates')); ?>",
                        type:"POST",
                        data:{country:country},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var states=response.states;

                                $("#state").html("");

                                $("#state").append("<option value=''>Choose State</option>");

                                states.forEach(function(state)
                                {
                                    $("#state").append("<option value='"+state.id+"'>"+state.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });
            
            $(document).on("change","#empid",function()
            {
                var empid=$(this).val();
             
                var empidDropdown = document.getElementById('empid');
                var jobDropdown = document.getElementById('job');
                if (empidDropdown.value === '') {
                    $("#job").html("");

                    $("#job").append("<option value=''>Choose job</option>");
                }

                if(empid!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadJobs')); ?>",
                        type:"POST",
                        data:{empid:empid},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var jobs=response.jobs;

                                $("#job").html("");

                                $("#job").append("<option value=''>Choose jobs</option>");

                                jobs.forEach(function(job)
                                {
                                    $("#job").append("<option value='"+job.id+"'>"+job.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#state",function()
            {
                var state=$(this).val();
                var state=$(this).val();
                var stateDropdown = document.getElementById('state');
                var districtDropdown = document.getElementById('district');
                if (stateDropdown.value === '') {
                    $("#district").html("");

                    $("#district").append("<option value=''>Choose District</option>");
                }

                if(state!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadDistricts')); ?>",
                        type:"POST",
                        data:{state:state},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var districts=response.districts;

                                $("#district").html("");

                                $("#district").append("<option value=''>Choose District</option>");

                                districts.forEach(function(district)
                                {
                                    $("#district").append("<option value='"+district.id+"'>"+district.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("change","#district",function()
            {
                var district=$(this).val();

                if(district!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadBlocks')); ?>",
                        type:"POST",
                        data:{district:district},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {

                          
                                var blocks=response.blocks;

                                $("#block").html("");

                                $("#block").append("<option value=''>Choose Block</option>");

                                blocks.forEach(function(block)
                                {
                                    $("#block").append("<option value='"+block.id+"'>"+block.name+"</option>");
                                });
                           }
                        }
                    });

                }
            });

            $(document).on("submit","#submit_pia_details",function(e)
            {

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                form_data.append('attachment',$(this)[0].files);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                    url:"<?php echo e(route('submitPIADetails')); ?>",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("PIA added",response.message,"success");

                            $("#submit_pia_details")[0].reset();

                           
                            $("#ajax-loader").hide();
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            
            $(document).on("submit","#update_pia_details",function(e)
            {

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                form_data.append('attachment',$(this)[0].files);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                    url:"<?php echo e(route('updatePIADetails')); ?>",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire("PIA updated",response.message,"success");

                            $("#update_pia_details")[0].reset();

                            location.reload();

                           
                            $("#ajax-loader").hide();
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            $(document).on("click",".deactivate-pia",function()
            {
                var pia=$(this).data('pia-id');

                Swal.fire({
                    title: "Are you sure to deactivate agency?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                            url:"<?php echo e(route('deactivatePIA')); ?>",
                            type:"POST",
                            data:{pia:pia},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire("Decativated",response.message, "success");
                                location.reload();
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Agency is safe", "", "info");
                    }
                });
            });

            $(".seats").each(function() {

                $(this).keyup(function(){
                    calculateSum();
                });
            });

            $('#sectordropdown').change(function(){

                var idSector=$('#sectordropdown').val();
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-training/" + idSector,
                    data: { idSector: idSector },
                    success: function (data) {
                        console.log(data);                        
                        $('#trainingdropdown').html('<option value="">-- Select Trade --</option>');
                        $.each(data.data, function (index, value) {
                            $('#trainingdropdown').append('<option value="' + value.id + '">' + value.tradename + '</option>');
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });

            });
            $('#trainingdropdown').change(function () {
    let tradeId = $(this).val();  // Get selected trade ID

    if (!tradeId) {
        $('#duration').val('');  // Clear the duration field if no trade is selected
        $('#duration').parent().hide();  // Hide the parent div
        console.log("No trade selected");
        return;
    }

    console.log(`Fetching duration for trade ID: ${tradeId}`);  // Debugging message

    $.ajax({
        method: "GET",
        url: `/api/fetch-duration/${tradeId}`,  // API endpoint
        success: function (response) {
            console.log("API Response:", response);  // Log the entire response for debugging

            // Check if the response contains data and duration
            if (response.data && response.data.duration) {
                $('#duration').val(response.data.duration);  // Set the duration value
                $('#duration').parent().show();  // Show the parent div if hidden
            } else {
                console.warn("Duration not found in the response");
                $('#duration').val('');  // Clear the field if no duration is found
                $('#duration').parent().hide();  // Hide the parent div
            }
        },
        error: function (xhr, status, error) {
            console.error(`Error ${xhr.status}: ${xhr.responseText}`);
            $('#duration').val('Failed to fetch duration');  // Optional error message in field
            $('#duration').parent().show();  // Show the field for visibility of error
        }
    });
});


            $('#trainingdropdown').change(function(){

                var idTraining=$('#trainingdropdown').val();
                $("#coursename").val(idTraining);
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-training-code/" + idTraining,
                    data: { idTraining: idTraining },
                    success: function (data) {
                        console.log(data);
                        $.each(data.data, function (index, value) {
                            $('#coursecode').val(value.tradecode);
                        });
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });

            });

            $(document).on("click",".deactivate-course",function()
            {
                var course=$(this).data('course-id');

                Swal.fire({
                    title: "Are you sure to delete training programme?",
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: "Yes",
                    denyButtonText: `No`
                    }).then((result) => {
                        
                    if (result.isConfirmed) {

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                            url:"<?php echo e(route('deactivateTrainingProgramme')); ?>",
                            type:"POST",
                            data:{course:course},
                            dataType:"JSON",
                            success:function(response)
                            {
                               if(response.status=="success")
                               {
                                Swal.fire({
                        title: "The training program was removed successfully.",  
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         window.location.href = response.redirect;
                     } else {
         
                         window.location.href = response.redirect;
                     }
                    });
                               } 

                               else{

                                Swal.fire("Error",response.message, "error");
                               }
                            }
                             
                        });
                        
                    } else if (result.isDenied) {
                        Swal.fire("Training Programme is safe", "", "info");
                    }
                });
            });

            $('#districtdropdown').change(function(){

                var idDistrict=$('#districtdropdown').val();

               
                $.ajax({
                    method: "GET",
                    url: "/api/fetch-localbody/" + idDistrict,
                    data: { idDistrict: idDistrict },
                    success: function (data) {
                        console.log(data);
                        $('#lbdropdown').html('<option value="">-- Select Local Body --</option>');
                        $.each(data.data, function (index, value) {
                            $('#lbdropdown').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                        });

                        
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            });

            $('#lbdropdown').change(function(){

                var idLocalBody=$('#lbdropdown').val();
                $("#localbodydropdown").val(idLocalBody);

            });


        });

        $(document).on("submit","#submit_employer_details",function(e)
            {
                var employer_name = $("#employer_name").val();
var building_number = $("#building_number").val();
var landmark = $("#landmark").val();
var country = $("#country").val();
var state = $("#state").val();
var district = $("#district").val();
var contact_number = $("#contact_number").val();
var pan_number = $("#pan_number").val();
var post_office = $("#post_office").val();
var pincode = $("#pincode").val();
var email = $("#email").val();

if (!email||!employer_name|| !building_number||!landmark||!country ||!state||!district||!contact_number||!pan_number||!post_office||!pincode)
{
    if(!employer_name)
    {

        $("#employer_name_error").html("Please enter the Employer Name");

        $("#employer_name").addClass("error");

        $("#emailValidationMessage").hide();

    }

    else{


        $("#employer_name_error").html("");

        $("#employer_name").removeClass("error");
    }

        if(!building_number)
    {

        $("#building_number_error").html("Please enter the Building Number/Name");

        $("#building_number").addClass("error");

    }

    else{


        $("#building_number_error").html("");

        $("#building_number").removeClass("error");

    }
    if(!landmark)
    {

        $("#landmark_error").html("Please enter the Street, Landmark");

        $("#landmark").addClass("error");

    }

    else{


        $("#landmark_error").html("");

        $("#landmark").removeClass("error");

    }
    if(!country)
    {

        $("#country_error").html("Please select the country");

        $("#country").addClass("error");

    }

    else{


        $("#country_error").html("");

        $("#country").removeClass("error");

    }
    if(!state)
    {

        $("#state_error").html("Please select the state");

        $("#state").addClass("error");

    }

    else{


        $("#state_error").html("");

        $("#state").removeClass("error");

    }
    if(!district)
    {

        $("#district_error").html("Please select the District");

        $("#district").addClass("error");

    }

    else{


        $("#district_error").html("");

        $("#district").removeClass("error");

    }
    if(!contact_number)
    {

        $("#contact_number_error").html("Please enter a valid Contact Number");

        $("#contact_number").addClass("error");

    }

    else{


        $("#contact_number_error").html("");

        $("#contact_number").removeClass("error");

    }

    if(!pan_number)
    {

        $("#pan_number_error").html("Please enter a valid PAN number");

        $("#pan_number").addClass("error");

    }

    else{


        $("#pan_number_error").html("");

        $("#pan_number").removeClass("error");

    }
    if(!post_office)
    {

        $("#post_office_error").html("Please enter the Post Office Name");

        $("#post_office").addClass("error");

    }

    else{


        $("#post_office_error").html("");

        $("#post_office").removeClass("error");

    }
    if(!pincode)
    {

        $("#pincode_error").html("Please enter the Pincode");

        $("#pincode").addClass("error");

    }

    else{


        $("#pincode_error").html("");

        $("#pincode").removeClass("error");

    }

    if(!email)
    {

        $("#email_error").html("Please enter a vaild Email ID");

        $("#email").addClass("error");
        $("#emailValidationMessage").hide();

    }

    else{


        $("#email_error").html("");

        $("#email").removeClass("error");

    }

    Swal.fire("Please fill in all required fields.");
    return false;
}

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                form_data.append('attachment',$(this)[0].files);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                    url:"<?php echo e(route('adminSubmitEmployerDetails')); ?>",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire({
                        title: "The employer account was successfully created. Admin account confirmation is pending.",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_employer_details")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_employer_details")[0].reset();
                         $("#pajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

            $(document).on("submit","#update_employer_details",function(e)
            {
                var employer_name = $("#employer_name").val();
var building_number = $("#building_number").val();
var landmark = $("#landmark").val();
var country = $("#country").val();
var state = $("#state").val();
var district = $("#district").val();
var contact_number = $("#contact_number").val();
var pan_number = $("#pan_number").val();
var post_office = $("#post_office").val();
var pincode = $("#pincode").val();
var email = $("#email").val();

if (!building_number||!landmark||!country ||!state||!district||!contact_number||!post_office||!pincode)
{
    

        if(!building_number)
    {

        $("#building_number_error").html("Please enter the building number/name");

        $("#building_number").addClass("error");

    }

    else{


        $("#building_number_error").html("");

        $("#building_number").removeClass("error");

    }
    if(!landmark)
    {

        $("#landmark_error").html("Please enter the landmark");

        $("#landmark").addClass("error");

    }

    else{


        $("#landmark_error").html("");

        $("#landmark").removeClass("error");

    }
    if(!country)
    {

        $("#country_error").html("Please select the country");

        $("#country").addClass("error");

    }

    else{


        $("#country_error").html("");

        $("#country").removeClass("error");

    }
    if(!state)
    {

        $("#state_error").html("Please select the state");

        $("#state").addClass("error");

    }

    else{


        $("#state_error").html("");

        $("#state").removeClass("error");

    }
    if(!district)
    {

        $("#district_error").html("Please select the state");

        $("#district").addClass("error");

    }

    else{


        $("#district_error").html("");

        $("#district").removeClass("error");

    }
    if(!contact_number)
    {

        $("#contact_number_error").html("Please enter the contact number");

        $("#contact_number").addClass("error");

    }

    else{


        $("#contact_number_error").html("");

        $("#contact_number").removeClass("error");

    }

    
    if(!post_office)
    {

        $("#post_office_error").html("Please enter the post office name");

        $("#post_office").addClass("error");

    }

    else{


        $("#post_office_error").html("");

        $("#post_office").removeClass("error");

    }
    if(!pincode)
    {

        $("#pincode_error").html("Please enter the Pincode");

        $("#pincode").addClass("error");

    }

    else{


        $("#pincode_error").html("");

        $("#pincode").removeClass("error");

    }

    

    Swal.fire("Please fill in all required fields.");
    return false;
}

               $("#ajax-loader").show();
                e.preventDefault();

                var form_data=new FormData($(this)[0]);

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                    url:"<?php echo e(route('UpdateEmployerDetails')); ?>",
                    type:"POST",
                    data:form_data,
                    dataType:"JSON",
                    processData:false,
                    contentType:false,
                    success:function(response)
                    {
                        if(response.status=="success")
                        {
                            Swal.fire({
                        title: "Your update request forwarded to the Admin for approval",
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
                            
                        }

                        else{

                            Swal.fire("failed",response.message,"error");

                            $("#ajax-loader").hide();



                        }
                    },
                    error:function()
                    {
                        Swal.fire("wrong","something went wrong","error")
                    }
                });
                
            });

        function calculateSum() {

            var sum = 0;
            //iterate through each textboxes and add the values
            $(".seats").each(function() {
                //add only if the value is number
                if(!isNaN(this.value) && this.value.length!=0) {
                    sum += parseInt(this.value);
                }

            });
            $('#total').val(sum);
        }

    
        function CheckNoSeats(val) {
           // alert(val);
            var cid = $('#cid').val();
           // alert(cid);
            var category = $('#category').val();
           // alert(category);
            $.ajax({
                headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                url:"<?php echo e(route('CheckSeatsCount')); ?>",
                method: 'POST',
                data: { cid: cid ,course: val,category: category},
                success: function(response) {
                    if(response.error)
                     Swal.fire("wrong",response.error,"error")
                    
                }
            });
        }
    </script>



<script>


function validateMobile_Number() {
            var mobileNumber = document.getElementById('ContactNumber').value;

            // Define a regular expression for a typical international mobile number format
            //var mobileNumberPattern = /^[+]?[0-9]{1,4}[-\s]?[0-9]{6,}$/;
            var mobileNumberPattern = /^[0-9]{10}$/;
            var mobvalidationMessage = document.getElementById('mobValidationMessage');

            $("#mobile_number_error").html("");
                $("input[name='mobileNumber']").removeClass("text-error");

           

            if (mobileNumberPattern.test(mobileNumber)) {

                //var mob_no=parseInt(mobilNumber);

                    mobvalidationMessage.textContent = 'Mobile number is valid!';
                    mobvalidationMessage.style.color = 'green';

/*
                if(mob_no>1000000000)
                {

                    mobvalidationMessage.textContent = 'Mobile number is valid!';
                    mobvalidationMessage.style.color = 'green';

                }

                else{

                    mobvalidationMessage.textContent = 'Invalid mobile number!';
                    mobvalidationMessage.style.color = 'red';


                }*/
               
            } else {
                mobvalidationMessage.textContent = 'Invalid mobile number!';
                mobvalidationMessage.style.color = 'red';
            }
        }
        
function validateph_Number() {
            var mobileNumber = document.getElementById('Contact_Number').value;

            // Define a regular expression for a typical international mobile number format
            //var mobileNumberPattern = /^[+]?[0-9]{1,4}[-\s]?[0-9]{6,}$/;
            var mobileNumberPattern = /^[0-9]{12}$/;
            var mobvalidationMessage = document.getElementById('phValidationMessage');

            $("#contactno_error").html("");
                $("input[name='Contact_Number']").removeClass("text-error");

           

            if (mobileNumberPattern.test(mobileNumber)) {

                //var mob_no=parseInt(mobilNumber);

                phValidationMessage.textContent = 'Mobile number is valid!';
                phValidationMessage.style.color = 'green';

/*
                if(mob_no>1000000000)
                {

                    mobvalidationMessage.textContent = 'Mobile number is valid!';
                    mobvalidationMessage.style.color = 'green';

                }

                else{

                    mobvalidationMessage.textContent = 'Invalid mobile number!';
                    mobvalidationMessage.style.color = 'red';


                }*/
               
            } else {
                phValidationMessage.textContent = 'Invalid mobile number!';
                phValidationMessage.style.color = 'red';
            }
        }
  
        
    </script>


<script>
        
        function liveValidateEmail_exist() {
            var emailInput = document.getElementById('email');
            var email = emailInput.value;
            $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('AlreadyExistEmail')); ?>",
                        type:"POST",
                        data:{email:email},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="exists")
                           {
                                Swal.fire("Failed", response.message, "error");
                           }
                        }
                    });
            // Use a regular expression for basic email validation
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            var validationMessage = document.getElementById('emailValidationMessage');

            if (emailPattern.test(email)) {
                validationMessage.textContent = 'Email is valid';
                validationMessage.style.color = 'green';

                $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('AlreadyExistEmail')); ?>",
                        type:"POST",
                        data:{email:email},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="exists")
                           {
                                Swal.fire("Failed", response.message, "error");
                           }
                        }
                    });



            } else {
                validationMessage.textContent = 'Invalid email ID';
                validationMessage.style.color = 'red';
            }
        }

        function validateMobileNumber() {
            var mobileNumber = document.getElementById('mobileNumber').value;

            // Define a regular expression for a typical international mobile number format
            //var mobileNumberPattern = /^[+]?[0-9]{1,4}[-\s]?[0-9]{6,}$/;
            var mobileNumberPattern = /^[0-9]{10}$/;
            var mobvalidationMessage = document.getElementById('mobValidationMessage');

           

            if (mobileNumberPattern.test(mobileNumber)) {
                mobvalidationMessage.textContent = 'Mobile number is valid!';
                mobvalidationMessage.style.color = 'green';
            } else {
                mobvalidationMessage.textContent = 'Invalid mobile number!';
                mobvalidationMessage.style.color = 'red';
            }
        }
    </script>
   


<script>
        $(document).ready(function () {
            // Fade out the error message div after 5 seconds (5000 milliseconds)
            // setTimeout(function () {
            //     $('#errorMessage').fadeOut('slow');
            //     $('#errorMessage1').fadeOut('slow');
            // }, 10000);

           

            $("#skill").on("change blur", function() {
    var selectedOptions = $(this).find(":selected");

    if (selectedOptions.length > 0) {
        // Option selected
        $("#skill_error").html('');
        $(".multiselect").removeClass("error");
    } else {
        // No option selected
        $("#skill_error").html('Please select the Skill');
        $(".multiselect").addClass("error");
    }
});
        });
    </script>
<script>
        $(document).ready(function() {

            


       // Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }

        $('#submitBtn').click(function(event) {
           // Swal.fire('Form submitted!');
           var candidatename = $("#candidatename").val();
var Gender =$("input[name='gender']:checked").val();
var dobYear = $("#dob").val();
var maxYear = calculateMaxYear();
var category = $("#category").val();
var email = $("#email").val();
var mobileNumber = $("#mobileNumber").val();
var BuildingName = $("#BuildingName").val();
var Landmark = $("#Landmark").val();
var PostOffice = $("#PostOffice").val();
var PIN_Code = $("#PIN_Code").val();
var district = $("#district").val();
var pwd = $("input[name='pwd']:checked").val();
var rationCard = $("input[name='rationCard']:checked").val();
var mgnrega = $("input[name='mgnrega']:checked").val();
var kudMember = $("input[name='kudMember']:checked").val();
var JoiTocourse = $("input[name='JoiTocourse']:checked").val();
if (!candidatename||!Gender||!dobYear||!category||!email||!mobileNumber||!BuildingName||!Landmark||!PostOffice||!PIN_Code||!district||!pwd||!rationCard||!mgnrega||!kudMember||!JoiTocourse)
{
                $("input[name='candidatename']").addClass("error");
                $("input[name='mobileNumber']").addClass("error");
                $("input[name='dob']").addClass("error");
                $("input[name='gender']").addClass("error");
                $("#district").addClass("error");
                $("input[name='pwd']").addClass("error");
                $("input[name='rationCard']").addClass("error");
                $("input[name='kudMember']").addClass("error");
                $("input[name='JoiTocourse']").addClass("error");
                $("input[name='mgnrega']").addClass("error");
                $("input[name='BuildingName']").addClass("error");
                $("input[name='Landmark']").addClass("error");
                $("input[name='PostOffice']").addClass("error");
                $("input[name='PIN_Code']").addClass("error");
                $("#category").addClass("error");
                $("#hQualification").addClass("error");
                $("input[name='email']").addClass("error");
                
                Swal.fire("Please fill in all required fields in the Personal Details tab.");
                return false;
            }

            if (dobYear < maxYear) {
                $("input[name='dob']").addClass("error");
                displayValidationError('Maximum age limit exceeded for the selected gender.');
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            $("input[name='dob']").removeClass("error");
            $("input[name='gender']").removeClass("error");
            validationMessage.hide();

            // Prevent default form submission
            event.preventDefault();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($("#myForm")[0]);
            console.log(formData);
            

            $.ajax({
                
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
    url: "<?php echo e(route('SubmitInterest')); ?>",
    type: "POST",
    data: formData,
    dataType: "json",
    processData: false,
    contentType: false,
    success: function (response) {
        if (response.status == "success") {
        //     Swal.fire("Interest Submited",response.message,"success");
        //    $("#myForm")[0].reset();
        //     $("#ajax-loader").hide();
        //     window.location.href = response.redirect;
            Swal.fire({
                        title: "Interest Submitted",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#myForm")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#myForm")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
        } else{

            var errorMessage = "Something went wrong";

            if (response && response.message) {
                errorMessage = response.message;

            }

            Swal.fire("Failed", errorMessage, "error");

            $("#ajax-loader").hide();


}
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);
        console.log(JSON.parse(xhr.responseText).message);
        Swal.fire("Error", JSON.parse(xhr.responseText).message, "error");
        $("#ajax-loader").hide();
    }



});
    });
});


    
</script>

<script>

    $(document).ready(function()
    {
        //alert("hi");
        document.getElementById('employer_doc').addEventListener('change', function() {
  var fileInput = this;
  var errorMessage = document.getElementById('errorMessage');

  // Check if a file is selected
  if (fileInput.files.length > 0) {
    var fileSize = fileInput.files[0].size; // Size in bytes
    var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

    if (fileSize > maxSize) {
      errorMessage.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
      errorMessage.style.color = 'red';
      // Clear the selected file
      fileInput.value = '';
    } else {
      errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
      errorMessage.style.color = '#858796'; // Reset to default color
    }
  } else {
    errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
    errorMessage.style.color = '#858796'; // Reset to default color if no file selected
  }
});



    });


</script>
<script>

$(document).ready(function()
{
$("#empid").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#empid_error").html('Please select Employer Type');
    } else {
        $("#empid_error").html('');
        $("#empid").removeClass("error");
    }
  });

  $("#job").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#job_error").html('Please select job');
    } else {
        $("#job_error").html('');
        $("#job").removeClass("error");
    }
  });
  $("#fplacement").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#fplacement_error").html('Please select Placement');
    } else {
        $("#fplacement_error").html('');
        $("#fplacement").removeClass("error");
    }
  });
  
  $("#country").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#country_error").html('Please select country');
        $("#country").addClass("error");
    } else {
        $("#country_error").html('');
        $("#country").removeClass("error");
    }
  });

  $("#nfplacement").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#nfplacement_error").html('Please select placement');
        $("#nfplacement").addClass("error");
    } else {
        $("#nfplacement_error").html('');
        $("#nfplacement").removeClass("error");
    }
  });
  $("#ncountry").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#ncountry_error").html('Please select Country');
    } else {
        $("#ncountry_error").html('');
        $("#ncountry").removeClass("error");
    }
  });
  
});
$(document).on("click","textarea[name='msg_to_can']",function()
                {
                  //  $("input[name='msg_to_can']").removeClass("error");
                    $("textarea[name='msg_to_can']").removeClass("error");

                    $("#msg_to_can_error").html("");
                });

$(document).on("click","input[name='njdate']",function()
                {
                    $("input[name='njdate']").removeClass("error");
                    $("#njdate_error").html("");
                });
$(document).on("click","input[name='nsalary']",function()
                {
                    $("input[name='nsalary']").removeClass("error");
                    $("#nsalary_error").html("");
                });
$(document).on("click","input[name='category']",function()
                {
                    $("input[name='category']").removeClass("error");
                    $("#category_error").html("");
                });
$(document).on("click","input[name='njlocation']",function()
                {
                    $("input[name='njlocation']").removeClass("error");
                    $("#njlocation_error").html("");
                });
                $(document).on("click","input[name='jlocation']",function()
                {
                    $("input[name='jlocation']").removeClass("error");
                    $("#jlocation_error").html("");
                });
$(document).on("click","input[name='njob']",function()
                {
                    $("input[name='njob']").removeClass("error");
                    $("#njob_error").html("");
                });
$(document).on("click","input[name='attachment']",function()
                {
                    $("input[name='attachment']").removeClass("error");
                    $("#cv_error").html("");
                });
$(document).on("click","input[name='emp']",function()
                {
                    $("input[name='emp']").removeClass("error");
                    $("#emp_error").html("");
                });
                $(document).on("click","input[name='emp']",function()
                {
                    $("input[name='emp']").removeClass("error");
                    $("#emp_error").html("");
                });
                $(document).on("click","input[name='jlocation']",function()
                {
                    $("input[name='jlocation']").removeClass("error");
                    $("#jlocation_error").html("");
                });

                $(document).on("click","input[name='salary']",function()
                {
                    $("input[name='salary']").removeClass("error");
                    $("#salary_error").html("");
                });   
                $(document).on("click","input[name='jdate']",function()
                {
                    $("input[name='jdate']").removeClass("error");
                    $("#jdate_error").html("");
                }); 
                $(document).on("keyup","#BuildingName",function()
                {
                    var building_name=$(this).val();

                    if(!building_name)
                    {
                        $("#BuildingName_error").html("Please enter building name");
                        $("#BuildingName").addClass("error");
                    }

                    else{

                        $("#BuildingName_error").html("");
                        $("#BuildingName").removeClass("error");
                    }
                });

                $(document).on("keyup","#Landmark",function()
                {
                    var Landmark=$(this).val();

                    if(!Landmark)
                    {
                        $("#Landmark_error").html("Please enter Landmark");
                        $("#Landmark").addClass("error");
                    }

                    else{

                        $("#Landmark_error").html("");
                        $("#Landmark").removeClass("error");
                    }
                });
                $(document).on("keyup","#PostOffice",function()
                {
                    var PostOffice=$(this).val();

                    if(!PostOffice)
                    {
                        $("#PostOffice_error").html("Please enter Post Office name");
                        $("#PostOffice").addClass("error");
                    }

                    else{

                        $("#PostOffice_error").html("");
                        $("#PostOffice").removeClass("error");
                    }
                });

                $(document).on("keyup","#PIN_Code",function()
                {
                    var PIN_Code=$(this).val();

                    if(!PIN_Code)
                    {
                        $("#PIN_Code_error").html("Please enter Pin Code");
                        $("#PIN_Code").addClass("error");
                    }

                    else{

                        $("#PIN_Code_error").html("");
                        $("#PIN_Code").removeClass("error");
                    }
                });
                
                
</script>
<script>

$(document).ready(function()
{
    $(document).on("keyup","#agency_name",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the Agency Name";
        }

        else if(length>50){

            message+="Maximum 50 characters will be allowed"

        }
        else{
                message="";

                $("#agency_name").removeClass("error");
            }


        $("#agency_name_error").html(message);



    });

    $(document).on("keyup","#employer_name",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the Employer name";
        }

        else if(length>50){

            message+="Maximum 50 characters will be allowed"

        }
        else{
                message="";

                $("#employer_name").removeClass("error");
            }

        $("#employer_name_error").html(message);



    });

    $(document).on("keyup","#building_number",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enete the Building Number/Name";
        }

        else if(length>50){

            message+="Maximum 50 characters will be allowed"

        }
        else{
                message="";

                $("#building_number").removeClass("error");
            }

        $("#building_number_error").html(message);



    });

    $(document).on("keyup","#street_name",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the Street, Landmark";
        }

        else if(length>50){

            message+="Maximum 50 characters will be allowed"

        }
        else{
                message="";

                $("#street_name").removeClass("error");
            }

        $("#street_name_error").html(message);



    });

    $(document).on("keyup","#landmark",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length<1)
        {
            message+="Please enter the Street, Landmark";
        }

        else if(length>50){

            message+="Maximum 50 characters will be allowed"

        }
        else{
                message="";

                $("#landmark").removeClass("error");
            }

        $("#landmark_error").html(message);



    });

    $(document).on("keyup","#phone_number",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length>0 && length<10)
        {
            message+="Please enter a valid Phone Number";
        }

        else if(length>12){

            message+="Maximum 12 numbers will be allowed for Phone Number";
        }
        else{
                message="";

                $("#phone_number").removeClass("error");
            }

        $("#phone_number_error").html(message);



    });

    $(document).on("keyup","#contact_number",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length>0 && length<10)
        {
            message+="Please enter the valid Contact Number";
        }

        else if(length>12){

            message+="Maximum 12 numbers will be allowed for Contact Number"

        }
        else{
                message="";

                $("#contact_number").removeClass("error");
            }

        $("#contact_number_error").html(message);



    });
    $(document).on("keyup","#Contact_Numbers",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length!=10)
        {
            message+="Please enter the Valid Contact Number";
        }
        else{
                message="";

                $("#phone_number").removeClass("error");
            }

        
        $("#contatcno_error").html(message);



    });

    $(document).on("keyup","#mobile_number",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length!=10)
        {
            message+="Please enter the Valid Mobile Number";
        }
        else{
                message="";

                $("#mobile_number").removeClass("error");
            }

        
        $("#mobile_number_error").html(message);



    });

    $(document).on("keyup","#pan_number",function(e)
    {

        //alert('hi');
        var length=$(this).val().length;

        var panNum = $("#pan_number").val();

        var regpan = /^([A-Z]){5}([0-9]){4}([A-Z]){1}?$/;

        var message="";

        if ((regpan.test(panNum) == false))
        {
            message+="Pan Number criteria not met!";
        }
        
        else{
                message="";

                $("#pan_number").removeClass("error");
            }

        
        $("#pan_number_error").html(message);



    });

    $(document).on("keyup","#post_office",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length==0)
        {
            message+="Please enter the Post office name ";
        }

        else if(length>25){

            message+="Post office name should not exceed 25 letters";
        }
        else{
                message="";

                $("#post_office").removeClass("error");
            }

        
        
        $("#post_office_error").html(message);



    });

    $(document).on("keyup","#pincode",function(e)
    {

        var length=$(this).val().length;

        var message="";

        if(length!=6)
        {
            message+="Please enter the Pincode";
        }
        else{
                message="";

                $("#pincode").removeClass("error");
            }

        
        $("#pincode_error").html(message);



    });
         
    $("#email").on("keyup", function() {
    var emailInput = $(this).val();
    var emailError = $("#email_error");

    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

    if (!emailRegex.test(emailInput)) {
      emailError.text('Please enter a valid Email ID.');
      emailError.show();
    } else {
      emailError.hide();
      $("#email").removeClass("error");
    }
  });
  $("#nemail").on("keyup", function() {
    var emailInput = $(this).val();
    var emailError = $("#nemail_error");

    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

    if (!emailRegex.test(emailInput)) {
      emailError.text('Please enter a valid Email ID.');
      emailError.show();
    } else {
      emailError.hide();
      $("#nemail").removeClass("error");
    }
  });


$("#district").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#district_error").html('Please select the District');
    } else {
        $("#district_error").html('');
        $("#district").removeClass("error");
    }
  });
$("#state").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#state_error").html('Please select the State');
    } else {
        $("#state_error").html('');
        $("#state").removeClass("error");
    }
  });
  $("#country").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#country_error").html('Please select the Country');
    } else {
        $("#country_error").html('');
        $("#country").removeClass("error");
    }
  });
});


</script>

<script>

$(document).ready(function()
{
    document.getElementById('employer_doc').addEventListener('change', handleFileChange);

function handleFileChange() {
  console.log('Inside handleFileChange function');

  var fileInput = document.getElementById('employer_doc');
  var errorMessageContainer = document.getElementById('errorMessageContainer');
  var errorMessagedoc = document.getElementById('errorMessagedoc');

  // Check if a file is selected
  if (fileInput.files && fileInput.files.length > 0) {
    console.log('File selected');

    var fileSize = fileInput.files[0].size; // Size in bytes
    var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

    console.log('File size:', fileSize, 'bytes');

    if (fileSize > maxSize) {
      console.log('File size exceeds the allowed limit');
      errorMessagedoc.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
      errorMessagedoc.style.color = 'red';
      // Clear the selected file
      fileInput.value = '';

      // Display the error message container
      errorMessageContainer.style.display = 'block';
    } else {
      console.log('File size within limit');
      errorMessagedoc.textContent = 'Only Pdf documents of a maximum size of 2MB allowed';
      errorMessagedoc.style.color = '#858796'; // Reset to default color if no file selected
    }
  } else {
    console.log('No file selected');
    errorMessagedoc.textContent = 'Only Pdf documents of a maximum size of 2MB allowed';
    errorMessagedoc.style.color = '#858796'; // Reset to default color if no file selected
  }
}


});


</script>

<script>

    $(document).ready(function() {

        $(document).on("keyup","#training_name",function(e)
        {
            //alert("hi");
            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Trainning Programme Name";
            }

            else if(length>50){

                message+="Maximum of 50 characters allowed"

            }else{
                message="";

                $("#training_name").removeClass("error");
            }

            $("#training_name_error").html(message);

        });

        $(document).on("keyup","#description",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please eneter the Trainning Programme Description";
            }

            else if(length>150){

                message+="Maximum of 150 characters allowed"

            }else{
                message="";

                $("#description").removeClass("error");
            }


            $("#description_error").html(message);



        });


       

        $(document).on("keyup","#venue",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enetr the Venue";
            }

            else if(length>100){

                message+="Maximum of 100 characters allowed"

            }
            else{
                message="";

                $("#venue").removeClass("error");
            }

            $("#venue_error").html(message);



        });

        // $(document).on("keyup","#duration_new",function(e)
        // {
        //     var length=$(this).val().length;

        //     var message="";

        //     if(length<1)
        //     {
        //         message+="Please enete the Training Duration";
        //     }

        //     else if(length>15){

        //         message+="Maximum of 15 characters allowed"
                

        //     }
        //     else{
        //         message="";
        //         $("#duration_new").removeClass("error");
        //     }

        //     $("#duration_error").html(message);



        // });

        $(document).on("keyup","#gen_seats",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(isNaN(this.value) && this.value.length!=0){

                message+="Please enter the available General Seats";

            }

            else if(length>5){

                message+="Maximum allowed seat: 99999";
                    
            }
            else{
                message="";
                $("#gen_seats").removeClass("error");
            }
            
            $("#gen_seats_error").html(message);

        });

        $(document).on("keyup","#sc_seats",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(isNaN(this.value) && this.value.length!=0){

                message+="Please enter the available SC/ST Seats";

            }

            else if(length>5){

                message+="Maximum allowed seat: 99999";
                    
            }
            else{
                message="";
                $("#sc_seats").removeClass("error");
            }
            
            $("#sc_seats_error").html(message);

        });

        $(document).on("keyup","#min_seats",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(isNaN(this.value) && this.value.length!=0){

                message+="Please enteer the available Minority Seats";

            }

            else if(length>5){

                message+="Maximum allowed seat: 99999";
                    
            }
            else{
                message="";
                $("#min_seats").removeClass("error");
            }
            
            $("#min_seats_error").html(message);

        });


    });

</script>

<script>

    $(document).ready(function() {

        $(document).on("keyup","#training_name",function(e)
        {
            //alert("hi");
            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Please enter the Trainning Programme Name";
            }

            else if(length>50){

                message+="Maximum of 50 characters allowed"

            }else{
                message="";

                $("#training_name").removeClass("error");
            }

            $("#training_name_error").html(message);

        });

        $(document).on("keyup","#description",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Provide atleast one character for Trainning Programme Description";
            }

            else if(length>150){

                message+="Maximum of 150 characters allowed"

            }else{
                message="";

                $("#description").removeClass("error");
            }


            $("#description_error").html(message);



        });

        $(document).on("keyup","#venue",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(length<1)
            {
                message+="Provide atleast one character for Venue";
            }

            else if(length>100){

                message+="Maximum of 100 characters allowed"

            }

            $("#venue_error").html(message);



        });

        // $(document).on("keyup","#duration",function(e)
        // {

        //     var length=$(this).val().length;

        //     var message="";

        //     if(length<1)
        //     {
        //         message+="Provide atleast one character for Training Duration";
        //     }

        //     else if(length>15){

        //         message+="Maximum of 15 characters allowed"

        //     }

        //     $("#duration_error").html(message);



        // });

        $(document).on("keyup","#gen_seats",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(isNaN(this.value) && this.value.length!=0){

                message+="Enter a valid number";

            }

            else if(length>5){

                message+="Maximum allowed seat: 99999";
                    
            }
            
            $("#gen_seats_error").html(message);

        });

        $(document).on("keyup","#sc_seats",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(isNaN(this.value) && this.value.length!=0){

                message+="Enter a valid number";

            }

            else if(length>5){

                message+="Maximum allowed seat: 99999";
                    
            }
            
            $("#sc_seats_error").html(message);

        });

        $(document).on("keyup","#min_seats",function(e)
        {

            var length=$(this).val().length;

            var message="";

            if(isNaN(this.value) && this.value.length!=0){

                message+="Enter a valid number";

            }

            else if(length>5){

                message+="Maximum allowed seat: 99999";
                    
            }
            
            $("#min_seats_error").html(message);

        });


    });

</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#submit_course_details",function(e) {
            var SectorID = $("#sectordropdown").val();
            //alert(SectorID);
            var CourseMasterID =$("#coursename").val();
            //alert(CourseMasterID);
            var TrainingName = $("#training_name").val();
            //alert(TrainingName);
            var Description = $("#description").val();
            //alert(Description);
            var Skill = $("#skill").val();
           // alert(Skill);
            var PIA = $("#PIA").val();
            var DistrictID = $("#districtdropdown").val();
            //alert(DistrictID);
            var LocalBodyID = $("#localbodydropdown").val();
            //alert(LocalBodyID);
            var Venue = $("#venue").val();
            //alert(Venue);
            var start_date = $("#start_date").val();
            //alert(start_date);
            var end_date = $("#end_date").val();
            //alert(end_date);
            var Duration = $("#duration_new").val();
            //alert(Duration);
            var GeneralSeats = $("#gen_seats").val();
            //alert(GeneralSeats);
            var SCSTSeats = $("#sc_seats").val();
            //alert(SCSTSeats);
            var MinoritySeats = $("#min_seats").val();
            //alert(MinoritySeats);
            var TotSeats = $("#total").val();
            
           // alert(TPStatus);
           var startDateInput = document.getElementById("start_date");
            var endDateInput = document.getElementById("end_date");

            var startDate = new Date(startDateInput.value);
            var endDate = new Date(endDateInput.value);

           
                 

            if (!SectorID|| !CourseMasterID|| !TrainingName|| !Description|| !Skill || Skill.length === 0|| !DistrictID|| !LocalBodyID|| !Venue|| !start_date|| !end_date|| !Duration|| !GeneralSeats|| !SCSTSeats|| !MinoritySeats)
            {

     
                if(!SectorID)
                {
                    $("#sector_error").html("Please select the sector");
                    $("#sectordropdown").addClass("error");

                }
                else{
                    $("#sector_error").html("");
                    $("#sectordropdown").removeClass("error");
                }

                if(!CourseMasterID)
                {
                    $("#course_error").html("Please select the Trade Name");
                    $("#trainingdropdown").addClass("error");
                }
                else{
                    $("#course_error").html("");
                    $("#trainingdropdown").removeClass("error");
                }

                if(!TrainingName)
                {
                    $("#training_name_error").html("Please enter the Training Programme Name");
                    $("#training_name").addClass("error");
                }
                else{
                    $("#training_name_error").html("");
                    $("#training_name").removeClass("error");
                }

                if(!Description)
                {
                    $("#description_error").html("Please enter the Training Programme Description");
                    $("#description").addClass("error");
                }
                else{
                    $("#description_error").html("");
                    $("#description").removeClass("error");
                }

                
                if(!Skill || Skill.length === 0)
                {
                    $("#skill_error").html("Please select the Skills");
                    $(".multiselect").addClass("error");
                }
                else{
                    $("#skill_error").html("");
                    $(".multiselect").removeClass("error");
                }

                if(!DistrictID)
                {
                    $("#district_error").html("Please select the district");
                    $("#districtdropdown").addClass("error");
                }
                else{
                    $("#district_error").html("");
                    $("#districtdropdown").removeClass("error");
                }

                if(!LocalBodyID)
                {
                    $("#local_body_error").html("Please select the Local Body");
                    $("#lbdropdown").addClass("error");
                }
                else{
                    $("#local_body_error").html("");
                    $("#lbdropdown").removeClass("error");
                } 

                if(!Venue)
                {
                    $("#venue_error").html("Please enter the Venue");
                    $("#venue").addClass("error");
                }
                else{
                    $("#venue_error").html("");
                    $("#venue").removeClass("error");
                }

                if(!start_date)
                {
                    $("#start_date_error").html("Please select the start date");
                    $("#start_date").addClass("error");
                }
                else{
                    $("#start_date_error").html("");
                    $("#start_date").removeClass("error");
                }

                if(!end_date)
                {
                    $("#end_date_error").html("Please select the end date");
                    $("#end_date").addClass("error");
                }
                else{
                    $("#end_date_error").html("");
                    $("#end_date").removeClass("error");
                }

                // if(!Duration)
                // {
                 //    $("#duration_new_error").html("Please enter the duration of the training program");
                // $("#duration_new").addClass("error");
               //  }
                // else{
                   //  $("#duration_new_error").html("");
                 //    $("#duration_new").removeClass("error");
               //  }

                if(!GeneralSeats)
                {
                    $("#gen_seats_error").html("Please enter the available General Seats");
                    $("#gen_seats").addClass("error");
                }
                else{
                    $("#gen_seats_error").html("");
                    $("#gen_seats").removeClass("error");
                }

                if(!SCSTSeats)
                {
                    $("#sc_seats_error").html("Please enter the available SC/ST Seats");
                    $("#sc_seats").addClass("error");
                }
                else{
                    $("#sc_seats_error").html("");
                    $("#sc_seats").removeClass("error");
                }

                if(!MinoritySeats)
                {
                    $("#min_seats_error").html("Please enteer the available Minority Seats");
                    $("#min_seats").addClass("error");
                }
                else{
                    $("#min_seats_error").html("");
                    $("#min_seats").removeClass("error");
                }

               
                
                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#plwait").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);
            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
                url: "<?php echo e(route('submitCourseDetails')); ?>",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                        title: "A training program was successfully created.",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#submit_course_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#submit_course_details")[0].reset();
                         $("#plwait").hide();
                         window.location.href = response.redirect;
                     }
                    });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#plwait").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#plwait").hide();
                }
            });
        });
    });
    
</script>

<script>
    $(document).ready(function() {
        //Swal.fire('Document is ready!');
        var validationMessage = $('.validation-messages');
        validationMessage.empty();

        function displayValidationError(message) {
            $('#errorMessage1').show();
            validationMessage.append('<p>' + message + '</p>');
        }
        $(document).on("submit","#update_training_details",function(e) {
            var id = $("#id").val();
            var SectorID = $("#sectordropdown").val();
            //alert(SectorID);
            var CourseMasterID =$("#trainingdropdown").val();
            //alert(CourseMasterID);
            var TrainingName = $("#training_name").val();
            //alert(TrainingName);
            var Description = $("#description").val();
            //alert(Description);
            var Skill = $("#skill").val();
            //alert(Skill);
            var PIA = $("#PIA").val();
            var DistrictID = $("#districtdropdown").val();
            //alert(DistrictID);
            var LocalBodyID = $("#lbdropdown").val();
            //alert(LocalBodyID);
            var Venue = $("#venue").val();
            //alert(Venue);
            var start_date = $("#start_date_edit").val();
            //alert(start_date);
            var end_date = $("#end_date_edit").val();
            //alert(end_date);
            var Duration = $("#duration").val();
            //alert(Duration);
            var GeneralSeats = $("#gen_seats").val();
            //alert(GeneralSeats);
            var SCSTSeats = $("#sc_seats").val();
            //alert(SCSTSeats);
            var MinoritySeats = $("#min_seats").val();
            //alert(MinoritySeats);
            var TotSeats = $("#total").val();
            var TPStatus = $("#tpstatusdropdown").val();
           // alert(TPStatus);

            if (!SectorID|| !CourseMasterID|| !TrainingName|| !Description|| !Skill|| !DistrictID|| !LocalBodyID|| !Venue|| !start_date|| !end_date|| !Duration|| !GeneralSeats|| !SCSTSeats|| !MinoritySeats|| !TPStatus)
            {
                if(!SectorID)
                {
                    $("#sector_error").html("Please select a Sector");
                    $("#sectordropdown").addClass("error");
                }
                else{
                    $("#sector_error").html("");
                    $("#sectordropdown").removeClass("error");
                }

                if(!CourseMasterID)
                {
                    $("#course_error").html("Please select a Trade Name");
                    $("#trainingdropdown").addClass("error");
                }
                else{
                    $("#course_error").html("");
                    $("#trainingdropdown").removeClass("error");
                }

                if(!TrainingName)
                {
                    $("#training_name_error").html("Please enter a Training Programme Name");
                    $("#training_name").addClass("error");
                }
                else{
                    $("#training_name_error").html("");
                    $("#training_name").removeClass("error");
                }

                if(!Description)
                {
                    $("#description_error").html("Please enter the Training Programme Description");
                    $("#description").addClass("error");
                }
                else{
                    $("#description_error").html("");
                    $("#description").removeClass("error");
                }

                if(!Skill)
                {
                    $("#skill_error").html("Please select the skills");
                    $("#skill").addClass("error");
                }
                else{
                    $("#skill_error").html("");
                    $("#skill").removeClass("error");
                }

                if(!DistrictID)
                {
                    $("#district_error").html("Please select the District");
                    $("#districtdropdown").addClass("error");
                }
                else{
                    $("#district_error").html("");
                    $("#districtdropdown").removeClass("error");
                }

                if(!LocalBodyID)
                {
                    $("#local_body_error").html("Please select the Local Body");
                    $("#lbdropdown").addClass("error");
                }
                else{
                    $("#local_body_error").html("");
                    $("#lbdropdown").removeClass("error");
                } 

                if(!Venue)
                {
                    $("#venue_error").html("Please enter the Venue");
                    $("#venue").addClass("error");
                }
                else{
                    $("#venue_error").html("");
                    $("#venue").removeClass("error");
                }

                if(!start_date)
                {
                    $("#start_date_error").html("Please select the Start Date");
                    $("#start_date_edit").addClass("error");
                }
                else{
                    $("#start_date_error").html("");
                    $("#start_date_edit").removeClass("error");
                }

                if(!end_date)
                {
                    $("#end_date_error").html("Please select the End Date");
                    $("#end_date").addClass("error");
                }
                else{
                    $("#end_date_error").html("");
                    $("#end_date").removeClass("error");
                }

                if(!Duration)
                {
                    $("#duration_error").html("Please enter the duration of the training program.");
                    $("#duration").addClass("error");
                }
                else{
                    $("#duration_error").html("");
                    $("#duration").removeClass("error");
                }

                if(!GeneralSeats)
                {
                    $("#gen_seats_error").html("Please enter the available General Seats");
                    $("#gen_seats").addClass("error");
                }
                else{
                    $("#gen_seats_error").html("");
                    $("#gen_seats").removeClass("error");
                }

                if(!SCSTSeats)
                {
                    $("#sc_seats_error").html("Please enter the available SC/ST Seats");
                    $("#sc_seats").addClass("error");
                }
                else{
                    $("#sc_seats_error").html("");
                    $("#sc_seats").removeClass("error");
                }

                if(!MinoritySeats)
                {
                    $("#min_seats_error").html("Please enter the available Minority Seats");
                    $("#min_seats").addClass("error");
                }
                else{
                    $("#min_seats_error").html("");
                    $("#min_seats").removeClass("error");
                }

                if(!TPStatus)
                {
                    $("#tp_status_error").html("Please Select a Status");
                    $("#tpstatusdropdown").addClass("error");
                }
                else{
                    $("#tp_status_error").html("");
                    $("#tpstatusdropdown").removeClass("error");
                }
                
                Swal.fire("Please fill in all required fields.");
                return false;
            }

            // Reset error classes and hide validation message on successful validation
            //validationMessage.hide();

            // Prevent default form submission
            e.preventDefault();

            $("#plwait").show();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($(this)[0]);
            console.log(formData);            
            $.ajax({               
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
                url: "<?php echo e(route('updateTrainingDetails')); ?>",
                type: "POST",
                data: formData,
                dataType: "json",
                processData: false,
                contentType: false,
                success: function (response) 
                {
                    if(response.status=="success")
                    {
                        Swal.fire({
                            title: "The training program was updated successfully...",
                            icon: "success"
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // User clicked "OK" button
                                $("#update_training_details")[0].reset();
                                $("#plwait").hide();
                                window.location.href = response.redirect;
                            } else{
                                $("#update_training_details")[0].reset();
                                $("#plwait").hide();
                                window.location.href = response.redirect;
                            }
                        });
                    }
                    else{
                        Swal.fire("Error",response.message,"error");
                        $("#plwait").hide();
                    }
                },
                error:function()
                {
                    Swal.fire("wrong","something went wrong","error");
                    $("#plwait").hide();
                }
            });
         });
         $("#sectordropdown").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#sector_error").html('Please select the sector');
        $('#trainingdropdown').html('<option value="">-- Select Trade Name --</option>');
        document.getElementById("coursecode").value = "";

    } else {
        $("#sector_error").html('');
        $("#sectordropdown").removeClass("error");
    }
  });

  $("#trainingdropdown").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#course_error").html('Please select the Trade Name');
        document.getElementById("coursecode").value = "";

    } else {
        $("#course_error").html('');
        $("#trainingdropdown").removeClass("error");
    }
  });

  $("#districtdropdown").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#district_error").html('Please select the District');
        $('#lbdropdown').html('<option value="">-- Select Local Body --</option>');

    } else {
        $("#district_error").html('');
        $("#districtdropdown").removeClass("error");
    }
  });

  $("#tpstatusdropdown").on("change blur", function() {
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#tp_status_error").html('Please Select a Status');

    } else {
        $("#tp_status_error").html('');
        $("#tpstatusdropdown").removeClass("error");
    }
  });


  $("#lbdropdown").on("change blur", function() {
    
    var selectedValue = $(this).val();

    if (selectedValue === "") {
        $("#local_body_error").html('Please select the LocalBody');

    } else {
        $("#local_body_error").html('');
        $("#lbdropdown").removeClass("error");
    }
  });

    });

    document.addEventListener("DOMContentLoaded", function () {
            var today = new Date();
            today.setHours(0, 0, 0, 0); // Set time to midnight for accurate date comparison

            var tomorrow = new Date(today);
            tomorrow.setDate(today.getDate() + 1); // Set to tomorrow

            var dayAfterTomorrow = new Date(tomorrow);
            dayAfterTomorrow.setDate(tomorrow.getDate() + 1); // Set to the day after tomorrow

            // Set min attribute for the date inputs
            document.getElementById("start_date").setAttribute("min", tomorrow.toISOString().split('T')[0]);
            document.getElementById("end_date").setAttribute("min", dayAfterTomorrow.toISOString().split('T')[0]);
        });
        function validateDates() {
            var startDateInput = document.getElementById("start_date");
            var endDateInput = document.getElementById("end_date");

            var startDate = new Date(startDateInput.value);
            var endDate = new Date(endDateInput.value);

            if (startDate > endDate) {
                $("#end_date_error").html('End date cannot be earlier than start date. Please select a valid range');
                endDateInput.value = ""; // Clear the end date input
            }
            else
            {
                $("#end_date_error").html("");
                $("#end_date").removeClass("error");
                $("#start_date_error").html("");
                $("#start_date").removeClass("error");
            }
        }

    
</script>


<?php if(isset($max_year)): ?>
        <script>

            $(document).ready(function()
            {
                var currentDate = new Date();

                // Calculate the date 18 years ago
                var eighteenYearsAgo = new Date(currentDate.getFullYear() - 18, currentDate.getMonth(), currentDate.getDate());

                // Format the date to YYYY-MM-DD (required by the date input type)
                var formattedDate = eighteenYearsAgo.toISOString().split('T')[0];

                // Set the default value of the input element
                document.getElementById('dob').value = formattedDate;
                document.getElementById('dob').max = formattedDate;
            });


        </script>


    
      

        <script>

            function calculateMaxYear() {
                    var currentDate = new Date();
                    var defaultMaxYear = currentDate.getFullYear() - 35;
                    
                    var genderElements = document.getElementsByName('gender');
                    var selectedGender;

                    for (var i = 0; i < genderElements.length; i++) {
                        if (genderElements[i].checked) {
                            selectedGender = genderElements[i].value;
                            break;
                        }
                    }

                    var maxYear;

                    if (selectedGender === 'Male') {
                        maxYear = currentDate.getFullYear() - 35;
                    } else if (selectedGender === 'Female' || selectedGender === 'Transgender') {
                        maxYear = currentDate.getFullYear() - 45;
                    } else {
                        maxYear = defaultMaxYear;
                    }

                    return maxYear;
                }


                function checkdob()
                {
                    
                    var maxYear=calculateMaxYear();
                    
                    dobYear=new Date($("#dob").val()).getFullYear();

                    var year_limit="<?php echo e($max_year); ?>";

                    if(dobYear>year_limit)
                    {
                        $("#dob_error").html("Agre criteria not met");
                    }
                    
                    else if(dobYear<maxYear)
                    {
                        $("#dob_error").html("Date of birth not valid for selected gender");
                    }

                   
                    else{

                        $("#dob_error").html("");
                        $("#dob").removeClass("error");
                    }
                }


        </script>


        <script>

            $(document).ready(function()
            {

                $(document).on("keyup","#dob",function()
                {
                    checkdob();
                });

                $(document).on("change","#dob",function()
                {

                    checkdob();

                });
            });


        </script>

        <?php endif; ?>


    <script>

        $(document).ready(function()
        {
            $(document).on("change","#district",function()
            {

                var district_id=$(this).val();
                var localbody_type=$("#localbody_type").val();
                load_localbodies(localbody_type,district_id);
                $("#localbody_type").prop("selectedIndex",0);
            });

            $(document).ready(function()
            {
                $(document).on("change","#localbody_type",function()
                {
                    var district_id=$("#district").val();
                    var localbody_type=$(this).val();
                    load_localbodies(localbody_type,district_id);
                });
            });
        });


    </script>

   

    <script>

        function load_localbodies(LBTID,DistrictID)
        {

                    $.ajax({
                        method: "GET",
                        url: "/api/list-localbody/" + DistrictID+ "?LBT=" + LBTID,
                        data: { DistrictID: DistrictID ,LBTID: LBTID }, // Pass data as an object
                        success: function (data) {
                            //console.log(data);
                            //Clear and populate options in the block_list element
                            $('#localbody').html('<option value="">Choose Local Body</option>');
                            $.each(data.data, function (index, value) {
                                $('#localbody').append('<option value="' + value.id + '">' + value.name_eng + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });

        }



    </script>

        
        

        <script>

            $(document).ready(function()
            {
                $(document).on("change","#hQualification",function()
                {
                    var hq=$(this).val();

                    if(!hq)
                    {
                        $("#highest_qualification_error").html("Please choose highest qualification");
                    }

                    else{

                        $("#highest_qualification_error").html("");
                        $("#hQualification").removeClass("error");
                    }
                });



                $(document).on("change","#district",function()
                {
                    var district=$(this).val();

                    if(!hq)
                    {
                        $("#district_error").html("Please choose district");
                    }

                    else{

                        $("#district_error").html("");
                        $("#district").removeClass("error");
                    }
                });

                
 

                $(document).on("keyup","#BuildingName",function()
                {
                    var building_name=$(this).val();

                    if(!building_name)
                    {
                        $("#building_name_error").html("Please enter building name");
                    }

                    else{

                        $("#building_name_error").html("");
                        $("#BuildingName").removeClass("error");
                    }
                });

                $(document).on("keyup","#Landmark",function()
                {
                    var landmark=$(this).val();

                    if(!landmark)
                    {
                        $("#landmark_error").html("Please enter landmark");
                    }

                    else{

                        $("#landmark_error").html("");
                        $("#Landmark").removeClass("error");
                    }
                });

                
                $(document).on("keyup","#PostOffice",function()
                {
                    var post_office=$(this).val();

                    if(!post_office)
                    {
                        $("#post_office_error").html("Please enter post office name");
                    }

                    else{

                        $("#post_office_error").html("");
                        $("#PostOffice").removeClass("error");
                    }
                });

                $(document).on("keyup","#PIN_Code",function()
                {
                    var pincode=$(this).val();

                    if(!pincode)
                    {
                        $("#pincode_error").html("Please enter pincode");
                    }

                    else{

                        $("#pincode_error").html("");
                        $("#PIN_Code").removeClass("error");
                    }
                });

      

                $(document).on("change","#category",function()
                {
                    var category=$(this).val();

                    if(!category)
                    {
                        $("#category_error").html("Please choose category");
                    }

                    else{

                        $("#category_error").html("");
                        $("#category").removeClass("error");
                    }
                });

                $(document).on("change","#course_master",function()
                {
                    var course_master=$(this).val();

                    if(!course_master)
                    {
                        $("#course_master_error").html("Please choose course");
                    }

                    else{

                        $("#course_master_error").html("");
                        $("#course_master").removeClass("error");
                    }
                });

                
                $(document).on("change","#trainings",function()
                {
                    var training=$(this).val();

                    if(!training)
                    {
                        $("#training_error").html("Please choose training");
                    }

                    else{

                        $("#training_error").html("");
                        $("#trainings").removeClass("error");
                    }
                });
            });


        </script>

        <script>

            function validate_name(event)
            {
                var input=event.key;

                if (/^[a-zA-Z]*$/.test(input)) {
                    return true;
                } else {
                    // Prevent the input if it's numeric
                    event.preventDefault();
                    return false;
                }
            }


        </script>

        <script>

            $(document).ready(function()
            {



                $(document).on("keyup","#name",function()
                {
                  var name=$(this).val();

                  if(name.length>0)
                  {
                     $("#name_error").html("");
                     $("#name").removeClass("error");

                  }

                  else{

                     $("#name_error").html("Please enter name");
                     
                  }
                });

                
                $(document).on("keyup","#email",function()
                {
                  var email=$(this).val();

                  if(email.length>0)
                  {
                     $("#email_error").html("");
                     $("#email").removeClass("error");

                  }

                  else{

                     $("#email_error").html("Please enter email");
                     $("#emailValidationMessage").hide();
                     
                  }
                });

                $(document).on("keyup","#ContactNumber",function()
                {
                  var contact_number=$(this).val();

                  if(contact_number.length>0)
                  {
                     $("#contact_number_error").html("");
                     $("#ContactNumber").removeClass("error");

                  }

                  else{

                     $("#contact_number_error").html("Please enter contact number");
                     
                  }
                });

                $(document).on("click","input[name='pwd']",function()
                {
                    $("input[name='pwd']").removeClass("error");
                    $("#pwd_error").html("");
                });

                $(document).on("click","input[name='KudMember']",function()
                {
                    $("input[name='KudMember']").removeClass("error");
                    $("#kudmemb_error").html("");
                });

                $(document).on("click","input[name='rationCard']",function()
                {
                    $("input[name='rationCard']").removeClass("error");
                    $("#ration_card_error").html("");
                });

                $(document).on("click","input[name='mgnrega']",function()
                {
                    $("input[name='mgnrega']").removeClass("error");
                    $("#mgnrega_error").html("");
                });

                $(document).on("click","input[name='JoiTocourse']",function()
                {
                    $("input[name='JoiTocourse']").removeClass("error");
                    $("#join_course_error").html("");
                });

                $(document).on("click","input[name='gender']",function()
                {
                    $("input[name='gender']").removeClass("error");
                    $("#gender_error").html("");
                });

            });

        </script>

        <script>


        function liveValidateEmail() {

            $("#emailValidationMessage").show();
            var emailInput = document.getElementById('email');
            var email = emailInput.value;

            // Use a regular expression for basic email validation
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            var validationMessage = document.getElementById('emailValidationMessage');

            if(email)
            {

                if (emailPattern.test(email)) {
                    validationMessage.textContent = 'Email is valid';
                    validationMessage.style.color = 'green';

                   
                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('AlreadyExistEmail')); ?>",
                        type:"POST",
                        data:{email:email},
                        dataType:"JSON",
                        success:function(response)
                        {
                            if(response.status=="exists")
                            {
                                validationMessage.textContent = response.message;
                                validationMessage.style.color = 'red';
                            }
                        }
                    });
                } else {
                    validationMessage.textContent = 'Invalid email address';
                    validationMessage.style.color = 'red';
                }

            }

           
        }


        </script>

        <script>

            $(document).ready(function()
            {
                $(document).on("change","#localbody",function()
                {

                    load_blocks();

                });

                $(document).on("change","#localbody_type",function()
                {
                    load_blocks();
                });
                
           
            });

            function load_blocks()
            {

                var selectedValue = $('#localbody_type').val();

                // Show or hide the div based on the selected value
                if (selectedValue === '1') {
                    $('#block_div').show();

                    DistrictID=$('#district').val();
                    $.ajax({
                        method: "GET",
                        url: "/api/list-blocks/" + DistrictID,
                        data: { DistrictID: DistrictID }, // Pass data as an object
                        success: function (data) {
                            // Clear and populate options in the block_list element
                            $('#block_list').html('<option value="0">Choose Block</option>');
                            $.each(data.data, function (index, value) {
                                $('#block_list').append('<option value="' + value.id + '">' + value.name + '</option>');
                            });
                        },
                        error: function (xhr, status, error) {
                            // Handle errors if needed
                            console.error(xhr.responseText);
                        }
                    });

                } else {
                    $('#block_div').hide();
                }

            }


        </script>

        <script>

            $(document).ready(function()
            {
                $('#ExtraMasterId'). attr('disabled', true); 

                $(document).on("submit","#AddCandidate",function(e)
                {

                    var form_data=new FormData($(this)[0]);

                    e.preventDefault();
                    
                    var name=$("#name").val();
                    var contact_number=$("#ContactNumber").val();
                    var email=$("#email").val();
                    var trainings=$("#trainings").val();
                    var course_master=$("#course_master").val();
                    var category=$("#category").val();
                    var religion=$("#religion").val();
                    var pincode=$("#PIN_Code").val();
                    var post_office=$("#PostOffice").val();
                    var Landmark=$("#Landmark").val();
                    var building_name=$("#BuildingName").val();
                    var district=$("#district").val();
                    var highest_qualification=$("#hQualification").val();
                    var dob=$("#dob").val();
                    var gender=$("input[name='gender']:checked").val();
                    var pwd=$("input[name='pwd']:checked").val();
                    var mgnrega=$("input[name='mgnrega']:checked").val();
                    var JoiTocourse=$("input[name='JoiTocourse']:checked").val();
                    var rationCard=$("input[name='rationCard']:checked").val();
                    var KudMember=$("input[name='KudMember']:checked").val();

                     if(!mgnrega || !rationCard || !KudMember || !JoiTocourse || !pwd || !name || !contact_number || !email || !trainings || !course_master || !category  || !pincode || !post_office || !Landmark || !building_name || !district || !highest_qualification || !dob || !gender)
                    {
                         Swal.fire("Warning","Please fill all mandatory fields","error");

                         if(!KudMember)
                         {
                            $("input[name='KudMember']").addClass("error");
                            $("#kudmemb_error").html("Please choose Kudumbashree Membership status");
                         }

                         if(!JoiTocourse)
                         {
                            $("input[name='JoiTocourse']").addClass("error");
                            $("#join_course_error").html("Please choose status of willingness to join course");
                         }

                         if(!mgnrega)
                         {
                            $("input[name='mgnrega']").addClass("error");
                            $("#mgnrega_error").html("Please choose mgnrega status");
                         }

                         if(!rationCard)
                         {
                            $("input[name='rationCard']").addClass("error");
                            $("#ration_card_error").html("Please ration card type");
                         }

                         if(!pwd)
                         {
                            $("input[name='pwd']").addClass("error");
                            $("#pwd_error").html("Please choose PWD status");
                         }

                         if(!name)
                         {
                            $("#name").addClass('error');
                            $("#name_error").html("Please enter name");
                         }

                         if(!email)
                         {

                            $("#email").addClass('error');
                            $("#email_error").html("Please enter email");

                         }

                         if(!contact_number)
                         {

                            $("#ContactNumber").addClass('error');
                            $("#contact_number_error").html("Please contact number");

                         }

                         if(!gender)
                         {
                            $("input[name='gender']").addClass("error");
                            $("#gender_error").html("Please choose gender");
                         }

                         if(!dob)
                         {
                            $("#dob").addClass("error");
                            $("#dob_error").html("Enter date of birth");
                         }

                         if(!highest_qualification)
                         {
                            $("#hQualification").addClass("error");
                            $("#highest_qualification_error").html("Please choose highest qualification");
                         }

                         if(!district)
                         {
                            $("#district").addClass("error");
                            $("#district_error").html("Please choose district");
                         }

                         if(!building_name)
                         {
                            $("#BuildingName").addClass("error");
                            $("#building_name_error").html("Please enter building name");
                         }

                         if(!Landmark)
                         {
                            $("#Landmark").addClass("error");
                            $("#landmark_error").html("Please enter landmark");
                         }

                         if(!post_office)
                         {
                            $("#PostOffice").addClass("error");
                            $("#post_office_error").html("Please enter post office name");
                         }

                         if(!pincode)
                         {
                            $("#PIN_Code").addClass("error");
                            $("#pincode_error").html("Please enter pincode");
                         }

                         if(!category)
                         {
                            $("#category").addClass("error");
                            $("#category_error").html("Please choose category");
                         }

                         if(!trainings)
                         {
                            $("#trainings").addClass("error");
                            $("#training_error").html("Please choose training");
                         }else{
                            $("#training_error").html("");
                        $("#trainings").removeClass("error");
                         }

                         if(!course_master)
                         {
                            $("#course_master").addClass("error");
                            $("#course_master_error").html("Please choose course");
                         }

                         

                    }

                    else{

                        $("#ajax-loader").show();

                        $.ajax({
                            headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                            url:"<?php echo e(route('piaSubmitCandidateDetails')); ?>",
                            type:"POST",
                            data:form_data,
                            dataType:"JSON",
                            processData:false,
                            contentType:false,
                            success:function(response)
                            {
                                if(response.status=="success")
                                {
                                    Swal.fire({
                                        text:"The candidate is successfully assigned to the training program.",
                                        icon:"success"
                                    }).then(function(result)
                                    {
                                        if(result.isConfirmed)
                                        {
                                            $("#AddCandidate")[0].reset();
                                            $("#ajax-loader").hide();
                                            window.location.href="<?php echo e(route('candidateInterestList')); ?>";
                                        }

                                        else{

                                            $("#ajax-loader").hide();
                                            


                                        }
                                    });
                                }

                                else{

                                    swal.fire("error",response.message,"");
                                    $("#ajax-loader").hide();


                                }
                            }
                        });
                    }
                   





                });
            });
  ////////////////////Training Course Selection Based on Master Course for Candidate interest status change///////////////////////////////////
  $(document).on("change", "input[type=radio][name=MasterCourse]", function () {
                // Get the selected radio button value
            var radVal = $("input[type=radio][name=MasterCourse]:checked").val();               
            if(radVal!="other"){
                       
            
            
                if(radVal!="")
                {

                    $.ajax({
                        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                        url:"<?php echo e(route('loadTrainings')); ?>",
                        type:"POST",
                        data:{master:radVal},
                        dataType:"JSON",
                        success:function(response)
                        {
                           if(response.status=="success")
                           {
                                var trainings=response.training;

                                $("#trainings").html("");

                                $("#trainings").append("<option value=''>Choose Trainings</option>");

                                trainings.forEach(function(trainings)
                                {
                                    $("#trainings").append("<option value='"+trainings.id+"'>"+trainings.training_name+"</option>");
                                });
                           }
                        }
                    });

                }
                $('#ExtraMasterId'). attr('disabled', true); 
                $("#ExtraMasterId").val("Choose Master Course");
                $("select[name='ExtraMasterId']").removeClass("error"); 
            }else{
                $("#trainings").html("");
                $('#ExtraMasterId'). attr('disabled', false); 
              //  $("#ExtraMasterId").val("Choose Master Course");
            }
            });

            ///////////////////////////////////////////////////////
          
            $('#submitBtn_CourseCandidate').click(function(event) {
           // Swal.fire('Form submitted!');
          
var Gender =$("input[name='gender']:checked").val();
var MasterCourse =$("input[name='MasterCourse']:checked").val();
var dobYear = $("#dob").val();
var maxYear = calculateMaxYear();

var email = $("#email").val();
var mobileNumber = $("#ContactNumber").val();
var BuildingName = $("#BuildingName").val();
var Landmark = $("#Landmark").val();
var PostOffice = $("#PostOffice").val();
var PIN_Code = $("#PIN_Code").val();

if (!MasterCourse||!Gender||!dobYear||!email||!mobileNumber||!BuildingName||!Landmark||!PostOffice||!PIN_Code)
{
        if(!MasterCourse)  {
            $("input[name='MasterCourse']").addClass("error");            
             $("#MasterCourse_error").html("Please enter the Master Course");
        }else{
            $("input[name='MasterCourse']").removeClass("error");            
            $("#MasterCourse_error").html("");
        }  
        
        if(!mobileNumber)  {
            $("input[name='ContactNumber']").addClass("error");            
             $("#mobile_number_error").html("Please enter the Contact Number");
        }else{
            $("input[name='ContactNumber']").removeClass("error");            
            $("#mobile_number_error").html("");
        }  

        if(!dobYear)  {
            $("input[name='dob']").addClass("error");            
             $("#dob_error").html("Please enter the DOB");
        }else{
            $("input[name='dob']").removeClass("error");            
            $("#dob_error").html("");
        } 
        if(!Gender)  {
            $("input[name='gender']").addClass("error");            
             $("#gender_error").html("Please enter the Gender");
        }else{
            $("input[name='gender']").removeClass("error");            
            $("#gender_error").html("");
        } 
        
        if(!email)  {
            $("input[name='email']").addClass("error");            
             $("#email_error").html("Please enter the Email ID");
        }else{
            $("input[name='email']").removeClass("error");            
            $("#email_error").html("");
        }   
        
        if(!BuildingName)  {
            $("input[name='BuildingName']").addClass("error");            
             $("#BuildingName_error").html("Please enter the Building Name/Number");
        }else{
            $("input[name='BuildingName']").removeClass("error");            
            $("#BuildingName_error").html("");
        } 
        
        if(!Landmark)  {
            $("input[name='Landmark']").addClass("error");            
             $("#Landmark_error").html("Please enter the Landmark");
        }else{
            $("input[name='Landmark']").removeClass("error");            
            $("#Landmark_error").html("");
        }

        if(!PostOffice)  {
            $("input[name='PostOffice']").addClass("error");            
             $("#PostOffice_error").html("Please enter the PostOffice");
        }else{
            $("input[name='PostOffice']").removeClass("error");            
            $("#PostOffice_error").html("");
        }
               
        if(!PIN_Code)  {
          //  alert(PIN_Code);
            $("input[name='PIN_Code']").addClass("error");            
             $("#PIN_Code_error").html("Please enter the PIN Code");
        }else{
            $("input[name='PIN_Code']").removeClass("error");            
            $("#PIN_Code_error").html("");
        }
                
                Swal.fire("Please fill in all required fields.");
                event.preventDefault();
                return false;
 }

            if (dobYear < maxYear) {
                $("input[name='dob']").addClass("error");
                displayValidationError('Maximum age limit exceeded for the selected gender.');
                return false;
            }
            if (MasterCourse=='other')
{
            var ExtraMasterId =  $("select[name='ExtraMasterId']").val();
            var trainings =  $("select[name='trainings']").val();
            if (ExtraMasterId==""||trainings=="")
            {

                     if (ExtraMasterId==""){       
                           $("select[name='ExtraMasterId']").addClass("error");
                           $("#ExtraMasterId_error").html("Please enter the Other Master Course");           
                           
                     }else{
                        $("select[name='ExtraMasterId']").removeClass("error");
                        $("#ExtraMasterId_error").html("");         
                     }

                     if (trainings==""){
                        
                        $("select[name='trainings']").addClass("error");
                        $("#trainings_error").html("Please enter the trainings");
                              
                                 
                     }else{

                        $("select[name='trainings']").removeClass("error");
                        $("#trainings_error").html("");
                           
                     }

                     Swal.fire("Please fill in all required fields.");         
                     return false;        
                      event.preventDefault();
            }
    

    }else
    {
        $("select[name='ExtraMasterId']").removeClass("error"); 
        var trainings =  $("select[name='trainings']").val();

            if(trainings=="")
            {
               
               $("select[name='trainings']").addClass("error");
               $("#trainings_error").html("Please enter the trainings");
               Swal.fire("Please fill in all required fields.");
         
         return false;  
          event.preventDefault();
                      
          }else{

            $("select[name='trainings']").removeClass("error");
             $("#trainings_error").html("");
               
          }
         
}
            // Reset error classes and hide validation message on successful validation
            $("input[name='dob']").removeClass("error");
            $("input[name='gender']").removeClass("error");

           
           // $("input[name='ExtraMasterId']").removeClass("error");
           // validationMessage.hide();

            // Prevent default form submission
            event.preventDefault();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($("#AssignCourse")[0]);
            console.log(formData);
            $("#ajax-loader").show();

            $.ajax({
                
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
    url: "<?php echo e(route('AssignCourse')); ?>",
    type: "POST",
    data: formData,
    dataType: "json",
    processData: false,
    contentType: false,
    success: function (response) {
        //alert(response.status);
        if (response.status == "success") {
        //     Swal.fire("Interest Submited",response.message,"success");
        //    $("#myForm")[0].reset();
        //     $("#ajax-loader").hide();
        //     window.location.href = response.redirect;
            Swal.fire({
                        title: "Course Assigned",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#AssignCourse")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#AssignCourse")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
        } else{

            var errorMessage = "Something went wrong";

            if (response && response.message) {
                errorMessage = response.message;

            }

            Swal.fire("Failed", errorMessage, "error");

            $("#ajax-loader").hide();


}
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);
        console.log(JSON.parse(xhr.responseText).message);
        Swal.fire("Error", JSON.parse(xhr.responseText).message, "error");
        $("#ajax-loader").hide();
    }



});
    });
 // Prevent form submission for testing
 /*document.getElementById('AssignCourse').addEventListener('submit', function (event) {
        event.preventDefault();
        alert('Form submitted successfully!');
    });*/
////////////////////Placed for Candidate
$(document).ready(function() {
function handleCheckboxClick(value) {
   // alert(value);
              
              if (value == '5') {
                  $(".placed_emp").show();
                  $(".msg").show();
                  $(".upload_cv").hide();
                  $(".exstempselect").hide();
                  $(".newempselect").hide();  
              }

              if (value == '3') {
                  $(".upload_cv").show();
                  $(".msg").hide();
                  $(".newempselect").hide();  
                  $(".placed_emp").hide();
                  $(".exstempselect").hide();
              }
              if (value == '6') {
                $(".msg").show();
                  $(".upload_cv").hide();
                  $(".exstempselect").hide();
                  $(".newempselect").hide();                    
                 
                  $(".placed_emp").hide();
              }

              if (value == '16' || alue == '17') {
                  $(".upload_cv").hide();
                  $(".msg").show();
                  $(".newempselect").hide();  
                  $(".placed_emp").hide();
                  $(".exstempselect").hide();
              }
    }

    // Click event handler for Completed checkbox
    $('#course_completion_status').click(function() {
        if ($(this).is(':checked')) {
            
            handleCheckboxClick($(this).val());
        }
    });

   

    
});



    $(document).on("change","#sectordrop_candidate",function()
            {
                var status=$(this).val();
                var state=$(this).val();
                var status = document.getElementById('sectordrop_candidate');
                $("select[name='course_completion_status']").removeClass("error");
        $("#Jcourse_completion_status_error").html("");
       
                if (status.value == '5') {
                    $(".placed_emp").show();
                    $(".msg").show();
                    $(".upload_cv").hide();
                    $(".exstempselect").hide();
                    $(".newempselect").hide();  
                }

                if (status.value == '3') {
                    $(".msg").hide();
                    $(".upload_cv").show();
                    $(".newempselect").hide();  
                    $(".placed_emp").hide();
                    $(".exstempselect").hide();
                }
                if (status.value == '16' || status.value == '17'  ) {
                    $(".msg").show();
                    $(".upload_cv").hide();
                    $(".newempselect").hide();  
                    $(".placed_emp").hide();
                    $(".exstempselect").hide();
                }
                if (status.value == '6') {
                    $(".upload_cv").hide();
                    $(".exstempselect").hide();
                    $(".newempselect").hide();                    
                    $(".msg").show();
                    $(".placed_emp").hide();
                }
            });

            $(document).on("change","#fplacement",function()
            {
              
                var status = document.getElementById('fplacement');
              
                if (status.value == 'Yes') {
                    $(".countrydiv").show();
                   
                }

                if (status.value == 'No') {
                   
                    $(".countrydiv").hide();
                  
                }
               
            });
            $(document).on("change","#nfplacement",function()
            {
              
                var status = document.getElementById('nfplacement');
              
                if (status.value == 'Yes') {
                    $(".countrydiv").show();
                   
                }

                if (status.value == 'No') {
                   
                    $(".countrydiv").hide();
                  
                }
               
            });

            $(document).on("change", "input[type=radio][name=emp]", function () {
                // Get the selected radio button value
            var radVal = $("input[type=radio][name=emp]:checked").val();               
                if (radVal == '1') {
                    $(".exstempselect").show();
                    $(".newempselect").hide();
                }else
                {
                    $(".exstempselect").hide();
                    $(".newempselect").show();
                }

                
            });
            
        </script>


<script>                
    $('#sectordropdown_dist').on('change blur', function () {
    var DistrictId = this.value;
    var trids = $('#trids').val();
    var piaid = $('#piaid').val();
    var trids = JSON.parse(DistrictId);
   
    $.ajax({
        method: "GET",
        url: "/api/fetch-candiatelist/" + DistrictId,
        headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
    dataType:"JSON",
        data: { DistrictId: DistrictId,piaid:piaid },
        success: function (data) {
            $("#dataTable").DataTable().destroy();
            var trHTML = '';
            $("#tBody").empty();
            var baseurl = "<?php echo e(url("pia/candidateinterestdetview")); ?>";
           
            if (data.data.candidates.length > 0) {
            $.each(data.data.candidates, function (key, value) {
                var tids = value.training_program_id;
                var trainingProgramIds = JSON.parse(tids);
                var k = '';
               
/*
                $.each(trainingProgramIds, function (index, id) {
                    var intId = parseInt(id);
                    var matchingItem = $.grep(trids, function (item) {
                        return item.id === intId;
                    })[0];

                    if (matchingItem) {
                        k = '1';
                    }
                });
*/



                var candidateMasterIds = value.master_ids; // Assuming $candidate->master_ids is a comma-separated string
                var masters = data.data.masters;

                var isPresent = false;

                masters.forEach(function(id) {
                    if (candidateMasterIds.split(',').indexOf(id.toString()) !== -1) {
                        isPresent = true;
                        return false; // Break out of the loop if a match is found
                    }
                });

                if (isPresent) {
                    k = '1';
                } else {
                    // Master ID is not present
                    k = '0';
                }

                var i = parseInt(key) + 1;
                trHTML +=
                    '<tr' + (k === '1' ? ' style="background-color: lightblue;"' : '') + '><td>' + i + '</td><td>' +
                    value.name +
                    '</td><td>' +
                    value.email +
                    '</td><td>' +
                    value.mobile_Number +
                    '</td><td>' +
                    value.category +
                    '</td><td>' +
                   "<a href='" + baseurl + '/' + btoa(value.id) + "'><i class='fas fa-eye'></i></a>" +
    
                    '</td></tr>';
            });
            $("#dataTable").DataTable().destroy();
            $("#tBody").empty();
           
            $('#tBody').append(trHTML);
            $("#dataTable").DataTable();
            
        }else{
            $("#tBody").empty();
            $("#dataTable").DataTable().destroy();
           
                     
                    $('#tBody').append(trHTML);  
                    $("#dataTable").DataTable(); 
        }
      
            
           
        },
        /* error: function (xhr, status, error) {
            console.error(xhr.responseText);
        }*/
    });
});


$('#sectordropdown_distold').on('change blur', function () {
        //alert("Hi");
            var DistrictId = this.value;
            var disid = $('#disid').val();
          if (DistrictId==disid){
            $.ajax({
                    method: "GET",
                    url: "/api/fetch-candiatelist/" + DistrictId,
                    data: { DistrictId: DistrictId },
                    success: function (data) {    
                        //alert(data.trainigs); 
                        var trHTML = ''; 
                        $("#tBody").empty();  
                        var baseurl = "<?php echo e(url("pia/candidateinterestdetview")); ?>";    
                        
                        $.each(data.data.candidates, function (key, value) {    
                            //alert("Hi");  '<tr style="background-color: lightblue;"><td>'+ i +'</td><td>' + 
                            var i = parseInt(key)+1;                    
                            trHTML +=
                            '<tr style="background-color: lightblue;"><td>'+ i +'</td><td>' + 
                           
                                value.name +
                                '</td><td>' +
                                value.email +
                                '</td><td>' +
                                value.mobile_Number +
                                '</td><td>' +
                                value.category +
                                '</td><td>' +
                                "<a href='" + baseurl + '/' + btoa(value.id) + "'>View More</a>" +
                                '</td></tr>';
                        });
                        
        $('#tBody').append(trHTML);
    },
    /* error: function (xhr, status, error) {
        console.error(xhr.responseText);
    }*/
});

                     } else{

                    $.ajax({
                method: "GET",
                url: "/api/fetch-candiatelist/" + DistrictId,
                data: { DistrictId: DistrictId },
                success: function (data) {    
                    //alert(data.trainigs); 
                    var trHTML = ''; 
                    $("#tBody").empty();  
                    var baseurl = "<?php echo e(url("pia/candidateinterestdetview")); ?>";    
                    
                    $.each(data.data.candidates, function (key, value) {    
                        //alert("Hi");   
                        var i = parseInt(key)+1;                    
                        trHTML +=
                            '<tr><td>'+ i +'</td><td>' +
                            value.name +
                            '</td><td>' +
                            value.email +
                            '</td><td>' +
                            value.mobile_Number +
                            '</td><td>' +
                            value.category +
                            '</td><td>' +
                            "<a href='" + baseurl + '/' + btoa(value.id) + "'>View More</a>" +
                            '</td></tr>';
                    });
                    
        $('#tBody').append(trHTML);
    },
    /* error: function (xhr, status, error) {
        console.error(xhr.responseText);
    }*/
});


                }
    

        });


        function validate_cv() {
            
            document.getElementById('cvupload').addEventListener('keyup', function() {
                alert('hi');
var fileInput = this;
var errorMessage = document.getElementById('errorMessage');

// Check if a file is selected
if (fileInput.files.length > 0) {
var fileSize = fileInput.files[0].size; // Size in bytes
var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

if (fileSize > maxSize) {
  errorMessage.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
  errorMessage.style.color = 'red';
  // Clear the selected file
  fileInput.value = '';
} else {
  errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
  errorMessage.style.color = '#858796'; // Reset to default color
}
} else {
errorMessage.textContent = 'Only Pdf documents of maximum size of 2MB allowed';
errorMessage.style.color = '#858796'; // Reset to default color if no file selected
}
});
    }

    // Prevent form submission for testing
    document.getElementById('candidate_ChangeStatus').addEventListener('submit', function (event) {
        event.preventDefault();
        alert('Form submitted successfully!');
    });


            ///////////////////////////////////////////////////////
          
$('#candidate_Change_Status').click(function(event) {
            // Swal.fire('Form submitted!');
    
    var status =  $("select[name='course_completion_status']").val();
   // alert(status);
    if (status==""){
             
        $("select[name='course_completion_status']").addClass("error");
        $("#Jcourse_completion_status_error").html("Please select the Status");
        
       
        Swal.fire("Please fill in all required fields");
                return false;
          
     }else{
        $("select[name='course_completion_status']").removeClass("error");
        $("#Jcourse_completion_status_error").html("");
      
     }

     var msg_to_can =  $("textarea[name='msg_to_can']").val();
   // alert(msg_to_can);
    if (msg_to_can=="" && status!=3){
             
        $("textarea[name='msg_to_can']").addClass("error");
        $("#msg_to_can_error").html("Please provide message");
        
       
        Swal.fire("Please fill in all required fields");
                return false;
          
     }else{
        $("textarea[name='msg_to_can']").removeClass("error");
        $("#msg_to_can_error").html("");
      
     }


    if(status==3){
        var cvupload = $("#cvupload").val();

        if (!cvupload){             
               $("input[name='attachment']").addClass("error");
               $("#cv_error").html("Please Upload the CV");
               Swal.fire("Please upload the CV");
                return false;
        }else{
            $("input[name='attachment']").removeClass("error");
            $("#cv_error").html("");
        }
    }
    if(status==5)
    {
       
        var emp=$("input[name='emp']:checked").val();

        if (!emp){
             
                $("input[name='emp']").addClass("error");
                $("#emp_error").html("Please Select Employer type");
                Swal.fire("Please fill in all required field");
                return false;
        }else{
            $("input[name='emp']").removeClass("error");
            $("#emp_error").html("");
        }
        if (emp==1){
            //existemp
            var empid =  $("select[name='empid']").val();
            var jlocation = $("#jlocation").val();
            var fplacement =  $("select[name='fplacement']").val();
           
            if(fplacement=='Yes'){
                
               
                var country =  $("select[name='country']").val();
                if (!country){
                    $("select[name='country']").addClass("error");
                    $("#country_error").html("Please Select Country");
                Swal.fire("Please fill in all required fields");
                return false;
            }else{
                $("select[name='country']").removeClass("error");
                $("#country_error").html("");
            }

            }
            var salary = $("#salary").val();
            var jdate = $("#jdate").val();
            var job = $("#job").val();
            var msg_to_can =  $("textarea[name='msg_to_can']").val();
            
            
           
           if (!empid||!salary||!jdate||!fplacement||!jlocation||!job||!msg_to_can){
               
                $("select[name='fplacement']").addClass("error");
                $("select[name='empid']").addClass("error");
                $("select[name='job']").addClass("error");
                $("input[name='salary']").addClass("error");
                $("input[name='jdate']").addClass("error");      
                $("input[name='jlocation']").addClass("error");
               // $("input[name='msg_to_can']").addClass("error");
                $("textarea[name='msg_to_can']").addClass("error");

                if(!fplacement){
                    $("select[name='fplacement']").addClass("error");
                    $("#fplacement_error").html("Please Select Foreign placement");
               
                }else{
                    $("select[name='fplacement']").removeClass("error");
                    $("#fplacement_error").html("");
                }

                if(!empid){
                    $("select[name='empid']").addClass("error");
                    $("#empid_error").html("Please Select Employer");
               
                }else{
                    $("select[name='empid']").removeClass("error");
                    $("#empid_error").html("");
                }

                if(!job){
                    $("select[name='job']").addClass("error");
                    $("#job_error").html("Please Select job");
               
                }else{
                    $("select[name='job']").removeClass("error");
                    $("#job_error").html("");
                }

                if(!salary){
                    $("input[name='salary']").addClass("error");
                    $("#salary_error").html("Please enter salary");
               
                }else{
                    $("input[name='salary']").removeClass("error");
                    $("#salary_error").html("");
                }
                if(!msg_to_can){
                   // $("input[name='msg_to_can']").addClass("error");
                    $("textarea[name='msg_to_can']").addClass("error");

                    $("#msg_to_can_error").html("Please Provide message");
               
                }else{
                    //$("input[name='msg_to_can']").removeClass("error");
                    $("textarea[name='msg_to_can']").removeClass("error");

                    $("#msg_to_can_error").html("");
                }
                
                if(!jdate){
                    $("input[name='jdate']").addClass("error");
                    $("#jdate_error").html("Please enter Joining Date");
               
                }else{
                    $("input[name='jdate']").removeClass("error");
                    $("#jdate_error").html("");
                }
                if(!jlocation){
                    $("input[name='jlocation']").addClass("error");
                    $("#JLocation_error").html("Please enter Location");
               
                }else{
                    $("input[name='jlocation']").removeClass("error");
                    $("#JLocation_error").html("");
                }
                Swal.fire("Please fill in all required fields");
                return false;
            }
        }
        if(emp==2)
        {
            //new emp
            
            var employer_name =  $("#employer_name").val();
            var pan_number = $("#pan_number").val();
            var njob =  $("#njob").val();
            var njlocation = $("#njlocation").val();
            var category = $("#category").val();
            var nsalary = $("#nsalary").val();            
            var njdate = $("#njdate").val();
            var nemail = $("#nemail").val();
            var nfplacement =  $("select[name='nfplacement']").val();
            var msg_to_can = $("#msg_to_can").val();
            
            if(nfplacement=='Yes'){
                
               
                var country =  $("select[name='ncountry']").val();
                if (!country){
                    $("select[name='ncountry']").addClass("error");
                    $("#ncountry_error").html("Please Select Country");
                    Swal.fire("Please fill in all required fields");
                    return false;
                }else{
                    $("select[name='ncountry']").removeClass("error");
                    $("#ncountry_error").html("");
                }

            }
            
           
           if (!msg_to_can||!nemail||!employer_name||!pan_number||!nsalary||!njdate||!nfplacement||!njlocation||!njob||!category){
               
                $("select[name='nfplacement']").addClass("error");
                $("input[name='nemail']").addClass("error");
                $("input[name='njob']").addClass("error");
                $("input[name='pan_number']").addClass("error");
                $("input[name='employer_name']").addClass("error");
                $("input[name='nsalary']").addClass("error");
                $("input[name='njdate']").addClass("error");           
                $("input[name='njlocation']").addClass("error");                     
                $("input[name='category']").addClass("error");
//$("input[name='msg_to_can']").addClass("error");
                $("textarea[name='msg_to_can']").addClass("error");


                if(!nfplacement){
                    $("select[name='nfplacement']").addClass("error");
                    $("#nfplacement_error").html("Please Select Foreign placement");
               
                }else{
                    $("select[name='nfplacement']").removeClass("error");
                    $("#nfplacement_error").html("");
                }
                if(!category){
                    $("input[name='category']").addClass("error");
                    $("#category_error").html("Please enter category");
               
                }else{
                    $("input[name='category']").removeClass("error");
                    $("#category_error").html("");
                }
                if(!msg_to_can){
//$("input[name='msg_to_can']").addClass("error");
                    $("textarea[name='msg_to_can']").addClass("error");

                    $("#msg_to_can_error").html("Please enter message");
               
                }else{
                   // $("input[name='msg_to_can']").removeClass("error");
                    $("textarea[name='msg_to_can']").removeClass("error");

                    $("#msg_to_can_error").html("");
                }

                if(!nemail){
                   
                    $("input[name='nemail']").addClass("error");
                    $("#nemail_error").html("Please enter Email Id");
               
                }else{
                    
                    $("input[name='nemail']").removeClass("error");
                    $("#nemail_error").html("");
                }

                if(!njob){
                    $("input[name='njob']").addClass("error");
                  
                    $("#njob_error").html("Please enter job");
               
                }else{
                   ;
                    $("input[name='njob']").removeClass("error");                  
                    $("#njob_error").html("");
                }

                if(!nsalary){
                    $("input[name='nsalary']").addClass("error");
                    $("#nsalary_error").html("Please enter salary");
               
                }else{
                    $("input[name='nsalary']").removeClass("error");
                    $("#nsalary_error").html("");
                }
                
                if(!pan_number){
                    $("input[name='pan_number']").addClass("error");
                    $("#pan_number_error").html("Please enter Pan Number");
               
                }else{
                    $("input[name='pan_number']").removeClass("error");
                    $("#pan_number_error").html("");
                }
                if(!employer_name){
                    $("input[name='employer_name']").addClass("error");
                    $("#employer_name_error").html("Please enter Employer Name");
               
                }else{
                    $("input[name='employer_name']").removeClass("error");
                    $("#employer_name_error").html("");
                }
                if(!njdate){
                    $("input[name='njdate']").addClass("error");
                    $("#njdate_error").html("Please Enter Joining Date");
               
                }else{
                    $("input[name='njdate']").removeClass("error");
                    $("#njdate_error").html("");
                }

                if(!category){
                    $("input[name='category']").addClass("error");
                    $("#ncategoryerror").html("Please Enter Category");
               
                }else{
                    $("input[name='category']").removeClass("error");
                    $("#category_error").html("");
                }
                if(!njlocation){
                    $("input[name='njlocation']").addClass("error");
                    $("#njlocation_error").html("Please Enter Joining Location");
               
                }else{
                    $("input[name='njlocation']").removeClass("error");
                    $("#njlocation_error").html("");
                }

                Swal.fire("Please fill in all required fields");
                return false;
            }

           
        }
     }
    
     $("#ajax-loader").show();

     
            // Prevent default form submission
            event.preventDefault();

            // Get form data
            //var formData = $("#myForm").serialize();
            var formData = new FormData($("#candidate_ChangeStatus")[0]);
            formData.append('attachment',$(this)[0].files);
            console.log(formData);
            

            $.ajax({
                
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
    url: "<?php echo e(route('candidate_ChangeStatus')); ?>",
    type: "POST",
    data: formData,
    dataType: "json",
    processData: false,
    contentType: false,
    success: function (response) {
        //alert(response.status);
        if (response.status == "success") {
        //     Swal.fire("Interest Submited",response.message,"success");
        //    $("#myForm")[0].reset();
            $("#ajax-loader").hide();
        //     window.location.href = response.redirect;
            Swal.fire({
                        title: "Candidate Status Changed Successfully",
                        text: response.message,
                         icon: "success"
                    }).then((result) => {
                      if (result.isConfirmed) {
                         // User clicked "OK" button
                        $("#candidate_ChangeStatus")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     } else {
         
                        $("#candidate_ChangeStatus")[0].reset();
                         $("#ajax-loader").hide();
                         window.location.href = response.redirect;
                     }
                    });
        } else{

            var errorMessage = "Something went wrong";

            if (response && response.message) {
                errorMessage = response.message;

            }

            Swal.fire("Failed", errorMessage, "error");

            $("#ajax-loader").hide();


}
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);
        console.log(JSON.parse(xhr.responseText).message);
        Swal.fire("Error", JSON.parse(xhr.responseText).message, "error");
        $("#ajax-loader").hide();
    }



});
    });

</script>

<script>

    $(document).ready(function()
    {
        $(document).on("submit","#change_password_form",function(e)
        {
            e.preventDefault();

            var old_password=$("#old_password").val();
            var new_password=$("#new_password").val();
            var confirm_password=$("#confirm_password").val();

            var form_data=new FormData($(this)[0]);

            if(old_password)
            {

                
                var old_password=$("#old_password").val();

                $.ajax({
                    headers:{'X-CSRF-TOKEN':"<?php echo e(csrf_token()); ?>"},
                    url:"<?php echo e(route('checkCurrentPassword')); ?>",
                    type:"POST",
                    data:{password:old_password},
                    dataType:"JSON",
                    success:function(response)
                    {
                        if(response.password_match_status==0)
                        {
                            $("#old_password_error").html("Current password is invalid");
                            $("#old_password").addClass("error");

                        }

                        else{

                            $("#old_password_error").html("");
                            $("#old_password").removeClass("error");

                        }
                    },
                    error:function()
                    {

                    }
                });

            }

            if(!old_password || !new_password || !confirm_password)
            {
                Swal.fire("error","Please fill all mandatory fields","error");

               

                if(!old_password)
                {
                    $("#old_password_error").html("Enter old password");
                    $("#old_password").addClass("error");
                }

                else{

                }

                if(!new_password)
                {
                    $("#new_password_error").html("Enter new password");
                    $("#new_password").addClass("error");
                }

                if(!confirm_password)
                {
                    $("#confirm_password_error").html("Enter confirm password");
                    $("#confirm_password").addClass("error");
                }

               
            }

           
            

            else if(old_password && confirm_password && new_password){

                if(confirm_password!=new_password){
                        
                        $("#confirm_password_error").html("New password and confirm password do not match");


                }

                else if(old_password==new_password){
                    $("#confirm_password_error").html("New password cannot be the same as the old password!");
                    $("#new_password").addClass("error");

                }else if(old_password==confirm_password){
                    $("#confirm_password_error").html("Confirm password cannot be the same as the old password!");
                    $("#confirm_password").addClass("error");

                }

                else{

                    $.ajax({

                        url:"<?php echo e(route('changePassword')); ?>",
                        type:"POST",
                        data:form_data,
                        dataType:"JSON",
                        processData:false,
                        contentType:false,
                        success:function(response)
                        {
                            if(response.status=="success")
                            {
                                Swal.fire("Success",response.message,"success").then(function(result)
                                {
                                    if(result.isConfirmed)
                                    {
                                        window.location.reload();
                                    }
                                });

                                
                            }

                            else{

                                Swal.fire("Error",response.message,"error");


                            }
                        },
                        error:function()
                        {
                            Swal.fire("error","Smething went wrong","error");
                        }
                    });


                }


            }

        });
       
         $(document).on("keyup","#trainings",function()
        {
            $("select[name='trainings']").removeClass("error");
                        $("#trainings_error").html("");
        });

        $(document).on("keyup","#old_password",function()
        {
            $("#old_password").removeClass("error");
            $("#old_password_error").html("");
        });

        $(document).on("keyup","#new_password",function()
        {
            $("#new_password").removeClass("error");
            $("#new_password_error").html("");
        });

        $(document).on("keyup","#confirm_password",function()
        {
            $("#confirm_password").removeClass("error");
            $("#confirm_password_error").html("");
        });
    });


</script>
<script>

// $(document).ready(function()
// {
//     document.getElementById('cvupload').addEventListener('change', handleFileChange);

// function handleFileChange() {
//   console.log('Inside handleFileChange function');

//   var fileInput = document.getElementById('cvupload');
//   var errorMessageContainer = document.getElementById('errorMessageContainer');
//   var errorMessagedoc = document.getElementById('errorMessagedoc');

//   // Check if a file is selected
//   if (fileInput.files && fileInput.files.length > 0) {
//     console.log('File selected');

//     var fileSize = fileInput.files[0].size; // Size in bytes
//     var maxSize = 2 * 1024 * 1024; // 2 MB in bytes

//     console.log('File size:', fileSize, 'bytes');

//     if (fileSize > maxSize) {
//       console.log('File size exceeds the allowed limit');
//       errorMessagedoc.textContent = 'File size exceeds the allowed limit (2 MB). Please choose a smaller file.';
//       errorMessagedoc.style.color = 'red';
//       // Clear the selected file
//       fileInput.value = '';

//       // Display the error message container
//       errorMessageContainer.style.display = 'block';
//     } else {
//       console.log('File size within limit');
//       errorMessagedoc.textContent = 'Only Pdf documents of a maximum size of 2MB allowed';
//       errorMessagedoc.style.color = '#858796'; // Reset to default color if no file selected
//     }
//   } else {
//     console.log('No file selected');
//     errorMessagedoc.textContent = 'Only Pdf documents of a maximum size of 2MB allowed';
//     errorMessagedoc.style.color = '#858796'; // Reset to default color if no file selected
//   }
// }


// });


// </script>

<script>

function togglePasswordVisibilityOldPassword()
{
    var old_password=document.getElementById("old_password");

    if(old_password.type=="text")
    {
        $("#old_password").attr("type","password");
    }

    else{

        $("#old_password").attr("type","text");
    }
}

function togglePasswordVisibilityNewPassword()
{
    var new_password=document.getElementById("new_password");

    if(new_password.type=="text")
    {
        $("#new_password").attr("type","password");
    }

    else{

        $("#new_password").attr("type","text");
    }
}

function togglePasswordVisibilityConfirmPassword()
{
    var confirm_password=document.getElementById("confirm_password");

    if(confirm_password.type=="text")
    {
        $("#confirm_password").attr("type","password");
    }

    else{

        $("#confirm_password").attr("type","text");
    }
}


</script>

    
<script>
    var today = new Date();
    var afterTwoDays = new Date(today);
    afterTwoDays.setDate(today.getDate() + 3);
    var minDate = afterTwoDays.toISOString().split('T')[0];

    document.getElementById('jdate').setAttribute('min', minDate);
    document.getElementById('njdate').setAttribute('min', minDate);
</script>

<!-- End add candidate -->
</body>

</html><?php /**PATH /var/www/html/Kudumbashree_TrainingCourses/resources/views/pia/layouts/app.blade.php ENDPATH**/ ?>