<?php $__env->startSection('title','Course Master List'); ?>

<?php $__env->startSection('content'); ?>


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Course Master List </h1>
            <a href="<?php echo e(route('createCourseMaster')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> New Course Master</a>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Sector Name</th>
                                        <th>Trade Code</th>
                                        <th>Trade Name</th>
                                        <th>Duration</th>
                                        <th>Qualification</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>


                                <?php $__currentLoopData = $courseMaster_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$Course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(($key+1)); ?></td>
                                        <td><?php echo e($Course->Sector->name); ?></td>
                                        <td><?php echo e($Course->tradecode); ?></td>
                                        <td><?php echo e($Course->tradename); ?></td>
                                        <td><?php echo e($Course->duration); ?></td>
                                        <td><?php echo e($Course->qualification); ?></td>
                                        <td>
            <span class="description">
                <?php echo e(Str::limit($Course->description, 50)); ?>

                <span class="more-text d-none"><?php echo e(substr($Course->description, 50)); ?></span>
            </span>
            <?php if(strlen($Course->description) > 50): ?>
                <a href="javascript:void(0)" class="view-more-btn">View More</a>
            <?php endif; ?>
        </td>
                                        <td>

                                            <a href="<?php echo e(route('viewCourseMaster',['Course'=>base64_encode($Course->id)])); ?>" class="btn btn-info btn-circle btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                               
                                                   <?php if($Course->is_active==1): ?>
                                                        <a href="<?php echo e(route('editCourseMaster',['Course'=>base64_encode($Course->id)])); ?>" class="btn btn-success btn-circle btn-sm"  title="Edit">
                                                            <i class="fas fa-pen"></i>
                                                        </a>

                                                    <?php endif; ?>
                                                <?php if($Course->is_active==1): ?>
                                                    <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-course" data-course-id="<?php echo e(base64_encode($Course->id )); ?>"  title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </a>

                                                <?php elseif($Course->is_active==11): ?>

                                                    <a href="#" class="reactivate-pia" data-pia-id="<?php echo e(base64_encode($Course->id )); ?>"  title="Reactivate">
                                        
                                                    </a>

                                                <?php endif; ?>

                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->
<script>
    document.addEventListener('DOMContentLoaded', function () {
    const viewMoreButtons = document.querySelectorAll('.view-more-btn');

    viewMoreButtons.forEach(button => {
        button.addEventListener('click', function () {
            const moreText = this.previousElementSibling.querySelector('.more-text');
            moreText.classList.toggle('d-none');

            this.textContent = moreText.classList.contains('d-none') ? 'View More' : 'View Less';
        });
    });
});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Kudumbashree_TrainingCourses/resources/views/admin/courseMaster/list.blade.php ENDPATH**/ ?>