<?php

use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\SkillController;
use App\Http\Controllers\Admin\TrainingProgrammeController;
use App\Http\Controllers\Candidates\CandidatesController;
use App\Http\Controllers\Candidates\NotificationController;
use App\Http\Controllers\Employer\EmployerCandidateController;
use App\Http\Controllers\Employer\PlacementController;
use App\Http\Controllers\Employer\RecruitmentController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\CommonController;
use App\Http\Controllers\PublicSite\RequestInterest;
use App\Http\Controllers\PublicSite\CourseList;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\Admin\PIAController;
use App\Http\Controllers\Admin\coursescontroller;
use App\Http\Controllers\Pia\CandidateInterestController;
use App\Http\Controllers\PublicSite\ContactUsController;
use App\Http\Controllers\Admin\EmployerController;
use App\Http\Controllers\Admin\SectorController;
use App\Http\Controllers\Admin\CourseMasterController;
use App\Http\Controllers\Admin\JobVacancyController;
use App\Http\Controllers\Admin\CandidateController;
use App\Http\Controllers\Employer\CandidateInterestEmpController;
use App\Http\Controllers\PublicSite\HomeController;
use App\Http\Controllers\Candidates\JobApplicationController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
////////////Login Module



Route::get('/loginView', [LoginController::class, 'loginView'])->name('login');
Route::get('/forgot-password', [LoginController::class, 'forgotPassword'])->name('forgotPassword');
Route::post('/request-password-reset', [LoginController::class, 'requestPasswordReset'])->name('requestPasswordReset');
Route::get('/otp-password-reset/{id?}', [LoginController::class, 'otpPasswordReset'])->name('otpPasswordReset');
Route::post('/submit-password-reset-request', [LoginController::class, 'submitPasswordResetRequest'])->name('submitPasswordResetRequest');
Route::get('/logout', [LoginController::class, 'logout']);
Route::get('/pwdhash', [LoginController::class, 'pwdhash']);
Route::post('/loginView', [LoginController::class, 'loginCheck']);
Route::post('/encryptPassword', [LoginController::class, 'encryptPassword']);
/** Routes for admin PIA Module */
Route::prefix('admin')->middleware(['pia_access_auth', 'auth'])->group(function () {
    Route::get('/pia-list', [PIAController::class, 'piaList'])->name('piaList');
    Route::get('/create-pia', [PIAController::class, 'createPIA'])->name('createPIA');
    Route::post('/load-blocks', [PIAController::class, 'loadBlocks'])->name('loadBlocks');
    Route::post('/submit-pia-details', [PIAController::class, 'submitPIADetails'])->name('submitPIADetails');
    Route::get('/edit-pia/{pia?}', [PIAController::class, 'editPIA'])->name('editPIA');
    Route::post('/update-pia-details', [PIAController::class, 'updatePIADetails'])->name('updatePIADetails');
    Route::get('/view-pia/{pia?}', [PIAController::class, 'viewPIA'])->name('viewPIA');
    Route::post('/deactivate-pia', [PIAController::class, 'deactivatePIA'])->name('deactivatePIA');
    Route::match(['get','post'],'/get-trades-by-sector', [PIAController::class, 'getTradesBySector'])->name('getTradesBySector');
   // Route::post('/get-trades-by-sector', [PIAController::class, 'getTradesBySector'])->name('getTradesBySector');
    //Route::get('/fetch-trades-by-sectors', [PIAController::class, 'fetchTradesBySectors'])->name('fetchTradesBySectors');
    Route::get('/get-trades', [PIAController::class, 'getTrades']);



    /** Routes for superadmin Employer module */



});

Route::prefix('admin')->middleware(['super_auth'])->group(function () {
    Route::get('/add-sector', [SectorController::class, 'addSector'])->name('adminAddSector');
    Route::post('/submit-sector', [SectorController::class, 'submitSector'])->name('adminSubmitSector');
    Route::get('/edit-sector/{sector?}', [SectorController::class, 'editSector'])->name('adminEditSector');
    Route::post('/update-sector', [SectorController::class, 'updateSector'])->name('adminUpdateSector');
    Route::get('/candidate_report', [ReportController::class, 'CandidateReportView'])->name('CandidateReportView');
    Route::get('/training_programs_report', [ReportController::class, 'training_programs'])->name('TrainingPrograms');
    Route::get('/generate-report/training-programs', [ReportController::class, 'generateTrainingProgramReport'])->name('generateTrainingProgramReport');
    Route::post('/pia_course_by_district', [ReportController::class, 'getPiaCourseByDistrict'])->name('getPiaCourseByDistrict');
});

Route::prefix('common')->middleware(['auth'])->group(function () {

    Route::post('/load-states', [PIAController::class, 'loadStates'])->name('loadStates');
    Route::post('/load-districts', [PIAController::class, 'loadDistricts'])->name('loadDistricts');

});


Route::prefix('admin')->middleware(['auth', 'admin_all_auth'])->group(function () {

    Route::get('/employer-list', [EmployerController::class, 'employerListForAdmin'])->name('adminEmployerList');
    Route::get('/view-employer-details/{id?}', [EmployerController::class, 'viewEmployer'])->name('adminViewEmployer');
    Route::get('/deactivated-employers-list', [EmployerController::class, 'deactivatedEmployersList'])->name('adminDeactivatedEmployersList');
    Route::get('/approval-pending-employers-list', [EmployerController::class, 'approvalPendingEmployersList'])->name('adminApprovalPendingEmployersList');
    /*******************************************Admin CourseMaster**************************************** */
    Route::get('/CourseMaster-list', [CourseMasterController::class, 'CourseMasterList'])->name('CourseMasterList');
    Route::get('/view-course-master/{Course?}', [CourseMasterController::class, 'viewCourseMaster'])->name('viewCourseMaster');
    Route::get('/edit-course-master/{Course?}', [CourseMasterController::class, 'editCourseMaster'])->name('editCourseMaster');
    Route::post('/update-course-master-details', [CourseMasterController::class, 'updateCourseMasterDetails'])->name('updateCourseMasterDetails');
    Route::get('/create-course-master', [CourseMasterController::class, 'createCourseMaster'])->name('createCourseMaster');
    Route::post('/submit-course-master-details', [CourseMasterController::class, 'submitCourseMasterDetails'])->name('submitCourseMasterDetails');
    Route::post('/deactivate-course-fromlist', [CourseMasterController::class, 'deactivateCoursebyId'])->name('deactivateCourseFromList');
    Route::get('/skill-list', [SkillController::class, 'SkillList'])->name('SkillList');
    Route::get('/view-skill/{Skill?}', [SkillController::class, 'viewSkill'])->name('viewSkill');
    Route::get('/create-skill', [SkillController::class, 'createSkill'])->name('createSkill');
    Route::post('/submit-skill-details', [SkillController::class, 'submitSkillDetails'])->name('submitSkillDetails');
    Route::get('/edit-skill-master/{Skill?}', [SkillController::class, 'editSkill'])->name('editSkill');
    Route::post('/update-skill-details', [SkillController::class, 'updateSkillDetails'])->name('updateSkillDetails');
    Route::get('/training-programme-list', [TrainingProgrammeController::class, 'TrainingProgrammeList'])->name('TrainingProgrammeList');
    Route::get('/view-training-programme/{Training?}', [TrainingProgrammeController::class, 'viewTrainingProgramme'])->name('viewTrainingProgramme');
    Route::post('/training-programme/approve/{id}', [TrainingProgrammeController::class, 'approve'])->name('training.approve');

    /*******************************************End Admin CourseMaster**************************************** */

    /*******************Candidate List************ */


    Route::post('/deactivateUser/', [CandidateController::class, 'deactivateUser'])->name('deactivateUser');

    Route::post('/deactivateCandidate/', [CandidateController::class, 'deactivateCandidate'])->name('deactivateCandidate');
    /*******************Candidate List************ */
    Route::get('/candidateallist', [CandidateController::class, 'candidateList'])->name('candidateallist');
    Route::get('/candidateListDet/{type}/{id}', [CandidateController::class, 'candidateListDet'])->name('candidateListDet');
    Route::get('/candidatejoinedList', [CandidateController::class, 'candidatejoinedList'])->name('candidatejoinedList');
    Route::get('/candidatejoinedListDet/{type}/{id}', [CandidateController::class, 'candidatejoinedListDet'])->name('candidatejoinedListDet');

});



Route::prefix('admin')->middleware(['employer-access-auth', 'auth'])->group(function () {

    //  Route::get('/employer-list', [EmployerController::class, 'employerListForAdmin'])->name('adminEmployerList');
    Route::get('/add-employer', [EmployerController::class, 'addEmployer'])->name('adminAddEmployer');


    Route::post('/approve-employer', [EmployerController::class, 'approveEmployer'])->name('adminApproveEmployer');
    Route::post('/reject-employer', [EmployerController::class, 'rejectEmployer'])->name('adminRejectEmployer');



    Route::get('/edit-employer/{id?}', [EmployerController::class, 'editEmployer'])->name('adminEditEmployer');
    Route::post('/update-employer-details', [EmployerController::class, 'updateEmployerDetails'])->name('adminUpdateEmployerDetails');
    Route::post('/deactivate-employer', [EmployerController::class, 'deactivateEmployer'])->name('adminDeactivateEmployer');

    Route::get('/open-employer-updation-requests', [EmployerController::class, 'openEmployerUpdationRequests'])->name('adminOpenEmployerUpdationRequests');
    Route::get('/employer-updation-request/{id?}', [EmployerController::class, 'employerUpdationRequest'])->name('adminEmployerUpdationRequest');
    Route::post('/process-employer-update-request', [EmployerController::class, 'processUpdateRequest'])->name('adminProcessEmployerUpdateRequest');



});

Route::prefix('admin')->middleware(['super_auth'])->group(function () {

    Route::post('/reactivate-employer', [EmployerController::class, 'reactivateEmployer'])->name('adminReactivateEmployer');
    Route::post('/reactivate-pia', [PIAController::class, 'reactivatePia'])->name('adminReactivatePia');
    Route::get('/blocked-pia-list', [PIAController::class, 'blockedPIAList'])->name('adminBlockedPiaList');

});

/*Route::middleware(['auth', 'employer-access-auth'])->group(function () {
   
});*/

Route::prefix('pia')->middleware(['pia_auth', 'auth'])->group(function () {

    Route::get('/employer-list', [EmployerController::class, 'employerList'])->name('piaEmployerList');
    Route::get('/add-employer', [EmployerController::class, 'addEmployer'])->name('piaAddEmployer');
    Route::post('/submit-employer-details', [EmployerController::class, 'submitEmployerDetails'])->name('piaSubmitEmployerDetails');
    Route::get('/view-employer-details/{id?}', [EmployerController::class, 'viewEmployer'])->name('piaViewEmployer');
    Route::get('/edit-employer/{id?}', [EmployerController::class, 'editEmployer'])->name('piaEditEmployer');
    Route::get('/add-candidate', [CandidateInterestController::class, 'createCandidate'])->name('piaAddCandidate');
    Route::post('/submit-employer-details', [EmployerController::class, 'submitEmployerDetails'])->name('adminSubmitEmployerDetails');
    Route::post('/update-employer-details', [EmployerController::class, 'updateEmployerDetails'])->name('UpdateEmployerDetails');
    Route::get('/rejected-employers', [EmployerController::class, 'rejectedEmployersList'])->name('piaRejectedEmployers');
    Route::get('/pending-employers', [EmployerController::class, 'pendingEmployersList'])->name('piaPendingEmployers');

});

Route::prefix('admin')->middleware(['auth', 'super_auth'])->group(function () {
    /*   Route::get('/employer-list', [EmployerController::class, 'employerListForAdmin'])->name('employerListForAdmin');
       Route::post('/approve-employer', [EmployerController::class, 'approveEmployer'])->name('adminApproveEmployer');*/
});

Route::prefix('admin')->middleware(['super_auth', 'auth'])->group(function () {

    /*******************************************Admin Sector**************************************** */
    Route::get('/Sector-list', [SectorController::class, 'sectorList'])->name('sectorList');
    /*******************************************End Admin Sector**************************************** */


});



Route::group(['middleware' => 'login_auth'], function () {  //all users

});
Route::group(['middleware' => 'admin_all_auth'], function () {
    Route::get('/app-admin/dashboard', [App\Http\Controllers\Admin\CommonController::class, 'dashboard'])->name('dashboard');  // 3 admins
    Route::get('/app-admin/training/list', [App\Http\Controllers\Admin\CommonController::class, 'training_list'])->name('training_list');
    Route::get('/app-admin/admin/create', [App\Http\Controllers\Admin\CommonController::class, 'admin_create'])->name('admin_create');
    Route::get('/app-admin/admin/list', [App\Http\Controllers\Admin\CommonController::class, 'admin_list'])->name('admin_list');
    Route::post('/app-admin/admin_create_submit', [App\Http\Controllers\Admin\CommonController::class, 'admin_create_submit'])->name('admin_create_submit');
    Route::post('/app-admin/admin_form_block_list', [App\Http\Controllers\Admin\CommonController::class, 'admin_form_block_list'])->name('admin_form_block_list');
    Route::post('/deactivate-admin', [App\Http\Controllers\Admin\CommonController::class, 'deactivateAdmin'])->name('deactivateAdmin');
    Route::get('/edit-admin/{id}', [CommonController::class, 'editAdmin'])->name('EditAdmin');
    Route::post('/update-admin-details', [CommonController::class, 'updateAdminDetails'])->name('UpdateAdminDetails');
    Route::post('/update-admin-details-inavtive', [CommonController::class, 'UpdateInactiveAdminDetails'])->name('UpdateInactiveAdminDetails');
    Route::get('/app-admin/admin/list/inctive', [App\Http\Controllers\Admin\CommonController::class, 'admin_list_inactive'])->name('admin_list_inactive');
    Route::get('/edit-admin/inactive/{id}', [CommonController::class, 'editAdminInactive'])->name('editAdminInactive');
});

/** Routes for admin courses Module */

Route::prefix('admin')->group(function () {

});


Route::group(['middleware' => 'super_auth'], function () {

});
Route::group(['middleware' => 'dstrict_auth'], function () {

});
Route::group(['middleware' => 'block_auth'], function () {

});

Route::prefix('pia')->middleware(['auth', 'pia_auth'])->group(function () {

    Route::get('/add-candidate-interest', [CandidateInterestController::class, 'addCandidateInterest'])->name('piaAddCandidateInterest');
    Route::post('/submit-candidate-details', [CandidateInterestController::class, 'submitCandidateDetails'])->name('piaSubmitCandidateDetails');

});

Route::middleware(['auth'])->group(function () {
    Route::post('/change-password', [LoginController::class, 'changePassword'])->name('changePassword');
});


Route::group(['middleware' => 'pia_auth'], function () {
    Route::get('/pia/dashboard', [App\Http\Controllers\Pia\PiaController::class, 'dashboard'])->name('pia-dashboard');
    Route::get('/pia/profile', [App\Http\Controllers\Pia\PiaController::class, 'profile'])->name('pia-profile');
    Route::get('/pia/candidateinterest', [CandidateInterestController::class, 'candidateInterestList'])->name('candidateInterestList');
    Route::get('/pia/candidateInterestJoinedList', [CandidateInterestController::class, 'candidateInterestJoinedList'])->name('candidateInterestJoinedList');

    Route::post('/candidate_ChangeStatus', [CandidateInterestController::class, 'candidate_ChangeStatus'])->name('candidate_ChangeStatus');
    Route::match(['get', 'post'], '/pia/loadJobs', [CandidateInterestController::class, 'loadJobs'])->name('loadJobs');

    Route::get('/pia/candidateInterestJoinedListDet/{id}', [CandidateInterestController::class, 'candidateInterestJoinedListDet'])->name('candidateInterestJoinedListDet');
    Route::match(['get', 'post'], '/pia/CheckSeatsCount', [CandidateInterestController::class, 'CheckSeatsCount'])->name('CheckSeatsCount');
    Route::match(['get', 'post'], '/pia/AlreadyExistEmail', [CandidateInterestController::class, 'AlreadyExistEmail'])->name('AlreadyExistEmail');


    Route::post('/pia/AssignCourseJoined', [CandidateInterestController::class, 'AssignCourseJoined'])->name('AssignCourseJoined');

    Route::get('/pia/candidateinterestdetview/{id}', [CandidateInterestController::class, 'candidateInterestListDet'])->name('candidateInterestView');
    Route::match(['get', 'post'], '/pia/loadTrainings', [CandidateInterestController::class, 'loadTrainings'])->name('loadTrainings');
    Route::post('/pia/AssignCourse', [CandidateInterestController::class, 'AssignCourse'])->name('AssignCourse');
    Route::get('/pia/course-list', [coursescontroller::class, 'index'])->name('courseList');
    Route::get('/pia/create-course', [coursescontroller::class, 'create'])->name('createcourse');
    Route::post('/pia/submit-course-details', [coursescontroller::class, 'store'])->name('submitCourseDetails');
    Route::get('/pia/edit-course/{course?}', [coursescontroller::class, 'edit'])->name('editcourse');
    Route::post('/pia/update-training-details', [coursescontroller::class, 'updateTrainingDetails'])->name('updateTrainingDetails');
    Route::post('/pia/update-course-details/{course?}', [coursescontroller::class, 'update'])->name('updateCourseDetails');
    Route::get('/pia/view-course/{course?}', [coursescontroller::class, 'viewTraining'])->name('viewCourse');
    Route::post('/pia/deactivate-training-programme', [coursescontroller::class, 'deactivateTrainingProgramme'])->name('deactivateTrainingProgramme');
    Route::post('/deactivate-courseMaser', [CourseMasterController::class, 'deactivateCourseMaster'])->name('deactivateCourseMaster');
    Route::post('/deactivate-course', [coursescontroller::class, 'deactivateCourse'])->name('deactivateCourse');
    
Route::post('/fetch-duration', [coursescontroller::class, 'fetchDuration'])->name('fetch.duration');
Route::get('/candidate_report', [ReportController::class, 'CandidateReportView'])->name('CandidateReportView_pia');
    Route::get('/CandidatesReports', [ReportController::class, 'CandidatesReport_Pia'])->name('CandidateReport_pia');
   // Route::post('/filter-candidate-reports', [ReportController::class, 'filterCandidateReport'])->name('filterCandidateReport');
    Route::post('/filter-candidate-reports', [ReportController::class, 'filterCandidateReport']);
    Route::get('/generate-candiadte-report', [ReportController::class, 'generateCandidatesReport_Pia'])->name('generateCandidatesReport_Pia');
  //  Route::post('/load-blocks', [ReportController::class, 'loadBlocks'])->name('loadBlocksReport');
    Route::get('/load-pdf', [ReportController::class, 'testPdf'])->name('loadPdf');
});


Route::group(['middleware' => 'employer_auth'], function () {
    Route::get('/employer/dashboard', [App\Http\Controllers\Employer\EmployerController::class, 'dashboard'])->name('employer-dashboard');
    Route::get('/employer/profile', [App\Http\Controllers\Employer\EmployerController::class, 'profile'])->name('employer-profile');
    /*******************************************Admin Job Vancancies**************************************** */
    Route::get('/employer/course-list', [coursescontroller::class, 'employercourseList'])->name('employercourseList');
    Route::get('/employer/view-course/{Training?}', [coursescontroller::class, 'EmployerviewTrainingProgramme'])->name('EmployerviewTrainingProgramme');
    Route::get('/employer/JobVacancies-list', [JobVacancyController::class, 'JobVacanciesList'])->name('JobVacanciesList');
    Route::get('/employer/create-job-vacancy', [JobVacancyController::class, 'createJobVacancy'])->name('createJobVacancy');
    Route::get('/employer/view-job-vacancy/{job?}', [JobVacancyController::class, 'viewJobVacancy'])->name('viewJobVacancy');
    Route::get('/employer/edit-job-vacancy/{job?}', [JobVacancyController::class, 'editJobVacancy'])->name('editJobVacancy');
    Route::post('/employer/submit-job-vacancy-details', [JobVacancyController::class, 'submitJobVacancyDetails'])->name('submitJobVacancyDetails');
    Route::post('/employer/update-job-vacancy-details', [JobVacancyController::class, 'updateJobVacancyDetails'])->name('updateJobVacancyDetails');
    Route::post('/employer/deactivate-job-vacancy', [JobVacancyController::class, 'deactivateJobVacancy'])->name('deactivateJobVacancy');
    Route::get('/employer/candidate-list', [EmployerCandidateController::class, 'CandidateList'])->name('CandidateList');
    Route::get('/employer/candidatedetailview/{id}', [PlacementController::class, 'viewCandidateDetails'])->name('viewCandidateDetails');
    Route::post('/employer/job-notification', [PlacementController::class, 'SendJobNotification'])->name('SendJobNotification');
    Route::get('/employer/ongoing-course-list', [PlacementController::class, 'ongoingCourseList'])->name('ongoingCourseList');
    Route::get('/employer/completed-training-list', [PlacementController::class, 'completedTrainingList'])->name('completedTrainingList');
    Route::get('/employer/candidatesList/{training?}', [PlacementController::class, 'candidatesList'])->name('candidatesList');
    Route::get('/employer/applied-candidate-list', [EmployerCandidateController::class, 'AppliedCandidateList'])->name('AppliedCandidateList');
    Route::get('/employer/appliedcandidatedetailview/{job}/{candidate?}', [EmployerCandidateController::class, 'viewAppliedCandidateDetails'])->name('viewAppliedCandidateDetails');
    Route::post('/employer/notify-candidate', [RecruitmentController::class, 'SendNotificationToCandidate'])->name('SendNotificationToCandidate');
    Route::post('/employer/notify-applied-candidate', [EmployerCandidateController::class, 'SendNotificationToAppliedCandidate'])->name('SendNotificationToAppliedCandidate');
    Route::get('/employer/shortlisted-candidate-list', [RecruitmentController::class, 'ShortListedCandidateList'])->name('ShortListedCandidateList');
    Route::get('/employer/shortlisted-candidate-details/{job}/{candidate?}', [RecruitmentController::class, 'ShortListedCandidateDetails'])->name('ShortListedCandidateDetails');
    Route::get('/employer/get-candidates', [EmployerCandidateController::class, 'getCandidates'])->name('getCandidates');
    Route::get('/employer/current-employee-list', [RecruitmentController::class, 'EmployeeList'])->name('EmployeeList');
    Route::get('/employer/employee-details/{employee?}', [RecruitmentController::class, 'EmployeeDetails'])->name('EmployeeDetails');
    Route::post('/employer/update-employee', [RecruitmentController::class, 'UpdateEmployee'])->name('UpdateEmployee');
    /*******************************************End Admin Job Vancancies**************************************** */
    /******************************************* Candidate InterestingListing**************************************** */
    Route::get('/employer/CandidateInterestList', [CandidateInterestEmpController::class, 'CandidateInterestList'])->name('CandidateInterestListEmp');
    Route::get('/employer/candidateinterestdetview/{id}', [CandidateInterestEmpController::class, 'candidateInterestEmpDet'])->name('candidateInterestEmpDet');

    /*******************************************End Candidate Listing**************************************** */

});
Route::group(['middleware' => 'candidates_auth'], function () {
    Route::get('/candidates/dashboard', [App\Http\Controllers\Candidates\CandidatesController::class, 'dashboard'])->name('candidates-dashboard');
    Route::get('/view-job-alert/{notification}', [NotificationController::class, 'viewJobAlert'])->name('candidateViewJobAlert');
    Route::get('/job-alerts', [NotificationController::class, 'listJobAlerts'])->name('candidateJobAlerts');
    Route::get('/candidate/profile', [App\Http\Controllers\Candidates\CandidatesController::class, 'profile'])->name('candidate-profile');
    Route::get('/candidate-deactivate/{candidate?}', [CandidatesController::class, 'DeactivateCandidateProfile'])->name('DeactivateCandidateProfile');
    Route::get('/candidate/logout', [CandidatesController::class, 'logout'])->name('logout');
});

Route::prefix('candidate')->middleware(['candidates_auth'])->group(function () {
    Route::get('/jobs', [JobApplicationController::class, 'jobs'])->name('candidateJobs');
    Route::post('/apply-job', [JobApplicationController::class, 'applyJob'])->name('candidateApplyJob');
    Route::get('/applied-jobs', [JobApplicationController::class, 'appliedJobs'])->name('candidateAppliedJobs');
    Route::get('/jobs-once-shortlisted', [JobApplicationController::class, 'jobsOnceShortlisted'])->name('candidateJobsOnceShortlisted');
});


/*********************************Public Site*************************************/
Route::get('/', [HomeController::class, 'ShowCourse'])->name('ShowCourse');


Route::get('/contacts', [ContactUsController::class, 'ContactUs'])->name('Contacts')->middleware('web');

Route::get('/CourseList', [CourseList::class, 'CourseListview'])->name('CourseList');
Route::match(['get', 'post'], '/CourseRegistration', [RequestInterest::class, 'ViewRequestForm']);
Route::get('/CourseDetails/{id?}', [CourseList::class, 'CourseDetview']);
Route::post('/Submit-Interest', [RequestInterest::class, 'SubmitInterest'])->name('SubmitInterest');
Route::get('/Submissionsuccess', function () {
    return view('Public_site.pages.AfterInterest');

});
Route::get('/EmployerList', [HomeController::class, 'getEmployerListview'])->name('EmployerList');
Route::get('/EmployerDetails/{empId?}', [HomeController::class, 'getEmployerDetails'])->name('EmployerDetails');
Route::get('/PiaListView', [HomeController::class, 'getpiaListview'])->name('PiaListView');
Route::get('/piaDetails/{piaId?}', [HomeController::class, 'getpiaDetails'])->name('piaDetails');


Route::post('/add-trainings-to-sessions', [CourseList::class, 'addTrainingsToSession'])->name('addTrainingsToSession');
Route::post('/remove-trainings-from-sessions', [CourseList::class, 'removeTrainingsFromSessions'])->name('removeTrainingsFromSession');

Route::post('/add-coursemaster-to-session', [CourseList::class, 'addCoursemasterToSession'])->name('addCourseMasterToSession');
Route::post('/remove-course-master-from-session', [CourseList::class, 'removeCourseMasterFromSession'])->name('removeCourseMasterFromSession');

/*********************************End Public Site*************************************/

Route::get('/test-db-connection', function () {
    try {
        // Perform a simple query to check the database connection
        $users = DB::table('users')->limit(5)->get();

        // If the query succeeds, return the data
        return response()->json($users);
    } catch (\Exception $e) {
        // If an exception occurs, return an error message
        return response()->json(['error' => $e->getMessage()], 500);
    }
});

Route::middleware(['auth'])->group(function () {
    Route::post('/check-current-password', [LoginController::class, 'checkCurrentPassword'])->name('checkCurrentPassword');
});

Route::middleware(['auth', 'super_auth'])->prefix('pia-report')->group(function () {
    Route::get('/', [ReportController::class, 'piaReport'])->name('adminPiaReport');
    Route::post('/filter-pia-reports', [ReportController::class, 'filterPiaReport'])->name('adminFilterPiaReport');
    Route::get('/generate-report', [ReportController::class, 'generatePiaReport'])->name('adminPiaReportGenerateReport');
    Route::post('/reset-courses', [ReportController::class, 'resetCoursesPiaReport'])->name('adminPiaReportResetCoursesPiaReport');
    Route::post('/reset-sectors', [ReportController::class, 'resetSectorsPiaReport'])->name('adminPiaReportResetSectors');
    Route::post('/reset-pias', [ReportController::class, 'resetPiasPiaReport'])->name('adminPiaReportResetPias');

});

Route::middleware(['auth', 'super_auth'])->prefix('employed-candidates-report')->group(function () {
    Route::get('/', [ReportController::class, 'InterestedCandidatesReport'])->name('InterestedCandidatesReport');
    Route::post('/load-blocks', [ReportController::class, 'loadBlocks'])->name('loadBlocksReport');
    Route::get('/generate-report', [ReportController::class, 'generateInterestedCandidatesReport'])->name('generateInterestedCandidatesReport');

});
Route::middleware(['auth', 'super_auth'])->prefix('Candidates-Report')->group(function () {
    Route::get('/', [ReportController::class, 'CandidatesReport'])->name('CandidatesReport');
    Route::post('/filter-candidate-reports', [ReportController::class, 'filterCandidateReport'])->name('filterCandidateReport');
    Route::get('/generate-candiadte-report', [ReportController::class, 'generateCandidatesReport'])->name('generateCandidatesReport');

    // Route::POST('/loadBlocks', [ReportController::class, 'loadBlocks'])->name('loadBlocksReport');
});

Route::middleware(['auth', 'super_auth'])->prefix('employer-report')->group(function () {
    Route::get('/', [ReportController::class, 'employerReport'])->name('adminEmployerReport');
    Route::get('/generate-report', [ReportController::class, 'generateEmployerReport'])->name('adminEMPReportGenerateReport');
});



Route::get('/load-pdf', [ReportController::class, 'testPdf'])->name('loadPdf');



