<?php

use App\Http\Controllers\Admin\coursescontroller;
use App\Http\Controllers\Admin\PIAController;
use App\Http\Controllers\Employer\EmployerCandidateController;
use App\Http\Controllers\Employer\PlacementController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PublicSite\RequestInterest;
use App\Http\Controllers\Pia\CandidateInterestController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
/**********************************Public Site***************************************** */
//Route::get('list-blocks/{districtID}', 'RequestInterest@getBlocks');
Route::match(['get', 'post'],'/list-blocks/{districtID}', [RequestInterest::class, 'getBlocks']);
Route::match(['get', 'post'],'/list-localbody/{districtID}', [RequestInterest::class, 'getLocalBodyByDistrict']);
Route::match(['get', 'post'],'/list-localbodywithBlock/{districtID}', [RequestInterest::class, 'getLocalBodyByDistrictBlock']);
/********************************** End Public Site***************************************** */

Route::match(['get', 'post'],'/fetch-training/{idSector}', [coursescontroller::class, 'fetchTraining']);
Route::match(['get', 'post'],'/fetch-duration/{tradeId}', [coursescontroller::class,'fetchTradeDuration']);
//Route::get('/api/fetch-duration/{tradeId}', 'coursescontroller@fetchTradeDuration');

Route::match(['get', 'post'],'/fetch-training-code/{idTraining}', [coursescontroller::class, 'fetchTrainingCode']);
Route::match(['get', 'post'],'/fetch-localbody/{idDistrict}', [coursescontroller::class, 'fetchLocalBody']);
Route::match(['get', 'post'],'/fetch-trainings/{idSector}', [PlacementController::class, 'fetchTrainingProgrammes']);
Route::match(['get', 'post'],'/fetch-candiatelist/{DistrictId}', [CandidateInterestController::class, 'fetchcandiatelist']);
Route::match(['get', 'post'],'/fetch-candidate-list/{idQualification}', [EmployerCandidateController::class, 'fetchCandidatesList']);
Route::match(['get', 'post'],'/fetch-candidate-list-on-skills/{idSkill}', [EmployerCandidateController::class, 'fetchCandidatesListonSkill']);
Route::get('/api/fetch-courses', [PIAController::class, 'fetchCourses']);
