  
  @extends('pia.layouts.app')

  
  
@section('title','Training Training Courses')

@section('content')

<!-- Main Content -->

<!-- End of Topbar -->

<!-- Begin Page Content -->
<div class="container-fluid">

  <!-- Page Heading -->
  <!-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
      <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
      <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
              class="fas fa-download fa-sm text-white-50"></i> Generate Report</a>
  </div> -->

  <!-- Content Row -->
  <div class="row">

      <!-- Total Count -->
      <div class="col-xl-4 col-md-6 mb-4">
          <div class="card shadow h-100 py-2">
              <div class="card-body">
                  <div class="row no-gutters align-items-center">
                      <div class="col-4">
                          <img src="{{ asset('img/register.svg') }}" height="60">
                      </div>
                      <div class="col mr-2 text-center">
                          <div class="h4 mb-0 font-weight-bold text-dark"> @if (isset($data['candidatesCount']))
   {{ $data['candidatesCount']}}@endif </div>
                          <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                          No. of candidates in ongoing courses</div>
                      </div>
                  </div>
              </div>
          </div>
      </div>

      <!-- PIAs -->
      <div class="col-xl-4 col-md-6 mb-4">
          <div class="card shadow h-100 py-2">
              <div class="card-body">
                  <div class="row no-gutters align-items-center">
                      <div class="col-4">
                          <img src="{{ asset('img/tick.svg') }}" height="60">
                      </div>
                      <div class="col mr-2 text-center">
                          <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['candidatesCountCompleted']))
   {{ $data['candidatesCountCompleted']}}@endif</div>
                          <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                          No. of candidates completed the courses </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>

      <!-- Employers registered -->
      <div class="col-xl-4 col-md-6 mb-4">
          <div class="card shadow h-100 py-2">
              <div class="card-body">
                  <div class="row no-gutters align-items-center">
                      <div class="col-4">
                          <img src="{{ asset('img/recruitment.svg') }}" height="60">
                      </div>
                      <div class="col mr-2 text-center">
                          <div class="h4 mb-0 font-weight-bold text-dark">@if (isset($data['candidatesCountPlaced']))
   {{ $data['candidatesCountPlaced']}}@endif   </div>
                          <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                          No. of candidates placed</div>
                      </div>
                  </div>
              </div>
          </div>
      </div>

  </div>
  <!-- Content Row -->

  <div class="row">
      <!-- list -->
      <div class="col-xl-12 col-lg-7">
          <div class="card shadow mb-4 min_500">
              <div
                  class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                  <h6 class="m-0 font-weight-bold text-primary">Ongoing training programs</h6>
              </div>
              <!-- Card Body -->
              <div class="card-body">
                  <div class="table-responsive">
                      <table class="table table-striped">
                          <thead>
                              <tr>
                                  <th>Sl.No</th>
                                  <th>Name of Course</th>
                                  <th>No. of students joined</th>
                                  <th>End date</th>
                              </tr>
                          </thead>
                          <tbody>
                          @forelse ($data['trainigs'] as $key=>$trainig)
        <tr>
            <td>{{ $key+1 }}</td>
            <td>{{ $trainig->training_name }}</td>
            <td>{{ $trainig->total_students }}</td>
            <td>{{ $trainig->end_date }}</td>
        </tr>
    @empty
        <tr>
            <td colspan="4" align="center">Currently, there are no ongoing training programs.</td>
        </tr>
    @endforelse
                            </tbody>
                      </table>
                  </div>
              </div>
              <!-- Card Body -->
          </div>
      </div>
      <!-- list -->
  </div>

</div>

@endsection