@extends('pia.layouts.app')
@section('title','View Candidate')
@section('content')
<!-- Begin Page Content -->
<div class="container-fluid">        


 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $Candidate->name }}'s Details</h1>
     <a href="{{ route('candidateInterestList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Candidates List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">
                 <!--form action="{{ route('AssignCourse') }}"--> 
                 
                 <form id="AssignCourse"  method="post">
                      @csrf
                    <div class="row">
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Candidate Name</b></label><br>
                                 {{ $Candidate->name  }}<input type="hidden" name="cid" id="cid" value="{{ $Candidate->id  }}">
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Email ID</b></label><br>
                                 {{ $Candidate->email }}

                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Mobile Number</b></label><br>
                                {{ $Candidate->mobile_Number }}

                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Contact Number</b></label>
                              
                                @if($Candidate->phone_Number ) {{ $Candidate->phone_Number }}
                                @else 
                                </br>Nill
                                    @endif 
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Gender</b></label><br>
                                {{ $Candidate->gender }}
                             </div>
                         </div>
                        
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>DOB</b></label><br>
                                
                                 {{ date('d-m-Y', strtotime($Candidate->dob)) }}       
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Highest Qualification</b></label><br>
                                 {{ $Candidate->Highest_Qualification }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Specify the courses completed.</b></label><br>
                                {{ $Candidate->AdditionalCertificates }}
                             </div>
                         </div>
                  
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>District</b></label><br>
                                 <div class="form-group">
                                    {{ $Candidate->District->name }}
                                 </div>
                                 
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Localbody Type</b></label><br>
                                 <div class="form-group">
                                    {{ $Candidate->LocalBtype->name_eng }}
                                 </div>
                                 
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Localbody </b></label><br>
                                 <div class="form-group">
                                    {{ $Candidate->Localbody->name_eng }}
                                 </div>
                                 
                             </div>
                         </div>
</div><div class="row">
<div class="col-md-6">
                             <div class="form-group">
                                
                                
        
        <label for="" class="form-label"><b>Building Name/Number</b></label>
        <div class="form-group">
       
        @if($Candidate->building_name ) {{ $Candidate->building_name }}
        @else 
       </br>Nill
        @endif 
        
</div></div></div>
        
<div class="col-md-6">


                         

                             <div class="form-group">
                                
                                 <label for="" class="form-label"><b>Landmark</b></label>
                                 <div class="form-group">
        @if($Candidate->landmark ){{ $Candidate->landmark }}
        @else 
       </br>Nill
        @endif 
        </div>
                             </div>
                     
                             </div>

                             <div class="col-md-6">

                             <div class="form-group">

        <label for="" class="form-label"><b>Post Office</b></label>
        <div class="form-group">
       @if($Candidate->postOffice ) {{ $Candidate->postOffice }}
        @else 
       </br>Nill
        @endif                
        </div>
</div>            </div>  

<div class="col-md-6">
                             <div class="form-group">

        <label for="" class="form-label"><b>Pincode</b></label>
        <div class="form-group">
      @if($Candidate->pincode ) {{ $Candidate->pincode }}
        @else 
       </br>Nill
        @endif 
        </div>
</div>   
</div>           
            
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Religion</b></label><br>
                                 {{ $Candidate->religion }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Category</b></label><br>
                                 {{ $Candidate->category }}
                                <input type="hidden"  id="category" name="category" value="{{ $Candidate->category }}" >
                            
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Status</b></label><br>
                                 @if($Candidate->status==1) 
                                       New registration
                                @elseif($Candidate->status==2)   
                                        Joined
                                @else
                                       Completed
                                @endif
                                
                             </div>
                         </div> 
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b> Do you belong to MGNREGA Family ?</b></label><br>
                                {{ $Candidate->MGNREGA }}
                             </div>
                         </div> 
                        
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b> Willing to join for residential courses?</b></label><br>
                                {{ $Candidate->willingTojoin }}
                             </div>
                         </div>                   
                         @if($Candidate->document_upload)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">CV<span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                    <div>
                                    <a href="{{ asset('storage/cvupload/' . $Candidate->document_upload) }}" target="_blank">Click here to view the CV</a>
</div>

                                   
                                </div>
                            </div>
</div>
                            @endif
                            <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Interested Courses</b></label><br>
                                 @if ($Courses->isNotEmpty())
                                        @foreach($Courses as $key=>$valInt)
                                                                    @if($key==0)
                                                                    
                             
                                                                    <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="MasterCourse" id="{{ $valInt->CourseMaster->tradename }}" value="{{ $valInt->CourseMaster->id }}">
                                            <label class="form-check-label" for="kudMember1"> {{ $valInt->CourseMaster->tradename }}  </label>
                                        </div>
                                      
                                                                    
                                                                    @else
                                                                    <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="MasterCourse" id="{{ $valInt->CourseMaster->tradename }}" value="{{ $valInt->CourseMaster->id }}">
                                            <label class="form-check-label" for="kudMember2">{{ $valInt->CourseMaster->tradename }}</label>
                                        </div>
                                        
                                                                        
                                                                        @endif

                                                                @endforeach
                                                                @endif
                                                               
                                       
                             </div>
                             <span id="MasterCourse_error" style="color:red;"></span>
                         </div>
                         @php $tr = $training->toArray();
   
if($Candidate->training_program_id){
  
    // Assuming $Candidate->training_program_id is a single ID or an array of IDs
    $trainingProgramIds = json_decode($Candidate->training_program_id, true);
    $trainingProgramIds = array_map('intval', $trainingProgramIds);
   @endphp


<div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Interested trainigs?</b></label><br>
                                 @foreach($trainingProgramIds as $id)
                                    @php
                                        $matchingItem = collect($tr)->firstWhere('id', (int)$id);
                                        $name = $matchingItem ? $matchingItem['training_name'] : null;
                                    @endphp
                                    {{ $name }}</br>
                                    @endforeach
                             </div>
                         </div>                   
                   @php } @endphp
                         <div class="col-md-6 d-none">
                                <div class="form-group">
                                    <label for=""><b>Other Master Courses</b><span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                        <select name="ExtraMasterId"   class="form-control" id="ExtraMasterId" required>
                                            <option value="">Choose Master Course</option>
                                            @if ($Courselist->isNotEmpty())

                                                @foreach ($Courselist as $Course)

                                                <option value="{{$Course->id}}">{{$Course->tradename}}</option>
                                                @endforeach
                                                @else
                                                <option value="0">Courses List is empty</option>
                                                @endif
                                        </select>
                                        <span id="ExtraMasterId_error" style="color:red;"></span>
                                    </div>                                    
                                </div>
                            </div>
                          
                         <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Trainings<span style="color:red;">*</span></label><br>
                                    <div class="form-group">
                                        <select name="trainings"  onchange="CheckNoSeats(this.value)" class="form-control" id="trainings" name="trainings"  required>
                                            <option value="">Choose Trainings</option>
                                        </select>
                                        <span id="trainings_error" style="color:red;"></span>
                                    </div>
                                   
                                </div>
                            </div>

                            
                        </div>
                        <div class="row">
                            <div class="col-12 text-right">
                                <hr>
                                <span id="errorMessage" style="color:red;"></span>
                                <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                              <button type="button" class="btn btn-primary submit mt-0 mb-3" id="submitBtn_CourseCandidate">Submit</button>
             
                            </div>
                        </div>                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->

@endsection