    
    @extends('pia.layouts.app')

@section('title','Employer List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Employer List </h1>
           
            <a href="{{ route('piaAddEmployer') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Create New</a>

        
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                    <div style="text-align: right;">
                    <a href="{{ route('piaPendingEmployers') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Pending Employers</a>
                    <a href="{{ route('piaRejectedEmployers') }}" class="d-none d-sm-inline-block btn btn-sm btn-warning shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> Rejected Employers</a>
</div><br/>
                        <div class="table-responsive">

                        <div class="alert alert-primary" style="display:none" id="plwait">Please wait.Process in progress</div>
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Employer Name</th>
                                        <th>District</th>
                                        <th>Contact Number</th>
                                        <th>Email Id</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($employers as $key=>$employer)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $employer->name  }}</td>
                                        <td>{{ $employer->District->name }}</td>
                                        <td>{{ $employer->phone_number }}</td>
                                        <td>{{ $employer->email }}</td>

                                        <td>
                                            @if($employer->status==11)

                                              <div class="alert alert-danger">Waiting for Approval</div>

                                            @else

                                               @if($employer->status==1)

                                                    @if($employer->approval_status==11)

                                                        <div class="alert alert-warning">Approval Pending</div>

                                                    @elseif($employer->approval_status==1)

                                                    <div class="alert alert-success">Active</div>


                                                    @endif

                                               @endif


                                            @endif
                                        </td>
                                        
                                        <td>

                                            <a href="{{ route('piaViewEmployer',['id'=>base64_encode($employer->id)]) }}" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>

                                            @if(auth()->user()->user_role_id==1)

                                                @if($employer->approval_status==1)
                                            
                                                <a href="{{ route('adminEditEmployer',['id'=>base64_encode($employer->id)]) }}" class="btn btn-success btn-circle btn-sm" title="Edit">
                                                    <i class="fas fa-pen"></i>
                                                </a>

                                                @else

                                                <a href="#" class="btn btn-success btn-circle btn-sm approve-employer" data-employer="{{ base64_encode($employer->id) }}" title="Approve">
                                                    <i class="fas fa-check"></i>
                                                </a>

                                                


                                                @endif
                                            <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-employer" data-employer="{{ base64_encode($employer->id) }}" >
                                                <i class="fas fa-trash"></i>
                                            </a>

                                            @elseif(auth()->user()->user_role_id==4)

                                               @if(auth()->user()->id==$employer->created_by)

                                              <a href="{{ route('piaEditEmployer',['id'=>base64_encode($employer->id)]) }}" class="btn btn-success btn-circle btn-sm" title="Edit">
                                                <i class="fas fa-pen"></i>
                                                </a>

                                            <!--
                                                <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-employer" data-employer="{{ base64_encode($employer->id) }}" >
                                                    <i class="fas fa-trash"></i>
                                                </a>-->

                                               @endif

                                               

                                            @endif
                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection