   
@extends('pia.layouts.app')


@section('title','Edit Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Edit Employer</h1>
     <a href="{{ route('piaEmployerList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="update_employer_details" action="post" method="javascript:void(0)">
                     <div class="row">

                       @csrf

                       <input type="hidden" name="id" value="{{ $user->id }}">

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Employer Name<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="employer_name"
                                     placeholder="Employer Name" value="{{ $user->name }}" readonly>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Building Number/Name<span style="color:red">*</span></label>
                                 <input type="text" name="building_number" id="building_number" class="form-control" maxlength="50" value="{{ $user->building_name }}" placeholder="Building Number">
                                 <span style="color:red" id="building_number_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Street, Landmark<span style="color:red">*</span></label>
                                 <input type="text" name="landmark" id="landmark" class="form-control" maxlength="50" placeholder="Landmark" value="{{ $user->landmark }}">
                                 <span style="color:red" id="landmark_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Country<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="country" class="form-control" id="country" >
                                         <option value="">Choose Country</option>

                                         @foreach($countries as $country)
                                            @if($country->id==$user->country_id)
                                            <option selected="selected" value="{{ $country->id }}">{{ $country->name }}</option>
                                            @else
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                            @endif
                                         @endforeach

                                     </select>

                                     <span style="color:red" id="country_error"></span>
                                 </div>
                                 
                             </div>
                         </div>
                         
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">State<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="state" class="form-control" id="state" >
                                         <option value="">Choose State</option>

                                         @foreach($states as $state)
                                            @if($state->id==$user->state_id)
                                            <option selected="selected" value="{{ $state->id }}">{{ $state->name }}</option>
                                            @else
                                            <option value="{{ $state->id }}">{{ $state->name }}</option>
                                            @endif
                                         @endforeach

                                     </select>

                                     <span style="color:red" id="state_error"></span>
                                 </div>
                                 
                             </div>
                         </div>
                         
                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">District<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="district" class="form-control" id="district" >
                                         <option value="">Choose District</option>

                                         @foreach($districts as $district)
                                            @if($district->id==$user->district_id)
                                            <option selected="selected" value="{{ $district->id }}">{{ $district->name }}</option>
                                            @else
                                            <option value="{{ $district->id }}">{{ $district->name }}</option>
                                            @endif
                                         @endforeach

                                     </select>

                                     <span style="color:red" id="district_error"></span>
                                 </div>
                                 
                             </div>
                         </div>

                         

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Contact Number<span style="color:red;">*</span></label>
                                 <input type="text" class="form-control" name="contact_number"
                                     placeholder="Contact Number" id="contact_number" value="{{ $user->phone_number }}" maxlength="12" oninput="this.value = this.value.replace(/[^0-9]/g, '');">

                                  <span style="color:red" id="contact_number_error"></span>
                             </div>
                         </div>

                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">PAN Number<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pan_number"
                                     placeholder="PAN Number" value="{{ $user->pan_number}}" readonly>


                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Post Office<span style="color:red">*</span></label>
                                 <input type="text" name="post_office" id="post_office" class="form-control" maxlength="25" placeholder="Post Office" value="{{ $user->postOffice }}" >

                                 <span style="color:red" id="post_office_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Pincode<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pincode"
                                     placeholder="PINCODE" id="pincode" value="{{ $user->pincode }}" maxlength="6" oninput="this.value = this.value.replace(/[^0-9]/g, '');">

                                <span style="color:red" id="pincode_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Email Id<span style="color:red">*</span></label>
                                 <input type="email" class="form-control" name="email"
                                     placeholder="Email Id" value="{{ $user->email }}" readonly>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Prefered location<span style="color:red">*</span></label>
                                 <input type="text" name="prefered_location" id="prefered_location" class="form-control" maxlength="100" placeholder="Prefered location" value="{{ $user->prefered_location }}" >

                                 <span style="color:red" id="Prefered_location_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                            
                             <div class="form-group">
                                 <label for="">Cover Area<span style="color:red">*</span></label>
                                 <input type="text" name="cover_area" id="cover_area" class="form-control" maxlength="100" placeholder="Cover Area" value="{{ $user->cover_area }}" >

                                 <span style="color:red" id="Cover_area_error"></span>
                             </div>
                         </div>


                         @if($user->Document_Upload)


                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Supporting Document</label>
                                 

                                    
                                        <a href="{{ asset('storage/employer_docs/'.$user->document_upload) }}" target="_blank">Click Here to view the document</a>

                                    
                             </div>
                         </div>

                         @endif

                         



                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Update</button>
                             <button type="reset" class="btn btn-default"><a href="{{ route('piaEmployerList') }}">Cancel</a></button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection