   
@extends('pia.layouts.app')


@section('title','Add Employer')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Add Employer</h1>
    

                     @if(auth()->user()->user_role_id==4)
                     <a href="{{ route('piaEmployerList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>

            @elseif(auth()->user()->user_role_id==1)

            <a href="{{ route('employerListForAdmin') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Employer List</a>

            @endif
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="submit_employer_details" action="post" method="javascript:void(0)">
                     <div class="row">

                       @csrf

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Employer Name<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="employer_name"
                                     placeholder="Employer Name" id="employer_name" maxlength="50">
                                     <span style="color:red" id="employer_name_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Building Number/Name<span style="color:red">*</span></label>
                                 <input type="text" name="building_number" id="building_number"  maxlength="50" class="form-control" placeholder="Building Number">
                                 <span style="color:red" id="building_number_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Street, Landmark<span style="color:red">*</span></label>
                                 <input type="text" name="landmark" id="landmark" maxlength="50" class="form-control" placeholder="Landmark">
                                 <span style="color:red" id="landmark_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Country<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="country" class="form-control" id="country" >
                                         <option value="">Choose Country</option>

                                         @foreach($countries as $country)

                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                         @endforeach

                                     </select>

                                     <span style="color:red" id="country_error"></span>
                                 </div>
                                 
                             </div>
                         </div>
                         
                         
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">State<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="state" class="form-control" id="state" >
                                         <option value="">Choose State</option>

                                     </select>

                                     <span style="color:red" id="state_error"></span>
                                 </div>
                                 
                             </div>
                         </div>
                         
                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">District<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                     <select name="district" class="form-control" id="district" >
                                         <option value="">Choose District</option>
                                     </select>

                                     <span style="color:red" id="district_error"></span>
                                 </div>
                                 
                             </div>
                         </div>

                         

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Contact Number<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" id="contact_number" name="contact_number"
                                     placeholder="Contact Number" maxlength="12" oninput="this.value = this.value.replace(/[^0-9]/g, '');">

                                     <span style="color:red" id="contact_number_error"></span>
                             </div>
                         </div>

                        

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">PAN Number<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pan_number"
                                     placeholder="PAN Number" id="pan_number" maxlength="10">

                                <span style="color:red" id="pan_number_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Post Office<span style="color:red">*</span></label>
                                 <input type="text" name="post_office" class="form-control" id="post_office" maxlength="25" placeholder="Post Office" >

                                 <span style="color:red" id="post_office_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Pincode<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" name="pincode" id="pincode"
                                     placeholder="PINCODE" maxlength="6" oninput="this.value = this.value.replace(/[^0-9]/g, '');">

                                <span style="color:red" id="pincode_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Email Id<span style="color:red">*</span></label>
                                 <input type="email" class="form-control" name="email" id="email"
                                     placeholder="Email Id" maxlength="50">
                                     <span style="color:red" id="email_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Prefered Location<span style="color:red">*</span></label>
                                 <input type="text" name="prefered_location" class="form-control" id="prefered_location" maxlength="100" placeholder="Prefered Location" >

                                 <span style="color:red" id="post_office_error"></span>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Cover Area<span style="color:red">*</span></label>
                                 <input type="text" name="cover_area" class="form-control" id="cover_area" maxlength="100" placeholder="Cover Area" >

                                 <span style="color:red" id="post_office_error"></span>
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for="">Supporting Document</label>
                                 <input type="file" class="form-control" id="employer_doc" name="attachment" accept=".pdf">
                                 <small>(Max size: 2 MB)</small>
                                    <br>
                                        <span id="errorMessagedoc">Only Pdf documents of maximum size of 2MB allowed</span>
                             </div>
                         </div>

                         



                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Submit</button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection