   
@extends('pia.layouts.app')


@section('title','Add Candidate')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800">Add Candidate</h1>
    

                    
                     <a href="{{ route('adminEmployerList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Candidate List</a>

           
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">

                 <!--form-->
                 <form id="submit_employer_details" action="post" method="javascript:void(0)">
                 <h2 class="h4 mb-0 text-gray-800">Personal Details</h2><br/>
                     <div class="row">                    
                       @csrf
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Candidate Name<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" id="candidatename" maxlength="50"  placeholder="Candidate Name" name="candidatename">
                             </div>
                         </div>
                         <div class="col-md-4">                             
                                 <label for="">Gender<span style="color:red">*</span></label><br/>
                                 <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="male"  value="Male" required>
                                        <label class="form-check-label" for="gender1">Male</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="female" value="Female">
                                        <label class="form-check-label" for="gender2">Female</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="transgender"  value="Transgender">
                                        <label class="form-check-label" for="gender3">Transgender</label>
                                    </div>                            
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Date of Birth<span style="color:red">*</span></label>
                                 <input type="date" class="form-control" id="dob" name="dob" max="{{ $formattedDefaultDate }}" value="{{ $formattedDefaultDate }}"  required>
                                    <span id="dobValidationMessage"></span>                               
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Religion<span style="color:red">*</span></label>
                                 <select class="form-control" id="religion" name="religion">
                                        <option value="">select</option>
                                        <option value="Buddhists">Buddhists</option>
                                        <option value="Christian">Christian</option>
                                        <option value="Hindu">Hindu</option>
                                        <option value="Jains">Jains</option>
                                        <option value="Muslims">Muslims</option>
                                        <option value="Sikhs">Sikhs</option>
                                        <option value="Other religions">Other religions</option>
                                    </select>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Category<span style="color:red">*</span></label>
                                 <select class="form-control" id="category" name="category" required>
                                        <option>select</option>
                                        <option value="General">General</option>
                                        <option value="SC">SC</option>
                                        <option value="ST">ST</option>
                                        <option value="Minority">Minority</option>
                                    </select>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Email<span style="color:red">*</span></label>
                                 <input type="email" name="email" id="email" class="form-control" maxlength="50" onchange="liveValidateEmail()" placeholder="Email">
                                 <span id="emailValidationMessage"></span>
                                </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Mobile Numebr<span style="color:red">*</span></label>
                                 <input type="tel" class="form-control" maxlength="10" id="mobileNumber" placeholder="" name="mobileNumber"  onchange="validateMobileNumber()" required>
                                    <span id="mobValidationMessage"></span>
                                </div>
                         </div>
                    </div>
                    <h1 class="h4 mb-0 text-gray-800">Qualifications</h1><br/>
                    <div class="row">
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Highest Qualification<span style="color:red">*</span></label>
                                 <select class="form-control" id="hQualification" name="hQualification" required>
                                        <option value="">select</option>
                                        <option value=" 8th">8th</option>
                                        <option value="SSLC">SSLC</option>
                                        <option value="12th">12th</option>
                                        <option value="Diploma">Diploma</option>
                                        <option value="UG">UG</option>
                                        <option value="PG">PG</option>
                                        <option value="PG Diploma">PG Diploma</option>
                                    </select> 
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Specify the courses completed<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" id="certificate" maxlength="80" placeholder="" name="certificate" value="{{ old('certificate') }}">
                             </div>
                         </div>
                    </div>
                    <h1 class="h4 mb-0 text-gray-800">Address</h1><br/>
                    <div class="row">
                    <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Building Name/Number<span style="color:red;">*</span></label>
                                 <input type="text" class="form-control" id="BuildingName" maxlength="50" placeholder="" name="BuildingName" required>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Landmark<span style="color:red;">*</span></label>
                                 <input type="text" class="form-control" id="Landmark" maxlength="50" placeholder="" name="Landmark" required>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Post Office<span style="color:red;">*</span></label>
                                 <input type="text" class="form-control" id="PostOffice" maxlength="25" placeholder="" name="PostOffice"  required>
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Pincode<span style="color:red">*</span></label>
                                 <input type="text" class="form-control" id="PIN_Code" placeholder="" maxlength="6" name="PIN_Code" pattern="\d{6}" title="Please enter a 6-digit PIN code"  required>
                             </div>
                         </div>                   
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">District<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                 <select class="form-control" id="district" name="district" required>
                                            <option value="">Select District</option>
                                        @if ($data['district']->isNotEmpty())

                                            @foreach ($data['district'] as $district)
                                        
                                           <option value="{{$district->id}}">{{$district->name}}</option>
                                           @endforeach
                                           @else
                                           <option value="0">District List is empty</option>
                                           @endif
                                        </select>
                                 </div>                                 
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Local Body Type<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                 <select class="form-control" id="lbt" name="lbt" >
                                            <option value="0">Select Local Body Type</option>
                                        @if ($data['LocalBodyTypes']->isNotEmpty())

                                            @foreach ($data['LocalBodyTypes'] as $LBT)
                                        
                                           <option value="{{$LBT->id}}">{{$LBT->name_eng}}</option>
                                           @endforeach
                                           @else
                                           <option value="0">Local Body Type List is empty</option>
                                           @endif
                                        </select>
                                 </div>                                 
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                                 <label for="">Local Body Name<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                 <select class="form-control" id="localbody" name="localbody" >
                                            <option value="0">select Local Body</option>
                                        </select>
                                 </div>                                 
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group" id="block_div" style="display: none;">
                                 <label for="">Block<span style="color:red;">*</span></label><br>
                                 <div class="form-group">
                                 <select class="form-control" id="block_list" name="block_list">
                                            <option value="0">select Block</option>
                                        </select>
                                 </div>                                 
                             </div>
                         </div>
                        </div>
                        <h1 class="h4 mb-0 text-gray-800">Other Informations</h1><br/>
                        <div class="row">
                         <div class="col-md-4">
                             <div class="form-group">
                             <label for="">PWD<span style="color:red">*</span></label><br/>
                                 <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="pwd" id="pwd1" value="Yes" required>
                                        <label class="form-check-label" for="pwd1">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="pwd" id="pwd2" value="No">
                                        <label class="form-check-label" for="pwd2">No</label>
                                    </div>
                                
                                
                             </div>
                         </div>
                         <div class="col-md-4">
                             <div class="form-group">
                             <label for="">Ration card Type<span style="color:red">*</span></label><br/>
                                 <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio"  name="rationCard" id="rationCard1" value="APL"  required>
                                        <label class="form-check-label" for="rationCard1">APL</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="rationCard" id="rationCard2" value='BPL'>
                                        <label class="form-check-label" for="rationCard2">BPL</label>
                                    </div>  
                             </div>
                         </div>

                         <div class="col-md-4">
                             <div class="form-group">
                             <label for="">Do you belong to MGNREGA Family ?<span style="color:red">*</span></label><br/>
                                 <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="mgnrega" id="mgnrega1" value="Yes" required>
                                        <label class="form-check-label" for="mgnrega1">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="mgnrega" id="mgnrega2" value="No">
                                        <label class="form-check-label" for="mgnrega">No</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="transgender"  value="Transgender">
                                        <label class="form-check-label" for="gender3">Transgender</label>
                                    </div>   
                             </div>
                         </div>

                         <div class="col-md-4">
                             <div class="form-group">
                             <label for="">Kudumbashree Member<span style="color:red">*</span></label><br/>
                                 <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="kudMember" id="kudMember1" value="Yes" required>
                                        <label class="form-check-label" for="kudMember1">Yes</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio"  name="kudMember" id="kudMember2" value="No">
                                        <label class="form-check-label" for="kudMember2">No</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="gender" id="transgender"  value="Transgender">
                                        <label class="form-check-label" for="gender3">Transgender</label>
                                    </div>   
                             </div>
                         </div>
                     </div>
                     <div class="row">
                         <div class="col-12 text-right">
                             <hr>
                             <div id="ajax-loader" style="display:none" class="alert alert-info">Please wait.Process in progress.......</div>
                             <button type="submit" class="btn btn-primary">Submit</button>
                         </div>
                     </div>

                 </form>
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->

@endsection