<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="{{ asset('img/favicon.png') }}" />
    <meta name="description" content="Kudumbashree">
    <meta name="author" content="Kudumbashree">
    <title>Kudumbashree</title>

    <!-- Custom fonts for this template-->
    <link href="{{asset('vendor/fontawesome-free/css/all.min.css')}}" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="{{asset('css/kudumbashree.css')}}" rel="stylesheet">

</head>

<body class="bg-gradient-primary">

    <div class="container">

        <!-- Outer Row -->
        <div class="row justify-content-center">

            <div class="col-xl-10 col-lg-12 col-md-9">

                <div class="card o-hidden border-0 shadow-lg my-5">
                    <div class="card-body p-0">
                        <!-- Nested Row within Card Body -->
                        <div class="row">
                            <div class="col-lg-6 d-none d-lg-block bg-login-image"></div>
                            <div class="col-lg-6">
                                <div class="p-5">
                                    <div class="text-center">
                                        <h1 class="h4 text-gray-900 mb-4">Reset Password</h1>
                                    </div>
                                    <form class="user"  method="post" id="password_reset_form" action="{{url('/loginView')}}" enctype="multipart/form-data">
                                        {{ csrf_field() }}
                                        <div class="form-group" style="color: red">
                                            @if($errors->any())
                                                <h4>{{$errors->first()}}</h4>
                                            @endif
                                        <div class="form-group">
                                            <input type="email" class="form-control form-control-user" id="exampleInputEmail1"
                                            aria-describedby="" name="email" placeholder="Enter Email Address..." value="{{ old('Username') }}" maxlength="50" onchange="liveValidateEmail()" required>
                                            <i class="mdi mdi-account"></i>
                                            <span id="emailValidationMessage"></span>
                                        
                                        </div>
                                        
                                        <input class="btn btn-block btn btn-primary btn-user" id="login_btn" type="submit" value="Continue">

                                        <br><br>
                                        <div class="alert alert-info" style="display:none" id="response_message">Please wait for some seconds</div>

                                        <span style="color:red" id="password_reset_error"></span>
                                  
                                    </form>
                                    <hr><!--class="btn btn-primary btn-user btn-block"-->
                                    <div class="text-center">
                                        <a class="small" href="{{ route('login') }}">Login</a>
                                    </div>
                                   <!-- <div class="text-center">
                                        <a class="small" href="#">Create an Account!</a>
                                    </div>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>

    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="{{asset('vendor/jquery/jquery.min.js')}}"></script>

    <script>

$(document).ready(function()
{

    
    $(document).on("submit","#password_reset_form",function(e)
    {

       
        e.preventDefault();

        $("#emailValidationMessage").hide();

        var form_data=new FormData($(this)[0]);

        $("#response_message").show();

        $.ajax({
            headers:{'X-CSRF-TOKEN':"{{ csrf_token() }}"},
            url:"{{ route('requestPasswordReset') }}",
            type:"POST",
            data:form_data,
            dataType:"JSON",
            contentType:false,
            processData:false,
            success:function(response)
            {

                if(response.status=="success")
                {
                    window.location.href=response.redirect_url;
                }

                else{

                    $("#password_reset_error").html(response.message);
                    $("#response_message").html("");
                    $("#response_message").hide();
                }

               

            },
            error:function()
            {
                $("#password_reset_error").html("Something went wrong");
                $("#response_message").hide();
            }
        });

        
    });
});

</script>
    <script src="{{asset('vendor/bootstrap/js/bootstrap.bundle.min.js')}}"></script>

    <!-- Core plugin JavaScript-->
    <script src="{{asset('vendor/jquery-easing/jquery.easing.min.js')}}"></script>

    <!-- Custom scripts for all pages-->
    <script src="{{asset('js/sb-admin-2.min.js')}}"></script>
    <script src="{{asset('js/custom-new.js')}}"></script>


    <script>
        function liveValidateEmail() {
            var emailInput = document.getElementById('exampleInputEmail1');
            var email = emailInput.value;

            // Use a regular expression for basic email validation
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

            var validationMessage = document.getElementById('emailValidationMessage');

            if (emailPattern.test(email)) {
                validationMessage.textContent = 'Email is valid';
                validationMessage.style.color = 'green';
            } else {
                validationMessage.textContent = 'Invalid email ID';
                validationMessage.style.color = 'red';
            }
        }
    </script>

    </body>

</html>