   
   @extends('employer.layouts.app')


@section('title','View TTraining Programme')


@section('content')



<!-- Begin Page Content -->
<div class="container-fluid">

        

 <!-- Page Heading -->
 <div class="d-sm-flex align-items-center justify-content-between mb-4">
     <h1 class="h4 mb-0 text-gray-800"> {{ $course->training_name }} Details</h1>
     <a href="{{ route('employercourseList') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                     class="fas fa-add fa-sm text-white-50"></i> Training Programme List</a>
 </div>

 <div class="row">
     <!-- Add -->
     <div class="col-xl-12 col-lg-7">
         <div class="card shadow mb-4 min_500">
             <!-- Card Body -->
             <div class="card-body">
             <div style="text-align: right;">
                    
                    <span class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                    class="fas fa-sm text-white-50"></i>Training Programme Status : 
                    @if($course->course_status==7)
                                        In Progress

                                    @elseif($course->course_status==3)
                                     Completed

                                    @elseif($course->course_status==9)
                                        Cancelled

                                    @elseif($course->course_status==10)
                                       Postponed
                                    @endif
                    </span>
                    
</div><br/>
                 <!--form-->
                
                     <div class="row">

                     <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Sector</b></label><br>
                                 <div class="form-group">
                                    {{ $course->GetSector->name }}
                                 </div>                               
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Trade Name</b></label><br>
                                 <div class="form-group">
                                    {{ $course->GetCourseMaster->tradename }}
                                 </div>                               
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Number of candidates</b></label><br>
                                 <div class="form-group">
                                    {{ $can_count[0]->total_students }}
                                 </div>                               
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Trade Code</b></label><br>
                                 <div class="form-group">
                                    {{ $course->GetCourseMaster->tradecode }}
                                 </div>                               
                             </div>
                         </div>


                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Name</b></label><br>
                                 {{ $course->training_name  }}
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Programme Description</b></label><br>
                                 {{ $course->description  }}
                             </div>
                         </div>

                       

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for=""><b>District</b></label><br>
                                <div class="form-group">
                                    {{ $course->GetDistrict->name }}
                                </div>                                
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for=""><b>Local Body</b></label><br>
                                <div class="form-group">
                                    {{ $course->GetLocalBody->name_eng }}
                                </div>                                
                            </div>
                        </div>

                        <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Training Venue</b></label><br>
                                 <div class="form-group">
                                 {!! $course->venue !!}
                                 </div>                                
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Start Date</b></label><br>
                                 {{ date('d-m-Y', strtotime($course->start_date)) }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>End Date</b></label><br>
                                 {{ date('d-m-Y', strtotime($course->end_date)) }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Duration</b></label><br>
                                {{ $course->duration }}
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Total Number of Seats</b></label><br>
                                 <div class="form-group">
                                     {{ $course->no_of_seats }}
                                 </div>
                                 
                             </div>
                         </div>

                         <div class="col-md-6">
                             <div class="form-group">
                                 <label for=""><b>Potential Employers</b></label><br>
                                 <div class="form-group">
                                    @if(isset($course->future_possibilities))
                                    {{ $course->future_possibilities }}
                                    @else
                                    NIL 
                                    @endif
                                 </div>                               
                             </div>
                         </div>


                        
                         <div class="col-md-12">
                             <div class="form-group">
                                <label for=""><b>Skills</b></label><br>
                                <div class="form-group">
                                     @foreach($course->SkillList as $key=>$skill)
                                     @if($key==0)
                                     {{ $skill->Skill->name }}
                                     @else
                                     ,{{ $skill->Skill->name }}
                                     @endif
                                     @endforeach
                                 </div>                                
                             </div>
                         </div>
                
                     </div>
                    
                 <!--form-->

             </div>
             <!-- Card Body -->
         </div>
     </div>
     <!-- Add -->
 </div>

</div>
<!-- /.container-fluid -->




@endsection