@extends('employer.layouts.app')

@section('title','Training Programme List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">Training Programme List </h1>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Name of Training Programme</th>
                                        <th>Program Implementing Agency</th>
                                        <th>Venue</th>
                                        <th>District</th>
                                        <th>Number of candidates</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($courses as $key=>$course)
                                        <tr>
                                            <td>{{ ($key+1) }}</td>

                                            <td>{!! $course->training_name !!}</td>

                                            <td>{!! $course->agency_name !!}</td>

                                            <td>{!! $course->venue !!}</td>

                                            <td>{!! $course->district !!}</td>

                                            <td>{!! $course->total_students !!}</td>

                                            <td>
                                                @if($course->course_status==7)
                                                    <span class="badge badge-info">In Progress</span>

                                                @elseif($course->course_status==3)
                                                    <span class="badge badge-info">Completed</span>

                                                @elseif($course->course_status==9)
                                                    <span class="badge badge-info">Canceled</span>

                                                @elseif($course->course_status==10)
                                                    <span class="badge badge-info">Postponed</span></td>
                                                @endif
                                            </td>

                                            <td>

                                                <a href="{{ route('EmployerviewTrainingProgramme',['Training'=>base64_encode($course->id)]) }}" class="btn btn-info btn-circle btn-sm"><i class="fas fa-eye"></i>
                                                </a>

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection