@extends('admin.layouts.app')

@section('title','JobVacancies List')

@section('content')


 

    <!-- Begin Page Content -->
    <div class="container-fluid">


        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h4 mb-0 text-gray-800">JobVacancies List </h1>
            <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                    class="fas fa-add fa-sm text-white-50"></i> New JobVacancies</a>
        </div>

        <div class="row">
            <!-- list -->
            <div class="col-xl-12 col-lg-7">
                <div class="card shadow mb-4 min_500">
                    <!-- Card Body -->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Sl.No</th>
                                        <th>Sector Name</th>
                                       
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>


                                @foreach($sector_details as $key=>$sector)
                                    <tr>
                                        <td>{{ ($key+1) }}</td>
                                        <td>{{ $sector->name  }}</td>
                                        
                                        <td>

                                            <a href="#" class="btn btn-info btn-circle btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                           
                                            <a href="#" class="btn btn-success btn-circle btn-sm">
                                                <i class="fas fa-pen"></i>
                                            </a>
                                            <a href="#" class="btn btn-danger  btn-circle btn-sm deactivate-sector" data-pia-id="">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>

                                @endforeach
                                   
                                    
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Card Body -->
                </div>
            </div>
            <!-- list -->
        </div>

    </div>
    <!-- /.container-fluid -->

<!--</div>-->

@endsection