@extends('employer.layouts.app')
  
@section('content')
<div class="row">
        <!-- list -->
        <div class="col-xl-12 col-lg-7">
            <div class="card shadow mb-4 min_500">
                <div
                    class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Course Completed Candidate List</h6>
                </div>
                <br></br><div style="text-align: right;">
                    
                    <span class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm"><i
                        class="fas fa-sm text-white-50"></i>Placement Count: 
                        {{ $placed_count }}
                    </span><br></br>
                        
                </div><br/>

                <!-- Card Body -->
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="dataTable">
                            <thead>
                                <tr>
                                    <th>Sl.No</th>
                                    <th>Candidate Name</th>
                                    <th>Address</th>
                                    <th>Mobile Number</th>
                                    <th>Email Id</th>
                                    <th>Highest Qualification</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach ($candidates as $key=>$candidate)
                                <tr>
                                    <td>{{ ($key+1) }}</td>
                                    <td>{{$candidate->name}}</td>
                                    <td>{{ $candidate->building_name }}</br>{{ $candidate->landmark }}
                                    </br>{{ $candidate->postOffice }}</br>{{ $candidate->pincode }}</td>
                                    <td>{{$candidate->mobile_number}}</td>
                                    <td>{{$candidate->email}}</td>
                                    <td>{{$candidate->highest_qualification }}</td>
                                    <td>
                                        <a href="{{ url('/employer/candidatedetailview') }}/{!!$candidate->id!!}" class="btn btn-info btn-circle btn-sm" title="View Details">
                                                    <i class="fas fa-eye"></i>       
                                    </td>
                                </tr>
                            @endforeach 
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Card Body -->
  
           

@endsection